/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.TStoreBTreeCompactor;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.compaction.CompactorConstructorFn;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.spi.properties.HazelcastProperties;

public class TStoreBTreeCompactorConstructorFn
implements CompactorConstructorFn {
    private final int nodeSize;
    private final HybridLogImpl log;
    private final Epoch epoch;
    private final TStoreBTreeCompactor.Dependencies dependencies;
    private final HazelcastProperties properties;

    public TStoreBTreeCompactorConstructorFn(int nodeSize, HybridLogImpl log, Epoch epoch, TStoreBTreeCompactor.Dependencies dependencies, HazelcastProperties properties) {
        this.nodeSize = nodeSize;
        this.log = log;
        this.epoch = epoch;
        this.dependencies = dependencies;
        this.properties = properties;
    }

    @Override
    public Compactor<?> newIncrementalCompactor(int segmentNo) {
        return new TStoreBTreeCompactor(this.nodeSize, this.log, this.epoch, this.dependencies, segmentNo, this.properties);
    }

    @Override
    public Compactor<?> newFullCompactor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIncrementalSupported() {
        return true;
    }

    @Override
    public boolean isFullSupported() {
        return false;
    }
}

