/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.HashIndexKey;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

public class HashIndexBPlusTreeKeyComparator
implements BPlusTreeKeyComparator {
    private final EnterpriseSerializationService ess;

    public HashIndexBPlusTreeKeyComparator(EnterpriseSerializationService ess) {
        this.ess = ess;
    }

    @Override
    public int compare(Comparable left, long rightAddress, long rightPayload) {
        long rightIndexKeyHash;
        HashIndexKey leftIndexKey = (HashIndexKey)left;
        if (leftIndexKey == null) {
            return rightAddress == 0L ? 0 : -1;
        }
        long leftIndexKeyHash = leftIndexKey.getIndexKeyHash(this.ess);
        if (leftIndexKeyHash == (rightIndexKeyHash = rightPayload)) {
            Data leftData = leftIndexKey.getIndexKeyData(this.ess);
            NativeMemoryData rightData = new NativeMemoryData().reset(rightAddress);
            return this.compareSerializedKeys(leftData, rightData);
        }
        return leftIndexKeyHash < rightIndexKeyHash ? -1 : 1;
    }

    @Override
    public int compare(Comparable left, Comparable right) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Comparable wrapIndexKey(Comparable indexKey) {
        assert (!(indexKey instanceof HashIndexKey));
        if (indexKey == null) {
            return indexKey;
        }
        HashIndexKey wrappedIndexKey = new HashIndexKey(indexKey);
        return wrappedIndexKey;
    }

    @Override
    public Comparable unwrapIndexKey(Comparable indexKey) {
        if (indexKey == null) {
            return indexKey;
        }
        if (indexKey instanceof HashIndexKey) {
            HashIndexKey key = (HashIndexKey)indexKey;
            return key.getIndexKey();
        }
        return indexKey;
    }
}

