/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.CompositeKeyComparison;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBPlusTree;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

abstract class HDBTreeNodeBaseAccessor {
    static final int OFFSET_LOCK_STATE = 0;
    static final int OFFSET_SEQUENCE_NUMBER = 8;
    static final int OFFSET_LEVEL = 16;
    static final int OFFSET_KEYS_COUNT = 17;
    static final int OFFSET_STATS = 19;
    static final int OFFSET_NODE_BASE_DATA = 20;
    static final int OFFSET_NODE_CONTENT = 16;
    static final byte STATS_PAYLOAD_MASK = 1;
    static final int SLOT_ENTRY_OFFSET_BYTE_LENGTH = 2;
    static final int PAYLOAD_BYTE_LENGTH = 8;
    static final int CHILD_OR_VALUE_ADDRESS_BYTE_LENGTH = 8;
    static final int MAX_LEVEL = 255;
    static final int MAX_NODE_SIZE = 1048575;
    static final int MIN_NODE_SIZE = 128;
    final LockManager lockManager;
    final EnterpriseSerializationService ess;
    final BPlusTreeKeyComparator keyComparator;
    final BPlusTreeKeyAccessor keyAccessor;
    final MemoryAllocator keyAllocator;
    final MemoryAllocator btreeAllocator;
    final int nodeSize;
    final EntrySlotPayload entrySlotPayload;
    final boolean isPayloadSet;
    NodeSplitStrategy nodeSplitStrategy;

    HDBTreeNodeBaseAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        this.lockManager = lockManager;
        this.ess = ess;
        this.keyComparator = keyComparator;
        this.keyAccessor = keyAccessor;
        this.keyAllocator = keyAllocator;
        this.btreeAllocator = btreeAllocator;
        this.nodeSize = nodeSize;
        this.nodeSplitStrategy = nodeSplitStrategy;
        this.entrySlotPayload = entrySlotPayload;
        this.isPayloadSet = entrySlotPayload.getPayloadSize() > 0;
    }

    int getKeyPartition(Data key) {
        return 0;
    }

    void allocateLogical(long stableAddress, LockingContext lockingContext) {
    }

    boolean isAllocated(long stableAddress) {
        return true;
    }

    long translateToLogical(long stableAddress, LockingContext lockingContext) {
        return stableAddress;
    }

    long translateToPhysical(long stableAddress, LockingContext lockingContext) {
        return stableAddress;
    }

    boolean requiresUnlockBeforeNodeDisposal() {
        return true;
    }

    long tryLockRecord(int partition, long keyHash) {
        return 1L;
    }

    void yield(int partition) {
    }

    void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
    }

    void unlockRecord(int partition, long keyHash, long cookie) {
    }

    void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
    }

    void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
    }

    void unpin(LockingContext lockingContext, long stableAddress) {
    }

    void ensureReadable(long stableAddress, LockingContext lockingContext) {
    }

    void ensureWritable(long stableAddress, LockingContext lockingContext) {
    }

    void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
    }

    long newNodeLocked(LockingContext lockingContext) {
        long address = this.getBtreeAllocator().allocate(this.nodeSize);
        long lockAddr = this.getLockStateAddr(address);
        this.lockManager.writeLock(lockAddr);
        lockingContext.addLock(lockAddr);
        this.pinAndReplaceLastUnpinned(-address, lockingContext);
        this.allocateLogical(address, lockingContext);
        this.setNodeLevel(address, 0, lockingContext);
        this.setKeysCount(address, 0, lockingContext);
        this.setStatsPayloadMask(address, lockingContext);
        return address;
    }

    private void setStatsPayloadMask(long nodeAddr, LockingContext lockingContext) {
        if (!this.isPayloadSet) {
            return;
        }
        byte mask = this.getStats(nodeAddr, lockingContext);
        mask = (byte)(mask | 1);
        this.setStats(nodeAddr, mask, lockingContext);
    }

    void disposeNode(long nodeAddr) {
        if (nodeAddr != 0L) {
            this.getBtreeAllocator().free(nodeAddr, this.nodeSize);
        }
    }

    abstract int getOffsetEntries();

    abstract long split(long var1, LockingContext var3);

    abstract int getSeparationSlot(long var1, LockingContext var3);

    void setNodeSplitStrategy(NodeSplitStrategy strategy) {
        this.nodeSplitStrategy = strategy;
    }

    byte getStats(long nodeAddr, LockingContext lockingContext) {
        return GlobalMemoryAccessorRegistry.AMEM.getByte(this.translateToPhysical(nodeAddr, lockingContext) + 19L);
    }

    void setStats(long nodeAddr, byte stats, LockingContext lockingContext) {
        GlobalMemoryAccessorRegistry.AMEM.putByte(this.translateToPhysical(nodeAddr, lockingContext) + 19L, stats);
    }

    long getLockStateAddr(long nodeAddr) {
        return nodeAddr + 0L;
    }

    long getLockState(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.getLockStateAddr(nodeAddr));
    }

    int getNodeLevel(long nodeAddr, LockingContext lockingContext) {
        return GlobalMemoryAccessorRegistry.AMEM.getByte(this.translateToPhysical(nodeAddr, lockingContext) + 16L) & 0xFF;
    }

    void setNodeLevel(long nodeAddr, int level, LockingContext lockingContext) {
        GlobalMemoryAccessorRegistry.AMEM.putByte(this.translateToPhysical(nodeAddr, lockingContext) + 16L, (byte)level);
    }

    boolean isInnerNode(long nodeAddr, LockingContext lockingContext) {
        return this.getNodeLevel(nodeAddr, lockingContext) > 0;
    }

    int getKeysCount(long nodeAddr, LockingContext lockingContext) {
        return GlobalMemoryAccessorRegistry.AMEM.getShort(this.translateToPhysical(nodeAddr, lockingContext) + 17L);
    }

    void setKeysCount(long nodeAddr, int count, LockingContext lockingContext) {
        GlobalMemoryAccessorRegistry.AMEM.putShort(this.translateToPhysical(nodeAddr, lockingContext) + 17L, (short)count);
    }

    int spaceNeeded(NativeMemoryData indexKey, NativeMemoryData entryKey) {
        return this.memoryNeededForSlotEntry(indexKey, entryKey) + 2;
    }

    int spaceNeeded(long nodeAddr, int slot, LockingContext lockingContext) {
        int keysCount = this.getKeysCount(nodeAddr, lockingContext);
        assert (slot < keysCount);
        long slotAddr = this.getSlotAddr(nodeAddr, slot, lockingContext);
        long entryKeyAddr = this.getEntryKeyAddr(nodeAddr, slot, lockingContext);
        return (int)(entryKeyAddr + (long)this.readKeySize(entryKeyAddr) - slotAddr) + 2;
    }

    boolean isNodeFull(long nodeAddr, NativeMemoryData indexKey, NativeMemoryData entryKey, LockingContext lockingContext) {
        int keysCount = this.getKeysCount(nodeAddr, lockingContext);
        if (keysCount == 0) {
            return false;
        }
        int spaceNeeded = this.memoryNeededForSlotEntry(indexKey, entryKey) + 2;
        return !this.canAccommodate(nodeAddr, spaceNeeded, lockingContext);
    }

    int freeSpace(long nodeAddr, LockingContext lockingContext) {
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        if (lastSlot == -1) {
            return this.nodeSize - this.getOffsetEntries();
        }
        int freeSpace = (int)(this.getSlotEntryOffsetAddr(nodeAddr, 0, lockingContext) - this.freeSpaceBeginAddr(nodeAddr, lockingContext));
        assert (freeSpace <= this.nodeSize) : "freeSpace=" + freeSpace;
        return freeSpace;
    }

    abstract long freeSpaceBeginAddr(long var1, LockingContext var3);

    boolean canAccommodate(long dstNodeAddr, int size, LockingContext lockingContext) {
        return this.freeSpace(dstNodeAddr, lockingContext) >= size;
    }

    long getSequenceNumber(long nodeAddr, LockingContext lockingContext) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.translateToPhysical(nodeAddr, lockingContext) + 8L);
    }

    void setSequenceCounter(long nodeAddr, long value, LockingContext lockingContext) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.translateToPhysical(nodeAddr, lockingContext) + 8L, value);
    }

    void incSequenceCounter(long nodeAddr, LockingContext lockingContext) {
        long sequenceNumber = this.getSequenceNumber(nodeAddr, lockingContext);
        this.setSequenceCounter(nodeAddr, sequenceNumber + 1L, lockingContext);
    }

    Data getIndexKeyHeapData(long nodeAddr, int slot, LockingContext lockingContext) {
        long indexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot, lockingContext);
        return this.keyAccessor.convertToHeapData(indexKeyAddr);
    }

    Data getIndexKeyHeapDataOrNull(long nodeAddr, int slot, LockingContext lockingContext) {
        long indexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot, lockingContext);
        if (indexKeyAddr == 0L) {
            return null;
        }
        return this.keyAccessor.convertToHeapData(indexKeyAddr);
    }

    long getIndexKeyAddr(long nodeAddr, int slot, LockingContext lockingContext) {
        long indexKeyAddr = this.getSlotAddr(nodeAddr, slot, lockingContext) + 8L;
        if (this.isPayloadSet) {
            indexKeyAddr += 8L;
        }
        return indexKeyAddr;
    }

    NativeMemoryData getEntryKey(long nodeAddr, int slot, LockingContext lockingContext) {
        return new NativeMemoryData().reset(this.getEntryKeyAddr(nodeAddr, slot, lockingContext));
    }

    long getEntryKeyAddr(long nodeAddr, int slot, LockingContext lockingContext) {
        long indexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot, lockingContext);
        return indexKeyAddr + (long)this.readKeySize(indexKeyAddr);
    }

    abstract void removeLastKSlotEntries(long var1, int var3, LockingContext var4);

    void insertSlot(long nodeAddr, int slot, NativeMemoryData indexKey, NativeMemoryData entryKey, long valueOrChildAddr, LockingContext lockingContext) {
        long memCpyEndAddr;
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        if (lastSlot == -1) {
            this.writeSlotEntryContents(this.freeSpaceBeginAddr(nodeAddr, lockingContext), indexKey, entryKey, valueOrChildAddr);
            this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr, lockingContext) + 1, lockingContext);
            this.setSlotEntryOffset(nodeAddr, 0, 0, lockingContext);
            return;
        }
        int memoryNeeded = this.memoryNeededForSlotEntry(indexKey, entryKey);
        assert (this.freeSpace(nodeAddr, lockingContext) >= memoryNeeded + 2);
        long memCpyStartAddr = memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr, lockingContext);
        if (slot <= lastSlot) {
            memCpyStartAddr = this.getSlotAddr(nodeAddr, slot, lockingContext);
            assert (memCpyStartAddr <= memCpyEndAddr) : "lastSlot=" + lastSlot + ", slot=" + slot;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, memCpyStartAddr + (long)memoryNeeded, memCpyEndAddr - memCpyStartAddr);
            this.updateSlotOffsets(nodeAddr, slot, lastSlot, memoryNeeded, lockingContext);
        }
        this.insertToOffsetArr(nodeAddr, slot, lockingContext);
        this.writeSlotEntryContents(memCpyStartAddr, indexKey, entryKey, valueOrChildAddr);
        this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr, lockingContext) + 1, lockingContext);
        this.setSlotEntryOffset(nodeAddr, slot, (int)(memCpyStartAddr - (this.translateToPhysical(nodeAddr, lockingContext) + (long)this.getOffsetEntries())), lockingContext);
    }

    void removeSlot(long nodeAddr, int slot, LockingContext lockingContext) {
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        if (this.isInnerNode(nodeAddr, lockingContext) ? !$assertionsDisabled && lastSlot <= 0 : !$assertionsDisabled && lastSlot < 0) {
            throw new AssertionError();
        }
        if (lastSlot == 0) {
            assert (slot == lastSlot) : "trying to remove slot=" + slot + " whereas, lastSlot" + lastSlot;
            this.setKeysCount(nodeAddr, 0, lockingContext);
            return;
        }
        if (slot < lastSlot) {
            long memCpyStartAddr = this.getSlotAddr(nodeAddr, slot + 1, lockingContext);
            long memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr, lockingContext);
            int shift = (int)(this.getSlotAddr(nodeAddr, slot, lockingContext) - memCpyStartAddr);
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, memCpyStartAddr + (long)shift, memCpyEndAddr - memCpyStartAddr);
            this.updateSlotOffsets(nodeAddr, slot + 1, lastSlot, shift, lockingContext);
        }
        if (slot != 0) {
            long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0, lockingContext);
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr + 2L, (long)slot * 2L);
        }
        this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr, lockingContext) - 1, lockingContext);
    }

    private void updateSlotOffsets(long nodeAddr, int startSlot, int endSlotInclusive, int deltaToAdd, LockingContext lockingContext) {
        for (int i = startSlot; i <= endSlotInclusive; ++i) {
            int offset = this.getSlotEntryOffset(nodeAddr, i, lockingContext);
            this.setSlotEntryOffset(nodeAddr, i, offset + deltaToAdd, lockingContext);
        }
    }

    private void insertToOffsetArr(long nodeAddr, int slot, LockingContext lockingContext) {
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        if (lastSlot == -1 || slot == 0) {
            return;
        }
        long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0, lockingContext);
        long prevSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, slot - 1, lockingContext);
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr - 2L, prevSlotEntryOffsetAddr - zerosSlotEntryOffsetAddr + 2L);
    }

    abstract int getLastSlot(long var1, LockingContext var3);

    private int memoryNeededForSlotEntry(NativeMemoryData indexKey, NativeMemoryData entryKey) {
        return 8 + (this.isPayloadSet ? 8 : 0) + indexKey.size() + entryKey.size();
    }

    private void writeSlotEntryContents(long slotAddr, NativeMemoryData indexKey, NativeMemoryData entryKey, long valueOrChildAddr) {
        long writeAddr = slotAddr;
        GlobalMemoryAccessorRegistry.AMEM.putLong(writeAddr, valueOrChildAddr);
        writeAddr += 8L;
        if (this.isPayloadSet) {
            this.entrySlotPayload.setPayload(writeAddr, indexKey.address());
            writeAddr += 8L;
        }
        indexKey.copyTo(0L, null, writeAddr, indexKey.size());
        entryKey.copyTo(0L, null, writeAddr += (long)indexKey.size(), entryKey.size());
    }

    int readKeySize(long address) {
        return this.readSize(address, this.nodeSize);
    }

    int readValueSize(long address) {
        return this.readSize(address, Integer.MAX_VALUE);
    }

    int readSize(long address, int maxSize) {
        assert (address > 0L);
        int size = GlobalMemoryAccessorRegistry.MEM.getInt(address) + 4;
        assert (size > 0 && size < maxSize) : "size=" + size;
        return size;
    }

    Data getValue(long nodeAddr, int slot, int partition, Data entryKey) {
        long valueAddr = this.getValueAddr(nodeAddr, slot, null);
        return new NativeMemoryData(valueAddr, this.readValueSize(valueAddr));
    }

    long getValueAddr(long nodeAddr, int slot, LockingContext lockingContext) {
        long slotAddr = this.getSlotAddr(nodeAddr, slot, lockingContext);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(slotAddr);
    }

    long getPayloadOrZero(long nodeAddr, int slot, LockingContext lockingContext) {
        if (!this.isPayloadSet) {
            return 0L;
        }
        long payloadAddr = this.getSlotAddr(nodeAddr, slot, lockingContext) + 8L;
        return this.entrySlotPayload.getPayload(payloadAddr);
    }

    void setValueAddr(long nodeAddr, int slot, long valueAddr, LockingContext lockingContext) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.getSlotAddr(nodeAddr, slot, lockingContext), valueAddr);
    }

    CompositeKeyComparison compareKeys(Comparable leftIndexKey, Data leftEntryKey, long nodeAddr, int slot, LockingContext lockingContext) {
        return this.compareKeys(leftIndexKey, leftEntryKey, nodeAddr, slot, false, lockingContext);
    }

    CompositeKeyComparison compareKeys(Comparable leftIndexKey, Data leftEntryKey, long nodeAddr, int slot, boolean cmpOnlyIndexKeyPart, LockingContext lockingContext) {
        long rightPayload;
        long rightIndexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot, lockingContext);
        int cmp = this.keyComparator.compare(leftIndexKey, rightIndexKeyAddr, rightPayload = this.getPayloadOrZero(nodeAddr, slot, lockingContext));
        if (cmp == 0 && !cmpOnlyIndexKeyPart) {
            if (leftEntryKey == HDBPlusTree.PLUS_INFINITY_ENTRY_KEY) {
                return CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_GREATER;
            }
            if (leftEntryKey == HDBPlusTree.MINUS_INFINITY_ENTRY_KEY) {
                return CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_LESS;
            }
            long rightEntryKeyAddr = this.getEntryKeyAddr(nodeAddr, slot, lockingContext);
            if (rightEntryKeyAddr == 0L) {
                return leftEntryKey == null ? CompositeKeyComparison.KEYS_EQUAL : CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_GREATER;
            }
            if (leftEntryKey == null) {
                return CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_LESS;
            }
            NativeMemoryData rightEntryKey = this.getEntryKey(nodeAddr, slot, lockingContext);
            int cmp2 = this.keyComparator.compareSerializedKeys(leftEntryKey, rightEntryKey);
            return cmp2 < 0 ? CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_LESS : (cmp2 == 0 ? CompositeKeyComparison.KEYS_EQUAL : CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_GREATER);
        }
        return cmp < 0 ? CompositeKeyComparison.INDEX_KEY_LESS : (cmp == 0 ? CompositeKeyComparison.KEYS_EQUAL : CompositeKeyComparison.INDEX_KEY_GREATER);
    }

    int lowerBound(long nodeAddr, Comparable indexKey, Data entryKey, LockingContext lockingContext) {
        int mid;
        assert (indexKey != null);
        int lower = 0;
        int upper = this.getKeysCount(nodeAddr, lockingContext) - 1;
        while (true) {
            if (upper < lower) {
                return lower;
            }
            mid = (upper + lower) / 2;
            CompositeKeyComparison cmp = this.compareKeys(indexKey, entryKey, nodeAddr, mid, lockingContext);
            if (CompositeKeyComparison.less(cmp)) {
                upper = mid - 1;
                continue;
            }
            if (!CompositeKeyComparison.greater(cmp)) break;
            lower = mid + 1;
        }
        return mid;
    }

    long getSlotAddr(long nodeAddr, int slot, LockingContext lockingContext) {
        return this.translateToPhysical(nodeAddr, lockingContext) + (long)this.getOffsetEntries() + (long)this.getSlotEntryOffset(nodeAddr, slot, lockingContext);
    }

    void setSlotEntryOffset(long nodeAddr, int slot, int offset, LockingContext lockingContext) {
        GlobalMemoryAccessorRegistry.AMEM.putShort(this.getSlotEntryOffsetAddr(nodeAddr, slot, lockingContext), (short)offset);
    }

    int getSlotEntryOffset(long nodeAddr, int slot, LockingContext lockingContext) {
        return GlobalMemoryAccessorRegistry.AMEM.getShort(this.getSlotEntryOffsetAddr(nodeAddr, slot, lockingContext)) & 0xFFFF;
    }

    long getSlotEntryOffsetAddr(long nodeAddr, int slot, LockingContext lockingContext) {
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        return this.translateToPhysical(nodeAddr, lockingContext) + (long)this.nodeSize - (long)(lastSlot - slot + 1) * 2L;
    }

    void copyNodeContent(long srcNodeAddr, long destNodeAddr, LockingContext lockingContext) {
        long contentSize = this.nodeSize - 16;
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(this.translateToPhysical(srcNodeAddr, lockingContext) + 16L, this.translateToPhysical(destNodeAddr, lockingContext) + 16L, contentSize);
    }

    MemoryAllocator getKeyAllocator() {
        return this.keyAllocator;
    }

    MemoryAllocator getBtreeAllocator() {
        return this.btreeAllocator;
    }

    long nodeFromLock(long lockAddr) {
        return lockAddr - 0L;
    }

    void beforeOperation() {
    }

    void afterOperation(LockingContext lockingContext) {
    }

    void beforeLock() {
    }

    void afterLock() {
    }

    void beforePartitionOperation(int partitionId, LockingContext lockingContext) {
    }
}

