/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.auditlog.AuditlogService;
import com.hazelcast.auditlog.AuditlogServiceFactory;
import com.hazelcast.auditlog.impl.DefaultAuditlogFactory;
import com.hazelcast.auditlog.impl.NoOpAuditlogService;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.EnterpriseClientEngineImpl;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.AuditlogConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.internal.CPSubsystemEnterpriseImpl;
import com.hazelcast.cp.internal.CPSubsystemImpl;
import com.hazelcast.cp.internal.kubernetes.CPKubernetesUtil;
import com.hazelcast.cp.internal.persistence.CPPersistenceService;
import com.hazelcast.cp.internal.persistence.CPPersistenceServiceImpl;
import com.hazelcast.cp.internal.persistence.NopCPPersistenceService;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.BuiltInLicenseHolder;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.LicenseMemoryChecker;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterVersionAutoUpgradeHelper;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.JoinRequest;
import com.hazelcast.internal.cluster.impl.SplitBrainJoinMessage;
import com.hazelcast.internal.cluster.impl.VersionMismatchException;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.WANPlugin;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.EmptyDynamicConfigListener;
import com.hazelcast.internal.dynamicconfig.EnterpriseClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.HotRestartConfigListener;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteUtil;
import com.hazelcast.internal.hotrestart.HotBackupService;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.InternalHotRestartService;
import com.hazelcast.internal.hotrestart.NoOpHotRestartService;
import com.hazelcast.internal.hotrestart.NoopInternalHotRestartService;
import com.hazelcast.internal.hotrestart.cluster.ClusterHotRestartEventListener;
import com.hazelcast.internal.hotrestart.cluster.CompactSchemaPersistenceManager;
import com.hazelcast.internal.hotrestart.memory.HotRestartPoolingMemoryManager;
import com.hazelcast.internal.jmx.HazelcastMBean;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.management.TimedMemberStateFactory;
import com.hazelcast.internal.memory.FreeMemoryChecker;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.memory.StandardMemoryManager;
import com.hazelcast.internal.memory.impl.LibMallocFactory;
import com.hazelcast.internal.memory.impl.MemkindMallocFactory;
import com.hazelcast.internal.memory.impl.MemkindUtil;
import com.hazelcast.internal.memory.impl.UnsafeMallocFactory;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.monitor.impl.jmx.EnterpriseManagementService;
import com.hazelcast.internal.monitor.impl.jmx.LicenseInfoMBean;
import com.hazelcast.internal.monitor.impl.management.EnterpriseTimedMemberStateFactory;
import com.hazelcast.internal.monitor.impl.rest.EnterpriseTextCommandServiceImpl;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.internal.namespace.UserCodeNamespaceService;
import com.hazelcast.internal.namespace.impl.NoOpUserCodeNamespaceService;
import com.hazelcast.internal.namespace.impl.UserCodeNamespaceServiceImpl;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.CipherByteArrayProcessor;
import com.hazelcast.internal.nio.CipherHelper;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.EnterpriseChannelInitializerFunction;
import com.hazelcast.internal.nio.ssl.SSLEngineFactoryAdaptor;
import com.hazelcast.internal.nio.tcp.SymmetricCipherPacketDecoder;
import com.hazelcast.internal.nio.tcp.SymmetricCipherPacketEncoder;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.EnterpriseClusterVersionListener;
import com.hazelcast.internal.serialization.impl.EnterpriseSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.compact.schema.EnterpriseMemberSchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.tpc.EnterpriseTpcServerBootstrap;
import com.hazelcast.internal.tpc.TpcServerBootstrap;
import com.hazelcast.internal.tpcengine.nio.FinishingSSLEngineFactoryDecorator;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceFactory;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.util.ByteArrayProcessor;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.LicenseExpirationReminderTask;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.TrialLicenseExpirationCheckerTask;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.EnterpriseJetServiceBackend;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.util.LicenseHelper;
import com.hazelcast.map.impl.EnterpriseMapServiceConstructor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.SecurityService;
import com.hazelcast.security.impl.NodeCallbackHandler;
import com.hazelcast.security.impl.SecurityContextImpl;
import com.hazelcast.security.impl.SecurityServiceImpl;
import com.hazelcast.security.impl.WeakSecretsConfigChecker;
import com.hazelcast.security.jsm.HazelcastRuntimePermission;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.sql.impl.SqlClusterHotRestartEventListener;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import com.hazelcast.wan.impl.WanReplicationService;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class EnterpriseNodeExtension
extends DefaultNodeExtension
implements NodeExtension,
StaticMetricsProvider {
    public static final int MAX_LICENSE_CHECK_INTERVAL_IN_SECONDS = (int)TimeUnit.MINUTES.toSeconds(1L);
    public static final HazelcastProperty LICENSE_CHECK_INTERVAL_IN_SECONDS = new HazelcastProperty("hazelcast.internal.license.check.interval.in.seconds", MAX_LICENSE_CHECK_INTERVAL_IN_SECONDS);
    public static final HazelcastProperty ALLOW_RU_FROM_LTS = new HazelcastProperty("hazelcast.internal.allow.rolling.upgrade.from.lts", "false");
    private static final Map<LicenseVersion, Set<Feature>> LICENSE_FEATURE_REMOVALS = new HashMap<LicenseVersion, Set<Feature>>();
    private static final Map<LicenseVersion, Set<Feature>> LICENSE_FEATURE_ADDITIONS = new HashMap<LicenseVersion, Set<Feature>>();
    private static final int SUGGESTED_MAX_NATIVE_MEMORY_SIZE_PER_PARTITION_IN_MB = 256;
    private static final NoopInternalHotRestartService NOOP_INTERNAL_HOT_RESTART_SERVICE;
    private static final NoOpHotRestartService NO_OP_HOT_RESTART_SERVICE;
    private static final int VERSION_4 = 4;
    private static final int VERSION_5 = 5;
    private static volatile Set<Feature> featureSet;
    private static final String CONTACT = "Please contact your sales representative or contact support@hazelcast.com";
    private final HotRestartIntegrationService hotRestartService;
    private final HotBackupService hotBackupService;
    private final SecurityService securityService;
    private final AuditlogService auditlogService;
    private final BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
    private final ClusterVersionAutoUpgradeHelper clusterVersionAutoUpgradeHelper = new ClusterVersionAutoUpgradeHelper();
    private final boolean cpPersistenceEnabled;
    private volatile CPPersistenceServiceImpl cpPersistenceService;
    private volatile License license;
    private volatile SecurityContext securityContext;
    private volatile HazelcastMemoryManager memoryManager;
    private final ConcurrentMap<EndpointQualifier, MemberSocketInterceptor> socketInterceptors = new ConcurrentHashMap<EndpointQualifier, MemberSocketInterceptor>();
    private final TieredStoreService tieredStoreService;
    private final UserCodeNamespaceService userCodeNamespaceService;
    private volatile LicenseExpirationReminderTask licenseExpirationReminderTask;
    private ScheduledFuture<?> trialLicenseChecker;
    private LicenseMemoryChecker licenseMemoryChecker;
    private Set<Version> supportedVersions;

    public EnterpriseNodeExtension(Node node) {
        super(node);
        this.hotRestartService = this.createHotRestartService(node);
        this.hotBackupService = this.createHotBackupService(node, this.hotRestartService);
        this.securityService = this.createSecurityService(node);
        this.userCodeNamespaceService = this.createNamespaceService(node.getConfig());
        this.auditlogService = this.createAuditlogService(node);
        this.cpPersistenceEnabled = node.getConfig().getCPSubsystemConfig().isPersistenceEnabled();
        this.tieredStoreService = this.createTieredStorageService(node);
    }

    protected TieredStoreService createTieredStorageService(Node node) {
        return TieredStoreServiceFactory.create(node, () -> this.memoryManager);
    }

    private SecurityService createSecurityService(Node node) {
        return node.getConfig().getSecurityConfig().isEnabled() ? new SecurityServiceImpl(node) : null;
    }

    private HotBackupService createHotBackupService(Node node, HotRestartIntegrationService hotRestartService) {
        if (hotRestartService == null) {
            return null;
        }
        HotRestartPersistenceConfig config = node.getConfig().getHotRestartPersistenceConfig();
        return config.getBackupDir() != null ? new HotBackupService(node, hotRestartService) : null;
    }

    private AuditlogService createAuditlogService(Node node) {
        AuditlogConfig auditlogConfig = node.getConfig().getAuditlogConfig();
        if (auditlogConfig.isEnabled()) {
            String clsName = StringUtil.trim(auditlogConfig.getFactoryClassName());
            try {
                ClassLoader loader;
                AuditlogServiceFactory factory = StringUtil.isNullOrEmpty(clsName) ? new DefaultAuditlogFactory() : (AuditlogServiceFactory)ClassLoaderUtil.newInstance((loader = this.getNamespaceService().getClassLoaderForNamespace(null)) != null ? loader : node.getConfigClassLoader(), clsName);
                factory.init(((NodeCallbackHandler.Builder)NodeCallbackHandler.builder().withNode(node)).build(), auditlogConfig.getProperties());
                return factory.createAuditlog();
            }
            catch (Exception e) {
                throw new HazelcastException("AuditlogService initialization failed", e);
            }
        }
        return NoOpAuditlogService.INSTANCE;
    }

    @Override
    protected void checkDynamicConfigurationPersistenceAllowed() {
        super.checkDynamicConfigurationPersistenceAllowed();
        Config config = this.node.getConfig();
        if (config.getDynamicConfigurationConfig().isPersistenceEnabled()) {
            RewriteUtil.checkDynamicConfigurationPersistenceFileRequirements(config);
            if (config.getDynamicConfigurationConfig().getBackupCount() > 0) {
                RewriteUtil.checkDynamicConfigurationBackupDirRequirements(config);
            }
        }
    }

    private HotRestartIntegrationService createHotRestartService(Node node) {
        HotRestartPersistenceConfig hotRestartPersistenceConfig = node.getConfig().getHotRestartPersistenceConfig();
        return hotRestartPersistenceConfig.isEnabled() ? new HotRestartIntegrationService(node) : null;
    }

    @Override
    public void beforeStart() {
        boolean isSqlCatalogPersistenceEnabled;
        SymmetricEncryptionConfig sec;
        super.beforeStart();
        this.license = BuiltInLicenseHolder.getBuiltInLicense();
        if (this.license == null) {
            this.logger.log(Level.INFO, "Checking Hazelcast Enterprise license...");
            HazelcastProperties properties = this.node.getProperties();
            String licenseKey = properties.getString(ClusterProperty.ENTERPRISE_LICENSE_KEY);
            if (licenseKey == null || licenseKey.isEmpty()) {
                licenseKey = this.node.getConfig().getLicenseKey();
            }
            if (licenseKey == null || licenseKey.isEmpty()) {
                throw new InvalidLicenseException("The Hazelcast Enterprise license key is not set.\nTo set the license key, please do one of the following:\n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.setLicenseKey(\"...\")", "hazelcast.license-key: ...", "-Dhz.licensekey=...", "HZ_LICENSEKEY=..."));
            }
            this.setLicenseInternal(LicenseHelper.getLicense(licenseKey, this.buildInfo.getVersion()), licenseKey);
        } else {
            this.logger.log(Level.FINE, "This is an OEM version of Hazelcast Enterprise.");
        }
        featureSet = EnumSet.copyOf(this.license.getFeatures());
        this.createSecurityContext(this.node);
        this.createMemoryManager(this.node);
        this.initializeSupportedVersions();
        Config hzConfig = this.node.config.getStaticConfig();
        if (hzConfig.getTpcConfig().isEnabled()) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.TPC);
        }
        SymmetricEncryptionConfig symmetricEncryptionConfig = sec = hzConfig.getAdvancedNetworkConfig().isEnabled() ? hzConfig.getAdvancedNetworkConfig().getEndpointConfigs().get(EndpointQualifier.MEMBER).getSymmetricEncryptionConfig() : hzConfig.getNetworkConfig().getSymmetricEncryptionConfig();
        if (sec != null && sec.isEnabled() && sec.getKey() == null && sec.getPassword() == null) {
            throw new InvalidConfigurationException("The deprecated SymmetricEncryption feature is enabled, but key or password configurations are missing. Fill the key or password value in the SymmetricEncryption configuration. Also consider switching from SymmetricEncryption to TLS/SSL for the network communication protection.\n");
        }
        JetConfig jetConfig = hzConfig.getJetConfig();
        boolean losslessRestartEnabled = jetConfig.isLosslessRestartEnabled();
        if (losslessRestartEnabled) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.STREAMING_LOSSLESS_CLUSTER_RESTART);
            if (!hzConfig.getHotRestartPersistenceConfig().isEnabled()) {
                throw new JetException("Lossless Cluster Restart is enabled, but Persistence, which is required for its functionality, is not. You need to enable it using either:\n  config.getPersistenceConfig().setEnabled(true) ...\nor using the hazelcast.xml configuration file using this element:\n  <persistence enabled=\"true\">\n      ...\n  </persistence>\n");
            }
            MapConfig internalMapConfig = hzConfig.getMapConfig("__jet.*");
            internalMapConfig.getHotRestartConfig().setEnabled(true);
        }
        if (isSqlCatalogPersistenceEnabled = hzConfig.getSqlConfig().isCatalogPersistenceEnabled()) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.PERSISTENCE);
            if (!hzConfig.getPersistenceConfig().isEnabled()) {
                throw new JetException("SQL Catalog Persistence is enabled, but Persistence, which is required for its functionality, is not. You need to enable it using either:\n  config.getPersistenceConfig().setEnabled(true) ...\nor using the hazelcast.xml configuration file using this element:\n  <persistence enabled=\"true\">\n      ...\n  </persistence>\n");
            }
            MapConfig sqlCatalogConfig = hzConfig.getMapConfig("__sql.catalog");
            sqlCatalogConfig.getDataPersistenceConfig().setEnabled(true);
            this.registerListener(new SqlClusterHotRestartEventListener(this.node));
        }
    }

    private void initializeSupportedVersions() {
        BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
        Version version = buildInfo.getCodebaseVersion().asVersion();
        Version lts = buildInfo.getLastLtsVersion().asVersion();
        boolean isRuFromLtsAllowed = this.node.getProperties().getBoolean(ALLOW_RU_FROM_LTS) || Versions.isLts(version);
        boolean rollingUpgradeLicensed = this.isRollingUpgradeLicensed();
        this.supportedVersions = rollingUpgradeLicensed && isRuFromLtsAllowed ? CollectionUtil.setOf(version, lts, Version.of(5, 2), Version.of(5, 3), Version.of(5, 4), version.previousMinor()) : (rollingUpgradeLicensed ? CollectionUtil.setOf(version, Version.of(5, 2), Version.of(5, 3), Version.of(5, 4), version.previousMinor()) : Set.of(version));
        this.logger.fine("This Hazelcast member supports versions: " + String.valueOf(this.supportedVersions));
    }

    @Override
    protected Map<String, Object> getTrackingFileProperties(BuildInfo buildInfo) {
        Map<String, Object> props = super.getTrackingFileProperties(buildInfo);
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.LICENSED.getPropertyName(), this.license != null ? 1 : 0);
        return props;
    }

    private void setLicenseInternal(License lic, String licenseKey) {
        this.license = lic;
        this.node.config.setLicenseKey(licenseKey);
        this.logger.log(Level.INFO, this.license.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLicenseKey(String licenseKey) {
        License userLicense = LicenseHelper.getLicense(licenseKey, this.buildInfo.getVersion());
        EnterpriseNodeExtension.checkLicenseCompatible(this.license, userLicense);
        boolean licenseIsChanged = true;
        EnterpriseNodeExtension enterpriseNodeExtension = this;
        synchronized (enterpriseNodeExtension) {
            if (this.license.getKey().equals(licenseKey)) {
                licenseIsChanged = false;
            } else {
                this.setLicenseInternal(userLicense, licenseKey);
                this.onLicenseChanged(userLicense);
            }
        }
        if (licenseIsChanged) {
            boolean persistenceEnabled = this.node.getConfig().getDynamicConfigurationConfig().isPersistenceEnabled();
            this.logger.log(persistenceEnabled ? Level.INFO : Level.WARNING, EnterpriseNodeExtension.licenseChangeMessage(persistenceEnabled));
        }
    }

    public static String licenseChangeMessage(boolean persistenceEnabled) {
        Object message = "License updated at run time. ";
        message = persistenceEnabled ? (String)message + "Dynamic Configuration Persistence is enabled. License will be persisted. Please ensure new members use the updated license." : (String)message + "Please make sure to update the license in the persistent configuration to avoid losing the changes on restart. You can also enable Dynamic Configuration Persistence for persisting dynamic changes.";
        return message;
    }

    private void onLicenseChanged(License newLicense) {
        this.initLicenseExpReminder(newLicense);
        this.launchTrialLicenseChecker(newLicense);
        this.initLicenseMBean(newLicense);
    }

    private static void checkLicenseCompatible(License current, License newLicense) {
        if (newLicense.getExpiryDate().isBefore(current.getExpiryDate())) {
            throw new InvalidLicenseException("License expires before the current license");
        }
        if (current.getVersion().getCode() > newLicense.getVersion().getCode()) {
            throw new InvalidLicenseException("Cannot update to an older version license");
        }
        if (newLicense.getAllowedNumberOfNodes() < current.getAllowedNumberOfNodes()) {
            throw new InvalidLicenseException("License allows a smaller number of nodes " + newLicense.getAllowedNumberOfNodes() + " than the current license " + current.getAllowedNumberOfNodes());
        }
        EnterpriseNodeExtension.checkFeaturesCompatible(current, newLicense);
    }

    private static void checkFeaturesCompatible(License current, License newLicense) {
        LicenseVersion fromVersion = current.getVersion();
        LicenseVersion toVersion = newLicense.getVersion();
        Set<Feature> removals = EnterpriseNodeExtension.collectFeaturesFromFeatureMap(fromVersion, toVersion, LICENSE_FEATURE_REMOVALS);
        Set<Feature> additions = EnterpriseNodeExtension.collectFeaturesFromFeatureMap(fromVersion, toVersion, LICENSE_FEATURE_ADDITIONS);
        EnumSet<Feature> currentFeatures = current.getFeatures() == null ? EnumSet.noneOf(Feature.class) : EnumSet.copyOf(current.getFeatures());
        currentFeatures.removeAll(removals);
        EnumSet<Feature> newFeatures = newLicense.getFeatures() == null ? EnumSet.noneOf(Feature.class) : EnumSet.copyOf(newLicense.getFeatures());
        newFeatures.removeAll(additions);
        if (!newFeatures.equals(currentFeatures)) {
            throw new InvalidLicenseException("License has incompatible features:\n%s\nWith the current license:\n%s".formatted(newLicense.getFeatures(), current.getFeatures()));
        }
    }

    private static Set<Feature> collectFeaturesFromFeatureMap(LicenseVersion fromVersion, LicenseVersion toVersion, Map<LicenseVersion, Set<Feature>> featureMap) {
        if (fromVersion.getCode() >= toVersion.getCode()) {
            return Collections.emptySet();
        }
        EnumSet<Feature> features = EnumSet.noneOf(Feature.class);
        for (LicenseVersion version : LicenseVersion.values()) {
            Set<Feature> featureSet;
            if (version.getCode() <= fromVersion.getCode() || version.getCode() > toVersion.getCode() || (featureSet = featureMap.get(version)) == null) continue;
            features.addAll(featureSet);
        }
        return features;
    }

    private boolean isRollingUpgradeLicensed() {
        return this.license.getFeatures().contains(Feature.ROLLING_UPGRADE);
    }

    private void createSecurityContext(Node node) {
        boolean securityEnabled = node.getConfig().getSecurityConfig().isEnabled();
        if (securityEnabled) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.SECURITY);
            this.securityContext = new SecurityContextImpl(node, this);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    private MemberSocketInterceptor createOrGetSocketInterceptor(EndpointQualifier qualifier) {
        MemberSocketInterceptor si = (MemberSocketInterceptor)this.socketInterceptors.get(qualifier = qualifier == null ? EndpointQualifier.MEMBER : qualifier);
        if (si != null) {
            return si;
        }
        SocketInterceptor implementation = null;
        SocketInterceptorConfig socketInterceptorConfig = this.getSocketInterceptorConfig(qualifier);
        if (socketInterceptorConfig != null && socketInterceptorConfig.isEnabled()) {
            implementation = (SocketInterceptor)socketInterceptorConfig.getImplementation();
            if (implementation == null && socketInterceptorConfig.getClassName() != null) {
                try {
                    implementation = (SocketInterceptor)Class.forName(socketInterceptorConfig.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    this.logger.severe("SocketInterceptor class cannot be instantiated!" + socketInterceptorConfig.getClassName(), e);
                }
            }
            if (implementation != null && !(implementation instanceof MemberSocketInterceptor)) {
                this.logger.severe("SocketInterceptor must be instance of " + MemberSocketInterceptor.class.getName());
                implementation = null;
            }
        }
        if ((si = (MemberSocketInterceptor)implementation) != null) {
            this.logger.info("SocketInterceptor is enabled");
            si.init(socketInterceptorConfig.getProperties());
            this.socketInterceptors.putIfAbsent(qualifier, si);
        }
        return si;
    }

    @Override
    public void beforeJoin() {
        if (this.license.isTrial()) {
            this.launchTrialLicenseChecker(this.license);
        }
        this.licenseMemoryChecker = new LicenseMemoryChecker(this);
        if (this.hotRestartService != null) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.PERSISTENCE);
            this.hotRestartService.prepare();
        }
        this.cpPersistenceService = this.createCPPersistenceService(this.node);
        if (this.cpPersistenceService != null) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.CP_PERSISTENCE);
        }
        if (this.node.getConfig().getNativeMemoryConfig().isEnabled()) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.HD_MEMORY);
            if (this.license.getVersion().getCode() >= LicenseVersion.V6.getCode()) {
                this.licenseMemoryChecker.checkLicensedFeaturesMemoryLimit(Feature.HD_MEMORY);
            }
        }
        if (this.node.getConfig().getDynamicConfigurationConfig().isPersistenceEnabled()) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.DYNAMIC_CONFIGURATION);
        }
        if (this.tieredStoreService instanceof TieredStoreServiceImpl) {
            LicenseHelper.checkLicensePerFeature(this.license, Feature.TIERED_STORAGE);
            this.licenseMemoryChecker.checkLicensedFeaturesMemoryLimit(Feature.TIERED_STORAGE);
        }
    }

    private CPPersistenceServiceImpl createCPPersistenceService(Node node) {
        return this.cpPersistenceEnabled ? new CPPersistenceServiceImpl(node) : null;
    }

    @Override
    protected void printBannersBeforeNodeInfo() {
        WeakSecretsConfigChecker configChecker = new WeakSecretsConfigChecker(this.node.getConfig());
        configChecker.evaluateAndReport(this.systemLogger);
        super.printBannersBeforeNodeInfo();
    }

    @Override
    protected String constructBuildString(BuildInfo buildInfo) {
        Object build = buildInfo.getBuild();
        String revision = buildInfo.getRevision();
        if (!revision.isEmpty()) {
            String upstreamRevision;
            build = (String)build + " - " + revision;
            BuildInfo upstreamBuildInfo = buildInfo.getUpstreamBuildInfo();
            if (upstreamBuildInfo != null && !StringUtil.isNullOrEmpty(upstreamRevision = upstreamBuildInfo.getRevision())) {
                build = (String)build + ", " + upstreamRevision;
            }
        }
        return build;
    }

    @Override
    protected String getEditionString() {
        return "Hazelcast Enterprise";
    }

    @Override
    public void afterStart() {
        int partitionCount;
        MemoryStats memoryStats;
        int maxNativeMemorySizeInMegaBytes;
        int nativeMemorySizePerPartition;
        if (!this.node.isRunning()) {
            return;
        }
        if (this.license == null) {
            this.logger.log(Level.SEVERE, "Hazelcast Enterprise license could not be found!");
            this.node.shutdown(true);
            return;
        }
        int nodeCount = this.node.getClusterService().getSize();
        if (nodeCount > this.license.getAllowedNumberOfNodes()) {
            this.logger.log(Level.SEVERE, "Exceeded maximum number of nodes allowed in Hazelcast Enterprise license! Max: " + this.license.getAllowedNumberOfNodes() + ", Current: " + nodeCount);
            this.node.shutdown(true);
            return;
        }
        if (this.cpPersistenceService != null) {
            try {
                this.cpPersistenceService.start();
            }
            catch (Throwable e) {
                this.logger.severe("CP restore failed", e);
                this.node.shutdown(true);
                return;
            }
        }
        if (this.hotRestartService != null) {
            try {
                this.hotRestartService.start();
            }
            catch (Throwable e) {
                this.logger.severe("Hot Restart procedure failed", e);
                this.node.shutdown(true);
                throw e;
            }
        }
        this.refreshClusterPermissions();
        if (this.memoryManager != null && (nativeMemorySizePerPartition = (maxNativeMemorySizeInMegaBytes = (int)MemoryUnit.BYTES.toMegaBytes((memoryStats = this.memoryManager.getMemoryStats()).getMaxNative())) * nodeCount / (2 * (partitionCount = this.node.getPartitionService().getPartitionCount()))) > 256) {
            this.logger.warning(String.format("Native memory size per partition (%d MB) is higher than suggested maximum native memory size per partition (%d MB). You may think increasing partition count which is `%d` at the moment.", nativeMemorySizePerPartition, 256, partitionCount));
        }
        this.initWanConsumers();
        this.removeOrLogLeftoverNodeUuidDirs();
        this.initLicenseExpReminder(this.license);
        super.afterStart();
    }

    private void removeOrLogLeftoverNodeUuidDirs() {
        TieredStoreService service = (TieredStoreService)this.node.nodeEngine.getService("hz:ee:tieredStoreServiceImpl");
        if (service instanceof TieredStoreServiceImpl) {
            TieredStoreServiceImpl impl = (TieredStoreServiceImpl)service;
            impl.removeOrLogUnexpectedDeviceDirsOnMemberStart();
        }
    }

    private void refreshClusterPermissions() {
        SecurityConfig securityConfig = this.node.getConfig().getSecurityConfig();
        if (this.securityService != null && securityConfig.getOnJoinPermissionOperation() == OnJoinPermissionOperationName.SEND) {
            this.logger.info("Refreshing client permissions in cluster");
            this.securityService.refreshClientPermissions(securityConfig.getClientPermissionConfigs());
        }
    }

    private void initLicenseExpReminder(License lic) {
        block5: {
            boolean builtInLicense = LicenseHelper.isBuiltInLicense(lic);
            try {
                if (this.licenseExpirationReminderTask == null) {
                    if (!builtInLicense) {
                        TaskScheduler taskScheduler = this.node.nodeEngine.getExecutionService().getGlobalTaskScheduler();
                        this.licenseExpirationReminderTask = LicenseExpirationReminderTask.scheduleWith(taskScheduler, lic);
                    }
                } else {
                    this.licenseExpirationReminderTask = this.licenseExpirationReminderTask.rescheduleWithNewLicense(builtInLicense ? null : lic);
                }
            }
            catch (RejectedExecutionException e) {
                if (!this.node.isRunning()) break block5;
                throw e;
            }
        }
    }

    private void initLicenseMBean(License lic) {
        ManagementService managementService = this.node.hazelcastInstance.getManagementService();
        EnterpriseManagementService.EnterpriseInstanceMBean instanceMBean = (EnterpriseManagementService.EnterpriseInstanceMBean)managementService.getInstanceMBean();
        if (instanceMBean != null) {
            LicenseInfoMBean licenseInfoMBean = instanceMBean.getLicenseInfoMBean();
            HazelcastMBean.unregister(licenseInfoMBean);
            HazelcastMBean.register(new LicenseInfoMBean(new LicenseInfoImpl(lic), this.node, managementService));
        }
    }

    private void initWanConsumers() {
        WanReplicationService wanReplicationService = this.node.nodeEngine.getWanReplicationService();
        if (wanReplicationService instanceof EnterpriseWanReplicationService) {
            EnterpriseWanReplicationService service = (EnterpriseWanReplicationService)wanReplicationService;
            service.initializeCustomConsumers();
        }
    }

    @Override
    public void logInstanceTrackingMetadata() {
        Config config = this.node.getConfig();
        InstanceTrackingConfig trackingConfig = config.getInstanceTrackingConfig();
        if (BuiltInLicenseHolder.getBuiltInLicense() != null && trackingConfig.isEnabled()) {
            if (!ConfigAccessor.isInstanceTrackingEnabledSet(config)) {
                this.logger.info("Auto-enabled instance tracking since this is an OEM version of Hazelcast Enterprise.");
            }
            if (StringUtil.isNullOrEmptyAfterTrim(trackingConfig.getFileName())) {
                throw new InvalidConfigurationException("The member cannot start because instance tracking file name is not set. You must set the filename because you are using a keyless version of Hazelcast with instance tracking permanently enabled.\nTo set the instance tracking file name, please do one of the following:\n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.getInstanceTrackingConfig().setFileName(\"instance-tracking.txt\")", "hazelcast.instance-tracking.file-name to e.g. 'instance-tracking.txt'", "-Dhz.instancetracking.filename=instance-tracking.txt\n", "HZ_INSTANCETRACKING_FILENAME=instance-tracking.txt"));
            }
        }
        super.logInstanceTrackingMetadata();
    }

    @Override
    public boolean isStartCompleted() {
        boolean hotRestartStartCompleted = true;
        if (this.hotRestartService != null) {
            hotRestartStartCompleted = this.hotRestartService.isStartCompleted();
        }
        boolean cpPersistenceStartCompleted = true;
        if (this.cpPersistenceService != null) {
            cpPersistenceStartCompleted = this.cpPersistenceService.isStartCompleted();
        }
        return hotRestartStartCompleted && cpPersistenceStartCompleted && super.isStartCompleted();
    }

    @Override
    public boolean isReady() {
        boolean hotRestartStartCompleted = true;
        if (this.hotRestartService != null) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("isReady: isMaster? " + this.node.clusterService.isMaster() + ", node's intent: " + String.valueOf((Object)this.node.getClusterTopologyIntent()) + ", master's intent: " + String.valueOf((Object)this.hotRestartService.getClusterTopologyIntentOnMaster()) + ", isJoined? " + this.node.clusterService.isJoined());
            }
            if (!this.node.getProperties().getBoolean(ClusterProperty.PERSISTENCE_AUTO_CLUSTER_STATE) && this.cpPersistenceService != null && CPKubernetesUtil.isKubernetesContext(this.node.getConfig())) {
                this.logger.fine("auto-state-management disabled, not taking into account hotRestartService.isStartCompleted()");
            } else if (!this.hotRestartService.isClusterWideStart() || this.node.isClusterComplete()) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("taking into account hotRestartService.isStartCompleted() " + this.hotRestartService.isStartCompleted());
                }
                hotRestartStartCompleted = this.hotRestartService.isStartCompleted();
            }
        }
        boolean cpPersistenceStartCompleted = true;
        if (this.cpPersistenceService != null && !CPKubernetesUtil.isKubernetesContext(this.node.getConfig())) {
            cpPersistenceStartCompleted = this.cpPersistenceService.isStartCompleted();
        }
        return hotRestartStartCompleted && cpPersistenceStartCompleted && this.node.clusterService.isJoined();
    }

    @Override
    public License getLicense() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new HazelcastRuntimePermission("com.hazelcast.instance.impl.EnterpriseNodeExtension.getLicense"));
        }
        return this.license;
    }

    @Override
    public InternalSerializationService createSerializationService() {
        return this.createSerializationService(false);
    }

    @Override
    public InternalSerializationService createCompatibilitySerializationService() {
        return this.createSerializationService(true);
    }

    @Override
    public MemberSchemaService createSchemaService() {
        CompactSchemaPersistenceManager manager = null;
        if (this.hotRestartService != null && this.hotRestartService.isEnabled()) {
            manager = this.hotRestartService.getClusterMetadataManager().getCompactSchemaPersistenceManager();
        }
        return new EnterpriseMemberSchemaService(manager);
    }

    @Override
    public void scheduleClusterVersionAutoUpgrade() {
        if (this.isRollingUpgradeLicensed()) {
            this.clusterVersionAutoUpgradeHelper.scheduleNewAutoUpgradeTask(this.node.clusterService);
        }
    }

    private void createMemoryManager(Node node) {
        NativeMemoryConfig memoryConfig = node.getConfig().getNativeMemoryConfig();
        if (memoryConfig.isEnabled()) {
            Capacity size = memoryConfig.getCapacity();
            NativeMemoryConfig.MemoryAllocatorType type = memoryConfig.getAllocatorType();
            FreeMemoryChecker freeMemoryChecker = new FreeMemoryChecker(node.getProperties());
            this.logger.info("Creating " + String.valueOf((Object)type) + " native memory manager with " + size.toPrettyString() + " size");
            if (size.bytes() > 0x3200000000L) {
                this.logger.warning(String.format("The configured native memory size %s exceeds the supported maximum 200GB and violates the support contract. Please reduce the native memory size.", size.toPrettyString()));
            }
            LibMallocFactory libMallocFactory = EnterpriseNodeExtension.createLibMallocFactory(memoryConfig, freeMemoryChecker);
            if (type == NativeMemoryConfig.MemoryAllocatorType.STANDARD) {
                if (this.isHotRestartEnabled()) {
                    throw new InvalidConfigurationException("MemoryAllocatorType.STANDARD cannot be used when Hot Restart is enabled. Please use MemoryAllocatorType.POOLED!");
                }
                this.memoryManager = new StandardMemoryManager(size, libMallocFactory);
            } else {
                int blockSize = memoryConfig.getMinBlockSize();
                int pageSize = memoryConfig.getPageSize();
                float metadataSpace = memoryConfig.getMetadataSpacePercentage();
                this.memoryManager = this.isHotRestartEnabled() ? new HotRestartPoolingMemoryManager(size, blockSize, pageSize, metadataSpace, libMallocFactory, node.hazelcastInstance.name) : new PoolingMemoryManager(size, blockSize, pageSize, metadataSpace, libMallocFactory, node.hazelcastInstance.name);
            }
        }
    }

    private static LibMallocFactory createLibMallocFactory(NativeMemoryConfig config, FreeMemoryChecker freeMemoryChecker) {
        if (!MemkindUtil.shouldUseMemkindMalloc(config)) {
            return new UnsafeMallocFactory(freeMemoryChecker);
        }
        return new MemkindMallocFactory(config);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    public MemberSocketInterceptor getSocketInterceptor(EndpointQualifier endpointQualifier) {
        return this.createOrGetSocketInterceptor(endpointQualifier);
    }

    @Override
    public InboundHandler[] createInboundHandlers(EndpointQualifier qualifier, ServerConnection connection, ServerContext serverContext) {
        SymmetricEncryptionConfig symmetricEncryptionConfig = serverContext.getSymmetricEncryptionConfig(qualifier);
        if (symmetricEncryptionConfig != null && symmetricEncryptionConfig.isEnabled()) {
            this.logger.info(String.valueOf(qualifier) + " reader started with SymmetricEncryption");
            SymmetricCipherPacketDecoder decoder = new SymmetricCipherPacketDecoder(symmetricEncryptionConfig, connection, serverContext, this.node.nodeEngine.getPacketDispatcher());
            return new InboundHandler[]{decoder};
        }
        return super.createInboundHandlers(qualifier, connection, serverContext);
    }

    @Override
    public OutboundHandler[] createOutboundHandlers(EndpointQualifier qualifier, ServerConnection connection, ServerContext serverContext) {
        SymmetricEncryptionConfig symmetricEncryptionConfig = serverContext.getSymmetricEncryptionConfig(qualifier);
        if (symmetricEncryptionConfig != null && symmetricEncryptionConfig.isEnabled()) {
            this.logger.info(String.valueOf(qualifier) + " writer started with SymmetricEncryption");
            SymmetricCipherPacketEncoder encoder = new SymmetricCipherPacketEncoder(connection, symmetricEncryptionConfig);
            return new OutboundHandler[]{encoder};
        }
        return super.createOutboundHandlers(qualifier, connection, serverContext);
    }

    @Override
    public Function<EndpointQualifier, ChannelInitializer> createChannelInitializerFn(ServerContext serverContext) {
        EnterpriseChannelInitializerFunction provider = new EnterpriseChannelInitializerFunction(serverContext, this.node);
        provider.init();
        return provider;
    }

    @Override
    public void onThreadStart(Thread thread) {
        super.onThreadStart(thread);
        this.registerThreadToPoolingMemoryManager(thread);
    }

    private void registerThreadToPoolingMemoryManager(Thread thread) {
        if (!(thread instanceof PartitionOperationThread)) {
            return;
        }
        EnterpriseSerializationService serializationService = (EnterpriseSerializationService)this.node.getSerializationService();
        HazelcastMemoryManager memoryManager = serializationService.getMemoryManager();
        if (memoryManager instanceof PoolingMemoryManager) {
            PoolingMemoryManager manager = (PoolingMemoryManager)memoryManager;
            manager.registerThread(thread);
        }
    }

    @Override
    public void onThreadStop(Thread thread) {
        super.onThreadStop(thread);
        this.deregisterThreadFromPoolingMemoryManager(thread);
    }

    private void deregisterThreadFromPoolingMemoryManager(Thread thread) {
        EnterpriseSerializationService serializationService = (EnterpriseSerializationService)this.node.getSerializationService();
        HazelcastMemoryManager memoryManager = serializationService.getMemoryManager();
        if (memoryManager instanceof PoolingMemoryManager) {
            PoolingMemoryManager manager = (PoolingMemoryManager)memoryManager;
            manager.deregisterThread(thread);
        }
    }

    @Override
    public InternalHotRestartService getInternalHotRestartService() {
        if (this.hotRestartService == null) {
            return NOOP_INTERNAL_HOT_RESTART_SERVICE;
        }
        return this.hotRestartService;
    }

    public boolean isHotRestartEnabled() {
        return this.hotRestartService != null;
    }

    public boolean isFeatureEnabledForLicenseKey(Feature feature) {
        boolean enabled = true;
        try {
            LicenseHelper.checkLicensePerFeature(this.license, feature);
        }
        catch (InvalidLicenseException e) {
            enabled = false;
            this.logger.warning(e.getMessage());
        }
        return enabled;
    }

    public void checkLicensePerFeature(Feature feature) {
        if (!featureSet.contains(feature)) {
            throw new InvalidLicenseException("The Feature " + feature.getText() + " is not enabled for your license key. Please contact your sales representative or contact support@hazelcast.com");
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.hotRestartService != null) {
            this.hotRestartService.shutdown();
        }
        if (this.cpPersistenceService != null) {
            this.cpPersistenceService.shutdown();
        }
    }

    @Override
    public void afterShutdown() {
        super.afterShutdown();
        this.license = null;
    }

    @Override
    public <T> T createService(Class<T> clazz, Object ... params) {
        if (WanReplicationService.class.isAssignableFrom(clazz)) {
            try {
                LicenseHelper.checkLicensePerFeature(this.license, Feature.WAN);
                return (T)new EnterpriseWanReplicationService(this.node);
            }
            catch (InvalidLicenseException e) {
                return (T)new WanReplicationServiceImpl(this.node);
            }
        }
        if (ICacheService.class.isAssignableFrom(clazz)) {
            return (T)new EnterpriseCacheService();
        }
        if (MapService.class.isAssignableFrom(clazz)) {
            return (T)EnterpriseMapServiceConstructor.getEnterpriseMapServiceConstructor().createNew(this.node.getNodeEngine());
        }
        if (JetServiceBackend.class.isAssignableFrom(clazz)) {
            return (T)new EnterpriseJetServiceBackend(this.node);
        }
        if (ClusterWideConfigurationService.class.isAssignableFrom(clazz)) {
            return this.createConfigurationService(params);
        }
        throw new IllegalArgumentException("Unknown service class: " + String.valueOf(clazz));
    }

    private <T> T createConfigurationService(Object ... params) {
        if (params.length != 1) {
            throw new IllegalArgumentException("Creating ConfigurationService requires NodeEngine as a parameter.");
        }
        Object nodeEngine = params[0];
        if (!(nodeEngine instanceof NodeEngine)) {
            throw new IllegalArgumentException("While creating ConfigurationService expected NodeEngine as a parameter, but found: " + nodeEngine.getClass().getName());
        }
        return (T)new EnterpriseClusterWideConfigurationService((NodeEngine)nodeEngine, this.hotRestartService == null ? new EmptyDynamicConfigListener() : new HotRestartConfigListener(this.hotRestartService));
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        HashMap<String, Object> services = new HashMap<String, Object>(super.createExtensionServices());
        if (this.userCodeNamespaceService != null) {
            services.put("hz:impl:namespaceService", this.userCodeNamespaceService);
        }
        if (this.hotRestartService != null) {
            services.put("hz:ee:internalHotRestartService", this.hotRestartService);
        }
        if (this.hotBackupService != null) {
            services.put("hz:ee:internalHotBackupService", this.hotBackupService);
        }
        if (this.securityService != null) {
            services.put("hz:ee:securityServiceImpl", this.securityService);
        }
        if (this.tieredStoreService != null) {
            services.put("hz:ee:tieredStoreServiceImpl", this.tieredStoreService);
        }
        return services;
    }

    @Override
    public MemoryStats getMemoryStats() {
        HazelcastMemoryManager mm = this.memoryManager;
        return mm != null ? mm.getMemoryStats() : super.getMemoryStats();
    }

    @Override
    public void validateJoinRequest(JoinMessage joinRequest) {
        long licensedNativeMemorySize;
        long totalNativeMemorySize;
        if (this.isRollingUpgradeLicensed()) {
            this.validateJoiningMemberVersion(joinRequest);
        } else {
            super.validateJoinRequest(joinRequest);
        }
        NativeMemoryConfig memoryConfig = this.node.getConfig().getNativeMemoryConfig();
        if (!memoryConfig.isEnabled()) {
            return;
        }
        if (this.license.getVersion() == LicenseVersion.V2 && (totalNativeMemorySize = (long)this.node.getClusterService().getSize() * memoryConfig.getCapacity().bytes()) >= (licensedNativeMemorySize = MemoryUnit.GIGABYTES.toBytes(this.license.getAllowedNativeMemorySize()))) {
            throw new InvalidLicenseException("Total native memory of cluster exceeds licensed native memory. Please contact your sales representative or contact support@hazelcast.com");
        }
    }

    private void validateJoiningMemberVersion(JoinMessage joinMessage) {
        JoinRequest joinRequest;
        Version clusterVersion = this.node.getClusterService().getClusterVersion();
        MemberVersion memberVersion = joinMessage.getMemberVersion();
        if (joinMessage instanceof JoinRequest && (joinRequest = (JoinRequest)joinMessage).supportsVersion(clusterVersion)) {
            return;
        }
        if (joinMessage instanceof SplitBrainJoinMessage && memberVersion.asVersion().equals(clusterVersion)) {
            return;
        }
        if (clusterVersion.getMajor() == 4 && memberVersion.getMajor() == 5) {
            return;
        }
        if (memberVersion.getMajor() == clusterVersion.getMajor() && (memberVersion.getMinor() == clusterVersion.getMinor() || memberVersion.getMinor() == clusterVersion.getMinor() + 1)) {
            return;
        }
        String supported = this.getSupportedVersions().stream().map(Version::toString).collect(Collectors.joining(", "));
        String msg = "Joining node's version " + String.valueOf(memberVersion) + " is not compatible with cluster version " + String.valueOf(clusterVersion) + " (Rolling Member Upgrades are only supported for the following versions: " + supported + ")";
        if (joinMessage instanceof JoinRequest) {
            JoinRequest joinRequest2 = (JoinRequest)joinMessage;
            String supportedByThat = joinRequest2.getSupportedClusterVersions().stream().map(Version::toString).collect(Collectors.joining(", "));
            msg = msg + " (Joining node supports: " + supportedByThat + ")";
        }
        throw new VersionMismatchException(msg);
    }

    @Override
    public boolean isNodeVersionCompatibleWith(Version clusterVersion) {
        if (!this.isRollingUpgradeLicensed()) {
            return super.isNodeVersionCompatibleWith(clusterVersion);
        }
        Objects.requireNonNull(clusterVersion);
        return this.getSupportedVersions().contains(clusterVersion);
    }

    @Override
    public Set<Version> getSupportedVersions() {
        return this.supportedVersions;
    }

    @Override
    public void onInitialClusterState(ClusterState initialState) {
        super.onInitialClusterState(initialState);
        if (this.hotRestartService != null) {
            this.hotRestartService.onInitialClusterState(initialState);
        }
    }

    @Override
    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        super.onClusterStateChange(newState, isTransient);
        if (this.hotRestartService != null && !isTransient) {
            this.hotRestartService.getClusterMetadataManager().onClusterStateChange(newState);
        }
    }

    @Override
    public void onPartitionStateChange() {
        super.onPartitionStateChange();
        if (this.hotRestartService != null) {
            this.hotRestartService.getClusterMetadataManager().onPartitionStateChange();
        }
    }

    @Override
    public void onMemberListChange() {
        super.onMemberListChange();
        if (this.hotRestartService != null) {
            this.hotRestartService.getClusterMetadataManager().onMembershipChange();
        }
    }

    @Override
    public void onClusterVersionChange(Version newVersion) {
        super.onClusterVersionChange(newVersion);
        if (this.hotRestartService != null) {
            this.hotRestartService.getClusterMetadataManager().onClusterVersionChange(newVersion);
        }
    }

    @Override
    public boolean registerListener(Object listener) {
        super.registerListener(listener);
        if (listener instanceof ClusterHotRestartEventListener) {
            ClusterHotRestartEventListener eventListener = (ClusterHotRestartEventListener)listener;
            if (this.hotRestartService == null) {
                throw new HotRestartException("HotRestart is not enabled!");
            }
            this.hotRestartService.addClusterHotRestartEventListener(eventListener);
            return true;
        }
        return false;
    }

    public HazelcastMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public HotRestartService getHotRestartService() {
        if (this.hotBackupService == null) {
            return NO_OP_HOT_RESTART_SERVICE;
        }
        return this.hotBackupService;
    }

    @Override
    public UUID createMemberUuid() {
        UUID uuid;
        if (this.hotRestartService != null && (uuid = this.hotRestartService.getClusterMetadataManager().readMemberUuid()) != null) {
            return uuid;
        }
        return super.createMemberUuid();
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        if (this.memoryManager != null) {
            registry.registerStaticMetrics(this.memoryManager, "memorymanager");
            HazelcastMemoryManager hazelcastMemoryManager = this.memoryManager;
            if (hazelcastMemoryManager instanceof StaticMetricsProvider) {
                StaticMetricsProvider provider = (StaticMetricsProvider)((Object)hazelcastMemoryManager);
                provider.provideStaticMetrics(registry);
            }
        }
    }

    @Override
    public TimedMemberStateFactory createTimedMemberStateFactory(HazelcastInstanceImpl instance) {
        return new EnterpriseTimedMemberStateFactory(instance);
    }

    @Override
    public ByteArrayProcessor createMulticastInputProcessor(ServerContext serverContext) {
        SymmetricEncryptionConfig symmetricEncryptionConfig = serverContext.getSymmetricEncryptionConfig(EndpointQualifier.MEMBER);
        if (symmetricEncryptionConfig != null && symmetricEncryptionConfig.isEnabled()) {
            this.logger.info("Multicast is starting with SymmetricEncryption on input processor");
            return new CipherByteArrayProcessor(CipherHelper.createSymmetricReaderCipher(symmetricEncryptionConfig));
        }
        return super.createMulticastInputProcessor(serverContext);
    }

    @Override
    public ByteArrayProcessor createMulticastOutputProcessor(ServerContext serverContext) {
        SymmetricEncryptionConfig symmetricEncryptionConfig = serverContext.getSymmetricEncryptionConfig(EndpointQualifier.MEMBER);
        if (symmetricEncryptionConfig != null && symmetricEncryptionConfig.isEnabled()) {
            this.logger.info("Multicast is starting with SymmetricEncryption on output processor");
            return new CipherByteArrayProcessor(CipherHelper.createSymmetricWriterCipher(symmetricEncryptionConfig));
        }
        return super.createMulticastOutputProcessor(serverContext);
    }

    @Override
    public void registerPlugins(Diagnostics diagnostics) {
        super.registerPlugins(diagnostics);
        diagnostics.register(new WANPlugin(this.node.nodeEngine));
    }

    @Override
    public ManagementService createJMXManagementService(HazelcastInstanceImpl instance) {
        return new EnterpriseManagementService(instance);
    }

    @Override
    public TextCommandService createTextCommandService() {
        return new EnterpriseTextCommandServiceImpl(this.node);
    }

    private SocketInterceptorConfig getSocketInterceptorConfig(EndpointQualifier qualifier) {
        AdvancedNetworkConfig advancedNetworkConfig = this.node.getConfig().getAdvancedNetworkConfig();
        SocketInterceptorConfig socketInterceptorConfig = advancedNetworkConfig.isEnabled() ? advancedNetworkConfig.getEndpointConfigs().get(qualifier).getSocketInterceptorConfig() : this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
        return socketInterceptorConfig;
    }

    @Override
    public boolean isClientFailoverSupported() {
        return true;
    }

    @Override
    public AuditlogService getAuditlogService() {
        return this.auditlogService;
    }

    @Override
    public CPPersistenceService getCPPersistenceService() {
        if (this.cpPersistenceEnabled) {
            if (this.cpPersistenceService == null) {
                throw new IllegalStateException("CP persistence service is not initialized yet!");
            }
            return this.cpPersistenceService;
        }
        return NopCPPersistenceService.INSTANCE;
    }

    @Override
    public CPSubsystem createCPSubsystem(NodeEngine nodeEngine) {
        return this.license.getFeatures().contains(Feature.ADVANCED_CP) ? new CPSubsystemEnterpriseImpl(nodeEngine) : new CPSubsystemImpl(nodeEngine);
    }

    @Override
    public SSLEngineFactory createSslEngineFactory(SSLConfig sslConfig) {
        if (sslConfig == null || !sslConfig.isEnabled()) {
            return null;
        }
        SSLEngineFactory baseSslEngineFactory = this.loadSSLEngineFactory(sslConfig, false);
        return new FinishingSSLEngineFactoryDecorator(baseSslEngineFactory, sslConfig);
    }

    public LicenseMemoryChecker getLicenseMemoryChecker() {
        return this.licenseMemoryChecker;
    }

    private void launchTrialLicenseChecker(@Nonnull License license) {
        int licenseCheckInterval = this.node.getProperties().getInteger(LICENSE_CHECK_INTERVAL_IN_SECONDS);
        if (licenseCheckInterval > MAX_LICENSE_CHECK_INTERVAL_IN_SECONDS) {
            throw new InvalidConfigurationException("License check interval is an internal property used for testing and shouldn't be changed.");
        }
        if (this.trialLicenseChecker != null) {
            this.trialLicenseChecker.cancel(true);
        }
        if (!license.isTrial()) {
            return;
        }
        TrialLicenseExpirationCheckerTask trialLicenseExpirationCheckerTask = new TrialLicenseExpirationCheckerTask(this.node, license);
        this.trialLicenseChecker = this.node.nodeEngine.getExecutionService().getGlobalTaskScheduler().scheduleWithRepetition(trialLicenseExpirationCheckerTask, licenseCheckInterval, licenseCheckInterval, TimeUnit.SECONDS);
    }

    private SSLEngineFactory loadSSLEngineFactory(SSLConfig sslConfig, boolean forClient) {
        Object implementation = sslConfig.getFactoryImplementation();
        try {
            String factoryClassName = sslConfig.getFactoryClassName();
            if (implementation == null && factoryClassName != null) {
                implementation = Class.forName(factoryClassName).newInstance();
            }
            if (implementation == null) {
                implementation = this.loadDefaultImplementation();
            }
            if (implementation instanceof SSLContextFactory) {
                SSLContextFactory factory = (SSLContextFactory)implementation;
                implementation = new SSLEngineFactoryAdaptor(factory);
            }
            SSLEngineFactory sslEngineFactory = (SSLEngineFactory)implementation;
            sslEngineFactory.init(sslConfig.getProperties(), forClient);
            return sslEngineFactory;
        }
        catch (HazelcastException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidConfigurationException("Error while loading SSL engine for: " + this.getClass().getSimpleName(), e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Error while loading SSL engine for: " + this.getClass().getSimpleName(), e);
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    private Object loadDefaultImplementation() {
        this.logger.info("Default TLS implementation used: " + BasicSSLContextFactory.class.getName());
        return new BasicSSLContextFactory();
    }

    public TieredStoreService getTieredStoreService() {
        return this.tieredStoreService;
    }

    private InternalSerializationService createSerializationService(boolean isCompatibility) {
        InternalSerializationService ss;
        try {
            Config config = this.node.getConfig();
            ClassLoader configClassLoader = this.node.getConfigClassLoader();
            HazelcastInstanceImpl hazelcastInstance = this.node.hazelcastInstance;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            EnterpriseClusterVersionListener listener = new EnterpriseClusterVersionListener();
            this.clusterVersionListeners.add(listener);
            EnterpriseSerializationServiceBuilder builder = new EnterpriseSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            ss = (InternalSerializationService)builder.setMemoryManager(this.memoryManager).setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(hazelcastInstance.managedContext).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).setSchemaService(this.node.getSchemaService()).setVersionedSerializationEnabled(true).setClusterVersionAware(listener).isCompatibility(isCompatibility).setNotActiveExceptionSupplier(HazelcastInstanceNotActiveException::new).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    private UserCodeNamespaceService createNamespaceService(Config config) {
        ClassLoader parent = Node.getLegacyUCDClassLoader(config);
        if (!config.getNamespacesConfig().isEnabled()) {
            return new NoOpUserCodeNamespaceService(parent);
        }
        Map<String, UserCodeNamespaceConfig> staticNsConfig = ConfigAccessor.getNamespaceConfigs(config.getNamespacesConfig());
        return new UserCodeNamespaceServiceImpl(parent, staticNsConfig, config.getNamespacesConfig().getClassFilterConfig());
    }

    @Override
    public UserCodeNamespaceService getNamespaceService() {
        return this.userCodeNamespaceService;
    }

    @Override
    public TpcServerBootstrap createTpcServerBootstrap() {
        return new EnterpriseTpcServerBootstrap(this.node);
    }

    @Override
    public ClientEngine createClientEngine() {
        return new EnterpriseClientEngineImpl(this.node);
    }

    static {
        LICENSE_FEATURE_REMOVALS.put(LicenseVersion.V5, EnumSet.of(Feature.WEB_SESSION));
        LICENSE_FEATURE_ADDITIONS.put(LicenseVersion.V5, EnumSet.of(Feature.CLIENT_FILTERING, Feature.CP_PERSISTENCE));
        NOOP_INTERNAL_HOT_RESTART_SERVICE = new NoopInternalHotRestartService();
        NO_OP_HOT_RESTART_SERVICE = new NoOpHotRestartService();
        featureSet = new HashSet<Feature>();
    }
}

