/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.GeneratedBuildProperties;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.version.MemberVersion;
import java.util.Objects;
import javax.annotation.Nullable;

public final class BuildInfoProvider {
    public static final String HAZELCAST_INTERNAL_OVERRIDE_VERSION = "hazelcast.internal.override.version";
    public static final String HAZELCAST_INTERNAL_OVERRIDE_ENTERPRISE = "hazelcast.internal.override.enterprise";
    public static final String HAZELCAST_INTERNAL_OVERRIDE_LAST_LTS = "hazelcast.internal.override.lastLtsVersion";
    public static final String HAZELCAST_INTERNAL_OVERRIDE_PREV_VERSION = "hazelcast.internal.override.previousVersion";
    private static final String HAZELCAST_INTERNAL_OVERRIDE_BUILD = "hazelcast.build";
    private static final ILogger LOGGER = Logger.getLogger(BuildInfoProvider.class);
    private static final BuildInfo BUILD_INFO_CACHE = BuildInfoProvider.populateBuildInfoCache();

    private BuildInfoProvider() {
    }

    private static BuildInfo populateBuildInfoCache() {
        return BuildInfoProvider.getBuildInfoInternalVersion(Overrides.DISABLED);
    }

    public static BuildInfo getBuildInfo() {
        if (Overrides.isEnabled()) {
            Overrides overrides = Overrides.fromProperties();
            return BuildInfoProvider.getBuildInfoInternalVersion(overrides);
        }
        return BUILD_INFO_CACHE;
    }

    private static BuildInfo getBuildInfoInternalVersion(Overrides overrides) {
        BuildInfo buildInfo = BuildInfoProvider.readBuildPropertiesClass(GeneratedBuildProperties.class, null, overrides);
        try {
            Class<?> enterpriseClass = BuildInfoProvider.class.getClassLoader().loadClass("com.hazelcast.instance.GeneratedEnterpriseBuildProperties");
            if (enterpriseClass.getClassLoader() == BuildInfoProvider.class.getClassLoader()) {
                buildInfo = BuildInfoProvider.readBuildPropertiesClass(enterpriseClass, buildInfo, overrides);
            }
        }
        catch (ClassNotFoundException e) {
            EmptyStatement.ignore(e);
        }
        return buildInfo;
    }

    private static BuildInfo readBuildPropertiesClass(Class<?> clazz, BuildInfo upstreamBuildInfo, Overrides overrides) {
        String version = (String)ReflectionUtils.readStaticField(clazz, "VERSION");
        String build = (String)ReflectionUtils.readStaticField(clazz, "BUILD");
        String revision = (String)ReflectionUtils.readStaticField(clazz, "REVISION");
        String distribution = (String)ReflectionUtils.readStaticFieldOrNull(clazz, "DISTRIBUTION");
        String commitId = (String)ReflectionUtils.readStaticFieldOrNull(clazz, "COMMIT_ID");
        revision = BuildInfoProvider.checkMissingExpressionValue(revision, "${git.commit.id.abbrev}");
        commitId = BuildInfoProvider.checkMissingExpressionValue(commitId, "${git.commit.id}");
        String lastLtsVersion = (String)ReflectionUtils.readStaticField(clazz, "LAST_LTS_VERSION");
        String previousVersion = (String)ReflectionUtils.readStaticField(clazz, "PREVIOUS_MINOR_VERSION");
        int buildNumber = Integer.parseInt(build);
        boolean enterprise = !"Hazelcast".equals(distribution);
        String serialVersionString = (String)ReflectionUtils.readStaticFieldOrNull(clazz, "SERIALIZATION_VERSION");
        Objects.requireNonNull(serialVersionString, "serialization version must not be null");
        byte serialVersion = Byte.parseByte(serialVersionString);
        return overrides.apply(version, build, revision, buildNumber, enterprise, serialVersion, commitId, upstreamBuildInfo, MemberVersion.of(lastLtsVersion), MemberVersion.of(previousVersion));
    }

    private static String checkMissingExpressionValue(@Nullable String value, String expression) {
        if (value != null && !value.isEmpty() && value.equals(expression)) {
            return "";
        }
        return value;
    }

    private static final class Overrides {
        private static final Overrides DISABLED = new Overrides(null, -1, null, null, null);
        private final String version;
        private final int buildNo;
        private final Boolean enterprise;
        private final MemberVersion lastLtsVersion;
        private final MemberVersion previousVersion;

        private Overrides(String version, int build, Boolean enterprise, MemberVersion lastLtsVersion, MemberVersion previousVersion) {
            this.version = version;
            this.buildNo = build;
            this.enterprise = enterprise;
            this.lastLtsVersion = lastLtsVersion;
            this.previousVersion = previousVersion;
        }

        private BuildInfo apply(String version, String build, String revision, int buildNumber, boolean enterprise, byte serialVersion, String commitId, BuildInfo upstreamBuildInfo, MemberVersion lastLtsVersion, MemberVersion previousVersion) {
            if (this.buildNo != -1) {
                build = String.valueOf(this.buildNo);
                buildNumber = this.buildNo;
            }
            if (this.version != null) {
                LOGGER.info("Overriding hazelcast version with system property value " + this.version);
                version = this.version;
            }
            if (this.enterprise != null) {
                LOGGER.info("Overriding hazelcast enterprise flag with system property value " + this.enterprise);
                enterprise = this.enterprise;
            }
            if (this.lastLtsVersion != null) {
                LOGGER.info("Overriding hazelcast last LTS version with system property value " + String.valueOf(this.lastLtsVersion));
                lastLtsVersion = this.lastLtsVersion;
            }
            if (this.previousVersion != null) {
                LOGGER.info("Overriding hazelcast previous version with system property value " + String.valueOf(this.previousVersion));
                previousVersion = this.previousVersion;
            }
            return new BuildInfo(version, build, revision, buildNumber, enterprise, serialVersion, commitId, upstreamBuildInfo, lastLtsVersion, previousVersion);
        }

        private static boolean isEnabled() {
            return System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_BUILD) != null || System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_VERSION) != null || System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_ENTERPRISE) != null;
        }

        private static Overrides fromProperties() {
            String version = System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_VERSION);
            int build = Integer.getInteger(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_BUILD, -1);
            Boolean enterprise = null;
            String enterpriseOverride = System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_ENTERPRISE);
            if (enterpriseOverride != null) {
                enterprise = Boolean.valueOf(enterpriseOverride);
            }
            String lastLts = System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_LAST_LTS);
            MemberVersion lastLtsVersion = null;
            if (lastLts != null) {
                lastLtsVersion = MemberVersion.of(lastLts);
            }
            String prev = System.getProperty(BuildInfoProvider.HAZELCAST_INTERNAL_OVERRIDE_PREV_VERSION);
            MemberVersion prevVersion = null;
            if (prev != null) {
                prevVersion = MemberVersion.of(prev);
            }
            return new Overrides(version, build, enterprise, lastLtsVersion, prevVersion);
        }
    }
}

