/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.WanConsistencyCheckEvent;
import com.hazelcast.enterprise.wan.impl.WanSyncEvent;
import com.hazelcast.enterprise.wan.impl.replication.FullWanSyncStats;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchPublisher;
import com.hazelcast.enterprise.wan.impl.replication.WanPublisherSyncSupport;
import com.hazelcast.enterprise.wan.impl.replication.WanSyncContext;
import com.hazelcast.enterprise.wan.impl.replication.WanSyncException;
import com.hazelcast.enterprise.wan.impl.sync.GetMapPartitionDataOperation;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventResult;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateManager;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.events.WanFullSyncFinishedEvent;
import com.hazelcast.internal.management.events.WanSyncIgnoredEvent;
import com.hazelcast.internal.management.events.WanSyncProgressUpdateEvent;
import com.hazelcast.internal.management.events.WanSyncStartedEvent;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapSyncEvent;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.wan.impl.ConsistencyCheckResult;
import com.hazelcast.wan.impl.WanSyncStats;
import com.hazelcast.wan.impl.WanSyncType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WanPublisherFullSyncSupport
implements WanPublisherSyncSupport {
    private static final HazelcastProperty SYNC_ALL_MAPS_LEGACY = new HazelcastProperty("hazelcast.wan.sync.allmaps.legacy", false);
    private final ILogger logger;
    private final NodeEngineImpl nodeEngine;
    private final MapService mapService;
    private final WanBatchPublisher publisher;
    private final Map<String, FullWanSyncStats> lastSyncStats = new ConcurrentHashMap<String, FullWanSyncStats>();
    private final Map<UUID, WanSyncContext<FullWanSyncStats>> syncContextMap = new ConcurrentHashMap<UUID, WanSyncContext<FullWanSyncStats>>();
    private final ExecutorService updateSerializingExecutor;

    WanPublisherFullSyncSupport(Node node, WanBatchPublisher publisher) {
        this.nodeEngine = node.getNodeEngine();
        this.updateSerializingExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, ThreadUtil.createThreadName(node.hazelcastInstance.getName(), "wan-sync-stats-updater")));
        this.mapService = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        this.publisher = publisher;
        this.logger = this.nodeEngine.getLogger(WanPublisherFullSyncSupport.class);
    }

    @Override
    public void shutdown() {
        this.updateSerializingExecutor.shutdownNow();
    }

    @Override
    public void destroyMapData(String mapName) {
        this.lastSyncStats.remove(mapName);
    }

    @Override
    public void processEvent(WanSyncEvent event) {
        Collection<String> mapNames = this.getMapsToSynchronize(event);
        WanAntiEntropyEventResult result = event.getProcessingResult();
        if (!CollectionUtil.isEmpty(mapNames)) {
            Set<Integer> syncedPartitions = result.getProcessedPartitions();
            PartitionIdSet localPartitionIdsToSync = this.mapService.getMapServiceContext().getCachedOwnedPartitions();
            this.beforeSync(event.getUuid(), mapNames, localPartitionIdsToSync);
            Iterator iterator = localPartitionIdsToSync.iterator();
            while (iterator.hasNext()) {
                int partitionId = (Integer)iterator.next();
                this.syncPartition(event, partitionId);
                syncedPartitions.add(partitionId);
            }
        }
    }

    private Collection<String> getMapsToSynchronize(WanSyncEvent event) {
        Set<String> mapNames;
        if (event.getType() == WanSyncType.ALL_MAPS) {
            Set<String> allMapNames = this.mapService.getMapServiceContext().getMapContainers().keySet();
            mapNames = SetUtil.createHashSet(allMapNames.size());
            for (String mapName : allMapNames) {
                if (!this.isMapWanReplicated(mapName, event.getWanReplicationName())) continue;
                mapNames.add(mapName);
            }
            if (mapNames.isEmpty()) {
                this.getWanSyncStateManager().finishLocal(event.getUuid(), WanSyncStateManager.WanSyncStateStage.FINISHED);
                this.nodeEngine.getManagementCenterService().log(new WanSyncIgnoredEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, null, "No maps found to synchronize."));
            }
        } else {
            String mapName = event.getObjectName();
            if (!this.isMapWanReplicated(mapName, event.getWanReplicationName())) {
                String error = "WAN synchronization requested for map " + mapName + " that is not configured for WAN replication: " + event.getWanReplicationName();
                this.nodeEngine.getManagementCenterService().log(new WanSyncIgnoredEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, error));
                throw new IllegalArgumentException(error);
            }
            mapNames = SetUtil.createHashSet(1);
            mapNames.add(mapName);
        }
        return mapNames;
    }

    protected boolean isMapWanReplicated(String mapName, String wanReplicationName) {
        boolean legacyMode = this.nodeEngine.getProperties().getBoolean(SYNC_ALL_MAPS_LEGACY);
        MapContainer mapContainer = this.mapService.getMapServiceContext().getMapContainer(mapName);
        boolean isEnabled = mapContainer.getWanContext().isWanReplicationEnabled();
        return legacyMode ? isEnabled : isEnabled && mapContainer.getWanContext().getWanReplicationDelegate().getName().equals(wanReplicationName);
    }

    private void beforeSync(UUID uuid, Collection<String> mapNames, Collection<Integer> localPartitionIdsToSync) {
        WanSyncContext<FullWanSyncStats> syncContext = new WanSyncContext<FullWanSyncStats>(uuid, localPartitionIdsToSync, mapNames);
        this.syncContextMap.put(uuid, syncContext);
        for (String mapName : mapNames) {
            this.nodeEngine.getManagementCenterService().log(new WanSyncStartedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName));
            FullWanSyncStats syncStats = new FullWanSyncStats(uuid, localPartitionIdsToSync.size());
            syncContext.addSyncStats(mapName, syncStats);
            this.lastSyncStats.put(mapName, syncStats);
        }
        this.getWanSyncStateManager().initializeLocal(syncContext.getUuid(), syncContext.getMapNames(), this.nodeEngine);
    }

    private WanSyncStateManager getWanSyncStateManager() {
        EnterpriseWanReplicationService wanReplicationService = (EnterpriseWanReplicationService)this.nodeEngine.getWanReplicationService();
        return wanReplicationService.getSyncManager().getWanSyncStateManager();
    }

    private void writeMcSyncFinishedEvent(UUID uuid, String mapName, FullWanSyncStats syncStats) {
        WanFullSyncFinishedEvent syncFinishedEvent = new WanFullSyncFinishedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, syncStats.getDurationSecs(), syncStats.getRecordsSynced(), syncStats.getPartitionsSynced());
        this.nodeEngine.getManagementCenterService().log(syncFinishedEvent);
    }

    @Override
    public void processEvent(WanConsistencyCheckEvent event) {
    }

    @Override
    public Map<String, ConsistencyCheckResult> getLastConsistencyCheckResults() {
        return null;
    }

    @Override
    public Map<String, WanSyncStats> getLastSyncStats() {
        return Collections.unmodifiableMap(this.lastSyncStats);
    }

    @Override
    public void removeReplicationEvent(WanEnterpriseMapEvent replicationObject) {
        WanEnterpriseMapSyncEvent sync = (WanEnterpriseMapSyncEvent)replicationObject;
        WanSyncContext<FullWanSyncStats> syncContext = this.syncContextMap.get(sync.getUuid());
        String mapName = sync.getMapName();
        int partitionId = sync.getPartitionId();
        FullWanSyncStats syncStats = syncContext.getSyncStats(mapName);
        syncStats.onSyncRecord();
        this.updateSerializingExecutor.execute(() -> {
            int remainingEventCount = syncContext.getSyncCounter(mapName, partitionId).decrementAndGet();
            if (remainingEventCount == 0) {
                this.progressSyncContext(syncContext, mapName, syncStats);
            }
        });
    }

    private void progressSyncContext(WanSyncContext<FullWanSyncStats> syncContext, String mapName, FullWanSyncStats syncStats) {
        int partitionsSynced = syncStats.onSyncPartition();
        WanSyncProgressUpdateEvent updateEvent = new WanSyncProgressUpdateEvent(syncContext.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, syncStats.getPartitionsToSync(), partitionsSynced, syncStats.getRecordsSynced());
        this.nodeEngine.getManagementCenterService().log(updateEvent);
        this.getWanSyncStateManager().progressLocal(syncContext.getUuid(), syncContext.getSyncStatsMap());
        this.completeSyncContext(syncContext, mapName, syncStats, partitionsSynced);
    }

    private void completeSyncContext(WanSyncContext<FullWanSyncStats> syncContext, String mapName, FullWanSyncStats syncStats, int partitionsSynced) {
        if (syncStats.getPartitionsToSync() == partitionsSynced) {
            syncContext.onMapSynced();
            syncStats.onSyncComplete();
            this.logSyncStats(syncStats, mapName);
            this.writeMcSyncFinishedEvent(syncContext.getUuid(), mapName, syncStats);
            this.cleanupSyncContextMap();
        }
    }

    private void cleanupSyncContextMap() {
        for (Map.Entry<UUID, WanSyncContext<FullWanSyncStats>> entry : this.syncContextMap.entrySet()) {
            UUID key = entry.getKey();
            WanSyncContext<FullWanSyncStats> context = entry.getValue();
            if (!context.isCompletedOrStuck()) continue;
            this.getWanSyncStateManager().finishLocal(key, context.isMapsLeft() ? WanSyncStateManager.WanSyncStateStage.FAILED : WanSyncStateManager.WanSyncStateStage.FINISHED);
            this.syncContextMap.remove(key);
        }
    }

    private void logSyncStats(FullWanSyncStats stats, String mapName) {
        String syncStatsMsg = String.format("Synchronization finished for map '%s' %n%nSynchronization statistics:%n\t Synchronization UUID: %s%n\t Duration: %d secs%n\t Total records synchronized: %d%n\t Total partitions synchronized: %d%n", mapName, stats.getUuid(), stats.getDurationSecs(), stats.getRecordsSynced(), stats.getPartitionsSynced());
        this.logger.info(syncStatsMsg);
    }

    private void syncPartition(WanSyncEvent syncEvent, int partitionId) {
        UUID eventUuid = syncEvent.getUuid();
        WanSyncContext<FullWanSyncStats> syncContext = this.syncContextMap.get(eventUuid);
        if (syncEvent.getType() == WanSyncType.ALL_MAPS) {
            for (String mapName : syncContext.getMapNames()) {
                this.syncPartitionForMap(syncContext, mapName, partitionId);
            }
        } else {
            String mapName = syncEvent.getObjectName();
            this.syncPartitionForMap(syncContext, mapName, partitionId);
        }
    }

    private int syncPartitionForMap(WanSyncContext<FullWanSyncStats> syncContext, String mapName, int partitionId) {
        if (!this.mapService.getMapServiceContext().getCachedOwnedPartitions().contains(partitionId)) {
            throw new WanSyncException("Partition: " + partitionId + " is migrated to another cluster during sync.");
        }
        GetMapPartitionDataOperation op = new GetMapPartitionDataOperation(mapName);
        op.setValidateTarget(false);
        op.setPartitionId(partitionId);
        Set set = (Set)this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:mapService", op, this.nodeEngine.getThisAddress()).joinInternal();
        int syncedEntries = set.size();
        syncContext.getSyncCounter(mapName, partitionId).addAndGet(syncedEntries);
        for (WanMapEntryView entryView : set) {
            WanEnterpriseMapSyncEvent sync = new WanEnterpriseMapSyncEvent(syncContext.getUuid(), mapName, entryView, partitionId);
            this.publisher.putToSyncEventQueue(sync);
        }
        if (syncedEntries == 0) {
            FullWanSyncStats syncStats = syncContext.getSyncStats(mapName);
            this.updateSerializingExecutor.execute(() -> this.progressSyncContext(syncContext, mapName, syncStats));
        }
        return syncedEntries;
    }
}

