/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raftop.metadata;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPGroupsSnapshot;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.MetadataRaftGroupManager;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RaftServicePreJoinOp
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState,
Versioned {
    private boolean discoveryCompleted;
    private RaftGroupId metadataGroupId;
    private CPGroupsSnapshot cpGroupsSnapshot;

    public RaftServicePreJoinOp() {
    }

    public RaftServicePreJoinOp(boolean discoveryCompleted, RaftGroupId metadataGroupId, CPGroupsSnapshot cpGroupsSnapshot) {
        this.discoveryCompleted = discoveryCompleted;
        this.metadataGroupId = metadataGroupId;
        this.cpGroupsSnapshot = cpGroupsSnapshot;
    }

    @Override
    public void run() {
        RaftService service = (RaftService)this.getService();
        MetadataRaftGroupManager metadataGroupManager = service.getMetadataGroupManager();
        metadataGroupManager.handleMetadataGroupId(this.metadataGroupId);
        if (this.discoveryCompleted) {
            metadataGroupManager.disableDiscovery();
        }
        service.getGroupViewTracker().receivePreJoinOp(this.cpGroupsSnapshot);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 39;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.discoveryCompleted);
        out.writeObject(this.metadataGroupId);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_5)) {
            Map<CPGroupId, CPGroupsSnapshot.GroupInfo> allGroupInfo = this.cpGroupsSnapshot.getAllGroupInformation();
            out.writeInt(allGroupInfo.size());
            for (Map.Entry<CPGroupId, CPGroupsSnapshot.GroupInfo> entry : allGroupInfo.entrySet()) {
                out.writeObject(entry.getKey());
                CPGroupsSnapshot.GroupInfo groupInfo = entry.getValue();
                out.writeInt(groupInfo.term());
                out.writeObject(groupInfo.leader());
                int followersLen = groupInfo.followers().size();
                out.writeInt(followersLen);
                for (CPMember follower : groupInfo.followers()) {
                    out.writeObject(follower);
                }
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.discoveryCompleted = in.readBoolean();
        this.metadataGroupId = (RaftGroupId)in.readObject();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_5)) {
            int allGroupsLen = in.readInt();
            HashMap<CPGroupId, CPGroupsSnapshot.GroupInfo> allGroupInfo = new HashMap<CPGroupId, CPGroupsSnapshot.GroupInfo>(allGroupsLen);
            for (int k = 0; k < allGroupsLen; ++k) {
                CPGroupId groupId = (CPGroupId)in.readObject();
                int term = in.readInt();
                CPMember leader = (CPMember)in.readObject();
                int followersLen = in.readInt();
                HashSet<CPMember> followers = new HashSet<CPMember>(followersLen);
                for (int i = 0; i < followersLen; ++i) {
                    followers.add((CPMember)in.readObject());
                }
                allGroupInfo.put(groupId, new CPGroupsSnapshot.GroupInfo(leader, followers, term));
            }
            this.cpGroupsSnapshot = new CPGroupsSnapshot(allGroupInfo);
        } else {
            this.cpGroupsSnapshot = new CPGroupsSnapshot(Map.of());
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", discoveryCompleted=").append(this.discoveryCompleted).append(", metadataGroupId=").append(this.metadataGroupId).append(", cpGroupsSnapshot=").append(this.cpGroupsSnapshot);
    }
}

