/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.persistence.BufferedRaf;
import com.hazelcast.cp.internal.persistence.FileIOSupport;
import com.hazelcast.cp.internal.persistence.LogEntryRingBuffer;
import com.hazelcast.cp.internal.persistence.RestoredLogFile;
import com.hazelcast.cp.internal.raft.exception.LogValidationException;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateLoader;
import com.hazelcast.cp.internal.raft.impl.persistence.RestoredRaftState;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

public class OnDiskRaftStateLoader
implements RaftStateLoader {
    private static final LogEntry[] EMPTY_LOG_ENTRY_ARRAY = new LogEntry[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final File baseDir;
    private final int maxUncommittedEntries;
    private final InternalSerializationService serializationService;
    private final ILogger logger;
    private LogFileStructure logFileStructure;

    public OnDiskRaftStateLoader(@Nonnull File baseDir, int maxUncommittedEntries, @Nonnull InternalSerializationService serializationService, ILogger logger) {
        this.baseDir = baseDir;
        this.maxUncommittedEntries = maxUncommittedEntries;
        this.serializationService = serializationService;
        this.logger = logger;
    }

    @Override
    @Nonnull
    public RestoredRaftState load() throws IOException {
        this.checkFileExists("members");
        BiTuple<Integer, RaftEndpoint> termAndVote = this.readVoteAndTerm();
        BiTuple<RaftEndpoint, Collection<RaftEndpoint>> members = this.readMembers();
        int term = (Integer)termAndVote.element1;
        RaftEndpoint votedFor = (RaftEndpoint)termAndVote.element2;
        RaftEndpoint localMember = (RaftEndpoint)members.element1;
        Collection initialMembers = (Collection)members.element2;
        String[] filenames = this.baseDir.list((dir, name) -> name.startsWith("raftlog-"));
        if (filenames == null) {
            throw new IOException("Error opening the Raft log directory");
        }
        if (filenames.length == 0) {
            this.logFileStructure = new LogFileStructure("", EMPTY_LONG_ARRAY, 0L);
            return new RestoredRaftState(localMember, initialMembers, term, votedFor, null, EMPTY_LOG_ENTRY_ARRAY);
        }
        RestoredLogFile restored = this.loadFileWithMostRecentEntry(filenames);
        this.deleteAllExcept(filenames, restored.filename());
        this.logFileStructure = restored.toLogFileStructure();
        return new RestoredRaftState(localMember, initialMembers, term, votedFor, restored.snapshotEntry(), restored.entries());
    }

    public int maxUncommittedEntries() {
        return this.maxUncommittedEntries;
    }

    @Nonnull
    public LogFileStructure logFileStructure() {
        return Objects.requireNonNull(this.logFileStructure);
    }

    private void checkFileExists(String fileName) throws IOException {
        File file = new File(this.baseDir, fileName);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("Error opening the Raft log directory! No " + fileName + " file!");
        }
    }

    @Nonnull
    private RestoredLogFile loadFileWithMostRecentEntry(String[] filenames) throws IOException {
        Arrays.sort(filenames);
        Collections.reverse(Arrays.asList(filenames));
        RestoredLogFile mostRecent = this.loadFile(filenames[0], RestoredLogFile.LoadMode.FULL);
        for (int i = 1; i < filenames.length; ++i) {
            String fname = filenames[i];
            RestoredLogFile rlf = this.loadFile(fname, RestoredLogFile.LoadMode.JUST_TOP_INDEX);
            if (rlf.topIndex() <= mostRecent.topIndex()) continue;
            mostRecent = rlf;
        }
        return mostRecent.loadMode() == RestoredLogFile.LoadMode.FULL ? mostRecent : this.loadFile(mostRecent.filename(), RestoredLogFile.LoadMode.FULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestoredLogFile loadFile(String fname, RestoredLogFile.LoadMode loadMode) throws IOException {
        File file = new File(this.baseDir, fname);
        BufferedRaf raf = new BufferedRaf(new RandomAccessFile(file, "rw"));
        BufferedRaf.BufRafObjectDataIn in = raf.asObjectDataInputStream(this.serializationService);
        try {
            long entryOffset;
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            long topIndex = 0L;
            LogEntryRingBuffer entryRingBuffer = null;
            SnapshotEntry snapshotEntry = null;
            while ((entryOffset = raf.filePointer()) != raf.length()) {
                int len = raf.readInt();
                int required = len + 4;
                if (raf.available() < (long)required) {
                    this.logger.info("Truncating " + String.valueOf(file) + " after position " + entryOffset + " (file length was " + raf.length() + "). Because " + required + " bytes is required, but only " + (raf.available() + 4L) + " bytes is available. Most probably last entry was written partially and not ACKed to the leader.");
                    raf.seek(entryOffset);
                    raf.setLength(entryOffset);
                    break;
                }
                LogEntry entry = (LogEntry)in.readObject();
                in.checkCrc32();
                OnDiskRaftStateLoader.checkIndexGreaterThanPrevious(entry, topIndex, fname);
                if (entry instanceof SnapshotEntry) {
                    OnDiskRaftStateLoader.checkSnapshotEntryIsFirst(topIndex, fname);
                    snapshotEntry = (SnapshotEntry)entry;
                } else if (loadMode == RestoredLogFile.LoadMode.FULL) {
                    entries.add(entry);
                    if (entryRingBuffer == null) {
                        entryRingBuffer = new LogEntryRingBuffer(this.maxUncommittedEntries, entry.index());
                    }
                    entryRingBuffer.addEntryOffset(entryOffset);
                }
                topIndex = entry.index();
            }
            RestoredLogFile restoredLogFile = loadMode == RestoredLogFile.LoadMode.FULL ? new RestoredLogFile(fname, snapshotEntry, entries.toArray(EMPTY_LOG_ENTRY_ARRAY), entryRingBuffer != null ? entryRingBuffer.exportEntryOffsets() : EMPTY_LONG_ARRAY, topIndex) : new RestoredLogFile(fname, topIndex);
            return restoredLogFile;
        }
        finally {
            IOUtil.closeResource(raf);
        }
    }

    private static void checkIndexGreaterThanPrevious(LogEntry entry, long topIndex, String fname) throws LogValidationException {
        if (entry.index() < topIndex) {
            throw new LogValidationException(String.format("Invalid entry index in file %s. Top index so far: %,d, now read %,d.", fname, topIndex, entry.index()));
        }
    }

    private static void checkSnapshotEntryIsFirst(long topIndex, String fname) throws LogValidationException {
        if (topIndex != 0L) {
            throw new LogValidationException("Snapshot entry not at the start of the file " + fname);
        }
    }

    private BiTuple<Integer, RaftEndpoint> readVoteAndTerm() throws IOException {
        BiTuple<Integer, Object> result = this.runRead("term", in -> {
            int term = in.readInt();
            RaftEndpoint votedFor = (RaftEndpoint)in.readObject();
            return BiTuple.of(term, votedFor);
        });
        return result != null ? result : BiTuple.of(0, null);
    }

    private BiTuple<RaftEndpoint, Collection<RaftEndpoint>> readMembers() throws IOException {
        return this.runRead("members", in -> {
            RaftEndpoint localMember = (RaftEndpoint)in.readObject();
            Collection initialMembers = SerializationUtil.readCollection(in);
            return BiTuple.of(localMember, initialMembers);
        });
    }

    private <T> T runRead(String filename, FileIOSupport.Readable<T> task) throws IOException {
        return FileIOSupport.readWithChecksum(this.baseDir, filename, this.serializationService, task);
    }

    private void deleteAllExcept(String[] allFilenames, String chosen) {
        for (String fname : allFilenames) {
            if (fname.equals(chosen)) continue;
            IOUtil.delete(new File(this.baseDir, fname));
        }
    }
}

