/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomiclong;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomiclong.AtomicLong;
import com.hazelcast.cp.internal.datastructures.atomiclong.AtomicLongSnapshot;
import com.hazelcast.cp.internal.datastructures.atomiclong.proxy.AtomicLongProxy;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValueService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AtomicLongService
extends RaftAtomicValueService<Long, AtomicLong, AtomicLongSnapshot>
implements DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:raft:atomicLongService";

    public AtomicLongService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        super.init(nodeEngine, properties);
        if (nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES)) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    protected AtomicLongSnapshot newSnapshot(Map<String, Long> values, Set<String> destroyed) {
        return new AtomicLongSnapshot(values, destroyed);
    }

    @Override
    protected AtomicLong newAtomicValue(CPGroupId groupId, String name, Long val) {
        return new AtomicLong(groupId, name, val != null ? val : 0L);
    }

    @Override
    protected IAtomicLong newRaftAtomicProxy(NodeEngineImpl nodeEngine, RaftGroupId groupId, String proxyName, String objectNameForProxy) {
        return new AtomicLongProxy(nodeEngine, groupId, proxyName, objectNameForProxy);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.atomiclong");
        HashMap<CPGroupId, Long> liveCounts = new HashMap<CPGroupId, Long>();
        for (AtomicLong value : this.atomicValues.values()) {
            CPGroupId groupId = value.groupId();
            String groupName = groupId.getName();
            MetricDescriptor desc = root.copy().withDiscriminator("id", value.name() + "@" + groupName).withTag("name", value.name()).withTag("group", groupName).withMetric("value");
            context.collect(desc, value.value());
            liveCounts.merge(groupId, 1L, Long::sum);
        }
        this.addSummaryMetrics(root.withPrefix("cp.atomiclong.summary"), context, liveCounts);
    }
}

