/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.vector;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.vector.Metric;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.Beta;
import java.io.IOException;
import java.util.Objects;

@Beta
public class VectorIndexConfig
implements NamedConfig,
IdentifiedDataSerializable {
    private static final int DEFAULT_MAX_DEGREE = 16;
    private static final int DEFAULT_EF_CONSTRUCTION = 100;
    private static final boolean DEFAULT_USE_DEDUPLICATION = true;
    private String indexName;
    private Metric metric;
    private int dimension;
    private int maxDegree = 16;
    private int efConstruction = 100;
    private boolean useDeduplication = true;

    public VectorIndexConfig(String indexName, Metric metric, int dimension) {
        VectorIndexConfig.validateName(indexName);
        Objects.requireNonNull(metric, "metric must not be null.");
        this.indexName = indexName;
        this.metric = metric;
        this.dimension = dimension;
    }

    public VectorIndexConfig(String indexName, Metric metric, int dimension, int maxDegree, int efConstruction, boolean useDeduplication) {
        VectorIndexConfig.validateName(indexName);
        Objects.requireNonNull(metric, "metric must not be null.");
        if (maxDegree <= 0) {
            throw new IllegalArgumentException("max connections must be positive");
        }
        if (efConstruction <= 0) {
            throw new IllegalArgumentException("efConstruction must be positive");
        }
        this.indexName = indexName;
        this.metric = metric;
        this.dimension = dimension;
        this.maxDegree = maxDegree;
        this.efConstruction = efConstruction;
        this.useDeduplication = useDeduplication;
    }

    public VectorIndexConfig() {
    }

    public VectorIndexConfig(VectorIndexConfig config) {
        Objects.requireNonNull(config, "config must not be null.");
        this.indexName = config.getName();
        this.metric = config.getMetric();
        this.dimension = config.getDimension();
        this.maxDegree = config.getMaxDegree();
        this.efConstruction = config.getEfConstruction();
        this.useDeduplication = config.isUseDeduplication();
    }

    public Metric getMetric() {
        return this.metric;
    }

    public VectorIndexConfig setMetric(Metric metric) {
        Objects.requireNonNull(metric, "metric must not be null.");
        this.metric = metric;
        return this;
    }

    public int getDimension() {
        return this.dimension;
    }

    public VectorIndexConfig setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public VectorIndexConfig setMaxDegree(int maxDegree) {
        if (maxDegree <= 0) {
            throw new IllegalArgumentException("max connections must be positive");
        }
        this.maxDegree = maxDegree;
        return this;
    }

    public int getEfConstruction() {
        return this.efConstruction;
    }

    public VectorIndexConfig setEfConstruction(int efConstruction) {
        if (efConstruction <= 0) {
            throw new IllegalArgumentException("efConstruction width must be positive");
        }
        this.efConstruction = efConstruction;
        return this;
    }

    public boolean isUseDeduplication() {
        return this.useDeduplication;
    }

    public VectorIndexConfig setUseDeduplication(boolean useDeduplication) {
        this.useDeduplication = useDeduplication;
        return this;
    }

    @Override
    public VectorIndexConfig setName(String name) {
        VectorIndexConfig.validateName(name);
        this.indexName = name;
        return this;
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeInt(this.dimension);
        out.writeInt(this.metric.getId());
        out.writeInt(this.maxDegree);
        out.writeInt(this.efConstruction);
        out.writeBoolean(this.useDeduplication);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.indexName = in.readString();
        this.dimension = in.readInt();
        this.metric = Metric.getById(in.readInt());
        this.maxDegree = in.readInt();
        this.efConstruction = in.readInt();
        this.useDeduplication = in.readBoolean();
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 73;
    }

    private static void validateName(String name) {
        if (name == null) {
            return;
        }
        String allowedSymbols = "[a-zA-Z0-9\\-_]+";
        if (!name.matches(allowedSymbols)) {
            throw new IllegalArgumentException("The name of the vector index should only consist of letters, numbers, and the symbols \"-\" or \"_\".");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VectorIndexConfig that = (VectorIndexConfig)object;
        return this.dimension == that.dimension && this.maxDegree == that.maxDegree && this.efConstruction == that.efConstruction && this.useDeduplication == that.useDeduplication && Objects.equals(this.indexName, that.indexName) && this.metric == that.metric;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexName, this.metric, this.dimension, this.maxDegree, this.efConstruction, this.useDeduplication});
    }

    public String toString() {
        return "VectorIndexConfig{indexName='" + this.indexName + "', metric=" + String.valueOf((Object)this.metric) + ", dimension=" + this.dimension + ", maxDegree=" + this.maxDegree + ", efConstruction=" + this.efConstruction + ", useDeduplication=" + this.useDeduplication + "}";
    }
}

