/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.BaseMetricsConfig;
import com.hazelcast.config.MetricsManagementCenterConfig;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MetricsConfig
extends BaseMetricsConfig<MetricsConfig> {
    private MetricsManagementCenterConfig managementCenterConfig = new MetricsManagementCenterConfig();

    public MetricsConfig() {
    }

    public MetricsConfig(MetricsConfig metricsConfig) {
        super(metricsConfig);
        this.managementCenterConfig = new MetricsManagementCenterConfig(metricsConfig.managementCenterConfig);
    }

    @Nonnull
    public MetricsConfig setManagementCenterConfig(MetricsManagementCenterConfig managementCenterConfig) {
        this.managementCenterConfig = Objects.requireNonNull(managementCenterConfig, "Management Center config must not be null");
        return this;
    }

    @Nonnull
    public MetricsManagementCenterConfig getManagementCenterConfig() {
        return this.managementCenterConfig;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig that = (MetricsConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.collectionFrequencySeconds != that.collectionFrequencySeconds) {
            return false;
        }
        if (!Objects.equals(this.managementCenterConfig, that.managementCenterConfig)) {
            return false;
        }
        return Objects.equals(this.jmxConfig, that.jmxConfig);
    }

    public final int hashCode() {
        int result = Boolean.hashCode(this.enabled);
        result = 31 * result + (this.managementCenterConfig != null ? this.managementCenterConfig.hashCode() : 0);
        result = 31 * result + (this.jmxConfig != null ? this.jmxConfig.hashCode() : 0);
        result = 31 * result + this.collectionFrequencySeconds;
        return result;
    }

    public String toString() {
        return "MetricsConfig{enabled=" + this.enabled + ", managementCenterConfig=" + String.valueOf(this.managementCenterConfig) + ", jmxConfig=" + String.valueOf(this.jmxConfig) + ", collectionFrequencySeconds=" + this.collectionFrequencySeconds + "}";
    }
}

