/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MetadataPolicy;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.UserCodeNamespaceAwareConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.config.DataPersistenceAndHotRestartMerger;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapConfig
implements IdentifiedDataSerializable,
NamedConfig,
Versioned,
UserCodeNamespaceAwareConfig<MapConfig> {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final int MAX_BACKUP_COUNT = 6;
    public static final int DISABLED_TTL_SECONDS = 0;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    public static final CacheDeserializedValues DEFAULT_CACHED_DESERIALIZED_VALUES = CacheDeserializedValues.INDEX_ONLY;
    public static final MetadataPolicy DEFAULT_METADATA_POLICY = MetadataPolicy.CREATE_ON_UPDATE;
    public static final boolean DEFAULT_STATISTICS_ENABLED = true;
    public static final boolean DEFAULT_ENTRY_STATS_ENABLED = false;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final MaxSizePolicy DEFAULT_MAX_SIZE_POLICY = MaxSizePolicy.PER_NODE;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.NONE;
    private boolean readBackupData;
    private boolean statisticsEnabled = true;
    private boolean perEntryStatsEnabled = false;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private int timeToLiveSeconds = 0;
    private int maxIdleSeconds = 0;
    private String name;
    private String splitBrainProtectionName;
    private MapStoreConfig mapStoreConfig = new MapStoreConfig().setEnabled(false);
    private NearCacheConfig nearCacheConfig;
    private CacheDeserializedValues cacheDeserializedValues = DEFAULT_CACHED_DESERIALIZED_VALUES;
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private WanReplicationRef wanReplicationRef;
    private List<EntryListenerConfig> entryListenerConfigs;
    private List<MapPartitionLostListenerConfig> partitionLostListenerConfigs;
    private List<IndexConfig> indexConfigs;
    private List<AttributeConfig> attributeConfigs;
    private List<QueryCacheConfig> queryCacheConfigs;
    private PartitioningStrategyConfig partitioningStrategyConfig;
    private MetadataPolicy metadataPolicy = DEFAULT_METADATA_POLICY;
    private HotRestartConfig hotRestartConfig = new HotRestartConfig();
    private DataPersistenceConfig dataPersistenceConfig = new DataPersistenceConfig();
    private MerkleTreeConfig merkleTreeConfig = new MerkleTreeConfig();
    private EventJournalConfig eventJournalConfig = new EventJournalConfig();
    private EvictionConfig evictionConfig = new EvictionConfig().setEvictionPolicy(DEFAULT_EVICTION_POLICY).setMaxSizePolicy(DEFAULT_MAX_SIZE_POLICY).setSize(Integer.MAX_VALUE);
    private TieredStoreConfig tieredStoreConfig = new TieredStoreConfig();
    private List<PartitioningAttributeConfig> partitioningAttributeConfigs;
    @Nullable
    private String userCodeNamespace = DEFAULT_NAMESPACE;

    public MapConfig() {
    }

    public MapConfig(String name) {
        this.setName(name);
    }

    public MapConfig(MapConfig config) {
        this.name = config.name;
        this.backupCount = config.backupCount;
        this.asyncBackupCount = config.asyncBackupCount;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
        this.maxIdleSeconds = config.maxIdleSeconds;
        this.metadataPolicy = config.metadataPolicy;
        this.evictionConfig = new EvictionConfig(config.evictionConfig);
        this.inMemoryFormat = config.inMemoryFormat;
        this.mapStoreConfig = config.mapStoreConfig != null ? new MapStoreConfig(config.mapStoreConfig) : null;
        this.nearCacheConfig = config.nearCacheConfig != null ? new NearCacheConfig(config.nearCacheConfig) : null;
        this.readBackupData = config.readBackupData;
        this.cacheDeserializedValues = config.cacheDeserializedValues;
        this.statisticsEnabled = config.statisticsEnabled;
        this.perEntryStatsEnabled = config.perEntryStatsEnabled;
        this.mergePolicyConfig = new MergePolicyConfig(config.mergePolicyConfig);
        this.wanReplicationRef = config.wanReplicationRef != null ? new WanReplicationRef(config.wanReplicationRef) : null;
        this.entryListenerConfigs = new ArrayList<EntryListenerConfig>(config.getEntryListenerConfigs());
        this.partitionLostListenerConfigs = new ArrayList<MapPartitionLostListenerConfig>(config.getPartitionLostListenerConfigs());
        this.indexConfigs = new ArrayList<IndexConfig>(config.getIndexConfigs());
        this.attributeConfigs = new ArrayList<AttributeConfig>(config.getAttributeConfigs());
        this.queryCacheConfigs = new ArrayList<QueryCacheConfig>(config.getQueryCacheConfigs());
        this.partitioningStrategyConfig = config.partitioningStrategyConfig != null ? new PartitioningStrategyConfig(config.getPartitioningStrategyConfig()) : null;
        this.splitBrainProtectionName = config.splitBrainProtectionName;
        this.hotRestartConfig = new HotRestartConfig(config.hotRestartConfig);
        this.dataPersistenceConfig = new DataPersistenceConfig(config.dataPersistenceConfig);
        this.merkleTreeConfig = new MerkleTreeConfig(config.merkleTreeConfig);
        this.eventJournalConfig = new EventJournalConfig(config.eventJournalConfig);
        this.tieredStoreConfig = new TieredStoreConfig(config.tieredStoreConfig);
        this.partitioningAttributeConfigs = new ArrayList<PartitioningAttributeConfig>(config.getPartitioningAttributeConfigs());
        this.userCodeNamespace = config.userCodeNamespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapConfig setName(String name) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public MapConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = Preconditions.isNotNull(inMemoryFormat, "inMemoryFormat");
        return this;
    }

    public EvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public MapConfig setEvictionConfig(EvictionConfig evictionConfig) {
        this.evictionConfig = Preconditions.isNotNull(evictionConfig, "evictionConfig");
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public MapConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public MapConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public MapConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public MapConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfig;
    }

    public MapConfig setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
        return this;
    }

    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfig;
    }

    public MapConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfig = nearCacheConfig;
        return this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public MapConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null!");
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public MapConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public boolean isPerEntryStatsEnabled() {
        return this.perEntryStatsEnabled;
    }

    public MapConfig setPerEntryStatsEnabled(boolean perEntryStatsEnabled) {
        this.perEntryStatsEnabled = perEntryStatsEnabled;
        return this;
    }

    public boolean isReadBackupData() {
        return this.readBackupData;
    }

    public MapConfig setReadBackupData(boolean readBackupData) {
        this.readBackupData = readBackupData;
        return this;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public MapConfig setWanReplicationRef(WanReplicationRef wanReplicationRef) {
        this.wanReplicationRef = wanReplicationRef;
        return this;
    }

    public MapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.entryListenerConfigs == null) {
            this.entryListenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.entryListenerConfigs;
    }

    public MapConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        this.entryListenerConfigs = listenerConfigs;
        return this;
    }

    public MapConfig addMapPartitionLostListenerConfig(MapPartitionLostListenerConfig listenerConfig) {
        this.getPartitionLostListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<MapPartitionLostListenerConfig> getPartitionLostListenerConfigs() {
        if (this.partitionLostListenerConfigs == null) {
            this.partitionLostListenerConfigs = new ArrayList<MapPartitionLostListenerConfig>();
        }
        return this.partitionLostListenerConfigs;
    }

    public MapConfig setPartitionLostListenerConfigs(List<MapPartitionLostListenerConfig> listenerConfigs) {
        this.partitionLostListenerConfigs = listenerConfigs;
        return this;
    }

    public MapConfig addIndexConfig(IndexConfig indexConfig) {
        this.getIndexConfigs().add(indexConfig);
        return this;
    }

    public List<IndexConfig> getIndexConfigs() {
        if (this.indexConfigs == null) {
            this.indexConfigs = new ArrayList<IndexConfig>();
        }
        return this.indexConfigs;
    }

    public MapConfig setIndexConfigs(List<IndexConfig> indexConfigs) {
        this.indexConfigs = indexConfigs;
        return this;
    }

    public MapConfig addAttributeConfig(AttributeConfig attributeConfig) {
        this.getAttributeConfigs().add(attributeConfig);
        return this;
    }

    public List<AttributeConfig> getAttributeConfigs() {
        if (this.attributeConfigs == null) {
            this.attributeConfigs = new ArrayList<AttributeConfig>();
        }
        return this.attributeConfigs;
    }

    public MapConfig setAttributeConfigs(List<AttributeConfig> attributeConfigs) {
        this.attributeConfigs = attributeConfigs;
        return this;
    }

    public MetadataPolicy getMetadataPolicy() {
        return this.metadataPolicy;
    }

    public MapConfig setMetadataPolicy(MetadataPolicy metadataPolicy) {
        this.metadataPolicy = metadataPolicy;
        return this;
    }

    public MapConfig addQueryCacheConfig(QueryCacheConfig queryCacheConfig) {
        String queryCacheName = queryCacheConfig.getName();
        List<QueryCacheConfig> queryCacheConfigs = this.getQueryCacheConfigs();
        for (QueryCacheConfig cacheConfig : queryCacheConfigs) {
            Preconditions.checkFalse(cacheConfig.getName().equals(queryCacheName), "A query cache already exists with name = [" + queryCacheName + "]");
        }
        queryCacheConfigs.add(queryCacheConfig);
        return this;
    }

    public List<QueryCacheConfig> getQueryCacheConfigs() {
        if (this.queryCacheConfigs == null) {
            this.queryCacheConfigs = new ArrayList<QueryCacheConfig>();
        }
        return this.queryCacheConfigs;
    }

    public MapConfig setQueryCacheConfigs(List<QueryCacheConfig> queryCacheConfigs) {
        this.queryCacheConfigs = queryCacheConfigs;
        return this;
    }

    public PartitioningStrategyConfig getPartitioningStrategyConfig() {
        return this.partitioningStrategyConfig;
    }

    public MapConfig setPartitioningStrategyConfig(PartitioningStrategyConfig partitioningStrategyConfig) {
        this.partitioningStrategyConfig = partitioningStrategyConfig;
        return this;
    }

    public boolean isNearCacheEnabled() {
        return this.nearCacheConfig != null;
    }

    public MapConfig setCacheDeserializedValues(CacheDeserializedValues cacheDeserializedValues) {
        this.cacheDeserializedValues = cacheDeserializedValues;
        return this;
    }

    @Nonnull
    public HotRestartConfig getHotRestartConfig() {
        return this.hotRestartConfig;
    }

    @Nonnull
    public DataPersistenceConfig getDataPersistenceConfig() {
        return this.dataPersistenceConfig;
    }

    @Deprecated
    public MapConfig setHotRestartConfig(@Nonnull HotRestartConfig hotRestartConfig) {
        this.hotRestartConfig = Preconditions.checkNotNull(hotRestartConfig, "HotRestartConfig cannot be null");
        DataPersistenceAndHotRestartMerger.merge(hotRestartConfig, this.dataPersistenceConfig);
        return this;
    }

    public MapConfig setDataPersistenceConfig(@Nonnull DataPersistenceConfig dataPersistenceConfig) {
        this.dataPersistenceConfig = Preconditions.checkNotNull(dataPersistenceConfig, "DataPersistenceConfig cannot be null");
        DataPersistenceAndHotRestartMerger.merge(this.hotRestartConfig, dataPersistenceConfig);
        return this;
    }

    @Nonnull
    public MerkleTreeConfig getMerkleTreeConfig() {
        return this.merkleTreeConfig;
    }

    public MapConfig setMerkleTreeConfig(@Nonnull MerkleTreeConfig merkleTreeConfig) {
        this.merkleTreeConfig = Preconditions.checkNotNull(merkleTreeConfig, "MerkleTreeConfig cannot be null");
        return this;
    }

    @Nonnull
    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfig;
    }

    public MapConfig setEventJournalConfig(@Nonnull EventJournalConfig eventJournalConfig) {
        this.eventJournalConfig = Preconditions.checkNotNull(eventJournalConfig, "eventJournalConfig cannot be null!");
        return this;
    }

    public TieredStoreConfig getTieredStoreConfig() {
        return this.tieredStoreConfig;
    }

    public MapConfig setTieredStoreConfig(TieredStoreConfig tieredStoreConfig) {
        this.tieredStoreConfig = Preconditions.checkNotNull(tieredStoreConfig, "tieredStoreConfig cannot be null");
        return this;
    }

    public CacheDeserializedValues getCacheDeserializedValues() {
        return this.cacheDeserializedValues;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public MapConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public List<PartitioningAttributeConfig> getPartitioningAttributeConfigs() {
        if (this.partitioningAttributeConfigs == null) {
            this.partitioningAttributeConfigs = new ArrayList<PartitioningAttributeConfig>();
        }
        return this.partitioningAttributeConfigs;
    }

    public MapConfig setPartitioningAttributeConfigs(List<PartitioningAttributeConfig> partitioningAttributeConfigs) {
        Preconditions.checkNoNullInside(partitioningAttributeConfigs, "PartitioningAttributeConfig elements can not be null");
        this.partitioningAttributeConfigs = partitioningAttributeConfigs;
        return this;
    }

    @Override
    @Nullable
    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    @Override
    public MapConfig setUserCodeNamespace(@Nullable String userCodeNamespace) {
        this.userCodeNamespace = userCodeNamespace;
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapConfig)) {
            return false;
        }
        MapConfig that = (MapConfig)o;
        if (this.backupCount != that.backupCount) {
            return false;
        }
        if (this.asyncBackupCount != that.asyncBackupCount) {
            return false;
        }
        if (this.timeToLiveSeconds != that.timeToLiveSeconds) {
            return false;
        }
        if (this.maxIdleSeconds != that.maxIdleSeconds) {
            return false;
        }
        if (this.readBackupData != that.readBackupData) {
            return false;
        }
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        if (this.perEntryStatsEnabled != that.perEntryStatsEnabled) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Objects.equals(this.evictionConfig, that.evictionConfig)) {
            return false;
        }
        if (!Objects.equals(this.mapStoreConfig, that.mapStoreConfig)) {
            return false;
        }
        if (!Objects.equals(this.nearCacheConfig, that.nearCacheConfig)) {
            return false;
        }
        if (this.cacheDeserializedValues != that.cacheDeserializedValues) {
            return false;
        }
        if (!Objects.equals(this.mergePolicyConfig, that.mergePolicyConfig)) {
            return false;
        }
        if (this.inMemoryFormat != that.inMemoryFormat) {
            return false;
        }
        if (this.metadataPolicy != that.metadataPolicy) {
            return false;
        }
        if (!Objects.equals(this.wanReplicationRef, that.wanReplicationRef)) {
            return false;
        }
        if (!this.getEntryListenerConfigs().equals(that.getEntryListenerConfigs())) {
            return false;
        }
        if (!this.getPartitionLostListenerConfigs().equals(that.getPartitionLostListenerConfigs())) {
            return false;
        }
        if (!Set.copyOf(this.getIndexConfigs()).equals(Set.copyOf(that.getIndexConfigs()))) {
            return false;
        }
        if (!this.getAttributeConfigs().equals(that.getAttributeConfigs())) {
            return false;
        }
        if (!this.getQueryCacheConfigs().equals(that.getQueryCacheConfigs())) {
            return false;
        }
        if (!Objects.equals(this.partitioningStrategyConfig, that.partitioningStrategyConfig)) {
            return false;
        }
        if (!Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName)) {
            return false;
        }
        if (!this.merkleTreeConfig.equals(that.merkleTreeConfig)) {
            return false;
        }
        if (!this.eventJournalConfig.equals(that.eventJournalConfig)) {
            return false;
        }
        if (!this.dataPersistenceConfig.equals(that.dataPersistenceConfig)) {
            return false;
        }
        if (!this.tieredStoreConfig.equals(that.tieredStoreConfig)) {
            return false;
        }
        if (!this.getPartitioningAttributeConfigs().equals(that.getPartitioningAttributeConfigs())) {
            return false;
        }
        if (!Objects.equals(this.userCodeNamespace, that.userCodeNamespace)) {
            return false;
        }
        return this.hotRestartConfig.equals(that.hotRestartConfig);
    }

    public final int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.backupCount;
        result = 31 * result + this.asyncBackupCount;
        result = 31 * result + this.timeToLiveSeconds;
        result = 31 * result + this.maxIdleSeconds;
        result = 31 * result + this.evictionConfig.hashCode();
        result = 31 * result + (this.mapStoreConfig != null ? this.mapStoreConfig.hashCode() : 0);
        result = 31 * result + (this.nearCacheConfig != null ? this.nearCacheConfig.hashCode() : 0);
        result = 31 * result + (this.readBackupData ? 1 : 0);
        result = 31 * result + this.cacheDeserializedValues.hashCode();
        result = 31 * result + (this.mergePolicyConfig != null ? this.mergePolicyConfig.hashCode() : 0);
        result = 31 * result + this.inMemoryFormat.hashCode();
        result = 31 * result + this.metadataPolicy.hashCode();
        result = 31 * result + (this.wanReplicationRef != null ? this.wanReplicationRef.hashCode() : 0);
        result = 31 * result + this.getEntryListenerConfigs().hashCode();
        result = 31 * result + Set.copyOf(this.getIndexConfigs()).hashCode();
        result = 31 * result + this.getAttributeConfigs().hashCode();
        result = 31 * result + this.getQueryCacheConfigs().hashCode();
        result = 31 * result + this.getPartitionLostListenerConfigs().hashCode();
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        result = 31 * result + (this.perEntryStatsEnabled ? 1 : 0);
        result = 31 * result + (this.partitioningStrategyConfig != null ? this.partitioningStrategyConfig.hashCode() : 0);
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + this.merkleTreeConfig.hashCode();
        result = 31 * result + this.eventJournalConfig.hashCode();
        result = 31 * result + this.hotRestartConfig.hashCode();
        result = 31 * result + this.dataPersistenceConfig.hashCode();
        result = 31 * result + this.tieredStoreConfig.hashCode();
        result = 31 * result + this.getPartitioningAttributeConfigs().hashCode();
        result = 31 * result + (this.userCodeNamespace != null ? this.userCodeNamespace.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MapConfig{name='" + this.name + "', inMemoryFormat='" + String.valueOf((Object)this.inMemoryFormat) + "', metadataPolicy=" + String.valueOf((Object)this.metadataPolicy) + ", backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", maxIdleSeconds=" + this.maxIdleSeconds + ", readBackupData=" + this.readBackupData + ", evictionConfig=" + String.valueOf(this.evictionConfig) + ", merkleTree=" + String.valueOf(this.merkleTreeConfig) + ", eventJournal=" + String.valueOf(this.eventJournalConfig) + ", hotRestart=" + String.valueOf(this.hotRestartConfig) + ", dataPersistenceConfig=" + String.valueOf(this.dataPersistenceConfig) + ", nearCacheConfig=" + String.valueOf(this.nearCacheConfig) + ", mapStoreConfig=" + String.valueOf(this.mapStoreConfig) + ", mergePolicyConfig=" + String.valueOf(this.mergePolicyConfig) + ", wanReplicationRef=" + String.valueOf(this.wanReplicationRef) + ", entryListenerConfigs=" + String.valueOf(this.entryListenerConfigs) + ", indexConfigs=" + String.valueOf(this.indexConfigs) + ", attributeConfigs=" + String.valueOf(this.attributeConfigs) + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", queryCacheConfigs=" + String.valueOf(this.queryCacheConfigs) + ", cacheDeserializedValues=" + String.valueOf((Object)this.cacheDeserializedValues) + ", statisticsEnabled=" + this.statisticsEnabled + ", entryStatsEnabled=" + this.perEntryStatsEnabled + ", tieredStoreConfig=" + String.valueOf(this.tieredStoreConfig) + ", partitioningAttributeConfigs=" + String.valueOf(this.partitioningAttributeConfigs) + ", userCodeNamespace=" + this.userCodeNamespace + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxIdleSeconds);
        out.writeObject(this.evictionConfig);
        out.writeObject(this.mapStoreConfig);
        out.writeObject(this.nearCacheConfig);
        out.writeBoolean(this.readBackupData);
        out.writeString(this.cacheDeserializedValues.name());
        out.writeObject(this.mergePolicyConfig);
        out.writeString(this.inMemoryFormat.name());
        out.writeObject(this.wanReplicationRef);
        SerializationUtil.writeNullableList(this.entryListenerConfigs, out);
        SerializationUtil.writeNullableList(this.partitionLostListenerConfigs, out);
        SerializationUtil.writeNullableList(this.indexConfigs, out);
        SerializationUtil.writeNullableList(this.attributeConfigs, out);
        SerializationUtil.writeNullableList(this.queryCacheConfigs, out);
        out.writeBoolean(this.statisticsEnabled);
        out.writeObject(this.partitioningStrategyConfig);
        out.writeString(this.splitBrainProtectionName);
        out.writeObject(this.hotRestartConfig);
        out.writeObject(this.merkleTreeConfig);
        out.writeObject(this.eventJournalConfig);
        out.writeShort(this.metadataPolicy.getId());
        out.writeBoolean(this.perEntryStatsEnabled);
        out.writeObject(this.dataPersistenceConfig);
        out.writeObject(this.tieredStoreConfig);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            SerializationUtil.writeNullableList(this.partitioningAttributeConfigs, out);
        }
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeString(this.userCodeNamespace);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        this.timeToLiveSeconds = in.readInt();
        this.maxIdleSeconds = in.readInt();
        this.evictionConfig = (EvictionConfig)in.readObject();
        this.mapStoreConfig = (MapStoreConfig)in.readObject();
        this.nearCacheConfig = (NearCacheConfig)in.readObject();
        this.readBackupData = in.readBoolean();
        this.cacheDeserializedValues = CacheDeserializedValues.valueOf(in.readString());
        this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
        this.inMemoryFormat = InMemoryFormat.valueOf(in.readString());
        this.wanReplicationRef = (WanReplicationRef)in.readObject();
        this.entryListenerConfigs = SerializationUtil.readNullableList(in);
        this.partitionLostListenerConfigs = SerializationUtil.readNullableList(in);
        this.indexConfigs = SerializationUtil.readNullableList(in);
        this.attributeConfigs = SerializationUtil.readNullableList(in);
        this.queryCacheConfigs = SerializationUtil.readNullableList(in);
        this.statisticsEnabled = in.readBoolean();
        this.partitioningStrategyConfig = (PartitioningStrategyConfig)in.readObject();
        this.splitBrainProtectionName = in.readString();
        this.setHotRestartConfig((HotRestartConfig)in.readObject());
        this.merkleTreeConfig = (MerkleTreeConfig)in.readObject();
        this.eventJournalConfig = (EventJournalConfig)in.readObject();
        this.metadataPolicy = MetadataPolicy.getById(in.readShort());
        this.perEntryStatsEnabled = in.readBoolean();
        this.setDataPersistenceConfig((DataPersistenceConfig)in.readObject());
        this.setTieredStoreConfig((TieredStoreConfig)in.readObject());
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.partitioningAttributeConfigs = SerializationUtil.readNullableList(in);
        }
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            this.userCodeNamespace = in.readString();
        }
    }
}

