/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl.listener;

import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddClusterViewListenerCodec;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class ClientClusterViewListenerService
implements ConnectionListener {
    private final HazelcastClientInstanceImpl client;
    private final ClientConnectionManager connectionManager;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientClusterService clusterService;
    private final ILogger logger;
    private final AtomicReference<Connection> listenerAddedConnection = new AtomicReference();

    public ClientClusterViewListenerService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientListenerService.class);
        this.connectionManager = client.getConnectionManager();
        this.partitionService = (ClientPartitionServiceImpl)client.getClientPartitionService();
        this.clusterService = client.getClientClusterService();
    }

    public void start() {
        this.connectionManager.addConnectionListener(this);
    }

    public void connectionAdded(Connection connection) {
        this.tryRegister((ClientConnection)connection);
    }

    public void connectionRemoved(Connection connection) {
        this.tryReregisterToRandomConnection(connection);
    }

    private void tryReregisterToRandomConnection(Connection oldConnection) {
        if (!this.listenerAddedConnection.compareAndSet(oldConnection, null)) {
            return;
        }
        ClientConnection newConnection = this.connectionManager.getRandomConnection();
        if (newConnection != null) {
            this.tryRegister(newConnection);
        }
    }

    private void tryRegister(ClientConnection connection) {
        if (!this.listenerAddedConnection.compareAndSet(null, connection)) {
            return;
        }
        ClientMessage clientMessage = ClientAddClusterViewListenerCodec.encodeRequest();
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)this.client, clientMessage, null, connection);
        ClusterViewListenerHandler handler = new ClusterViewListenerHandler(connection);
        invocation.setEventHandler(handler);
        handler.beforeListenerRegister(connection);
        invocation.invokeUrgent().whenCompleteAsync((message, throwable) -> {
            if (message != null) {
                handler.onListenerRegister(connection);
                return;
            }
            this.tryReregisterToRandomConnection(connection);
        }, ConcurrencyUtil.getDefaultAsyncExecutor());
    }

    public final class ClusterViewListenerHandler
    extends ClientAddClusterViewListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ClientConnection connection;

        private ClusterViewListenerHandler(ClientConnection connection) {
            this.connection = connection;
        }

        @Override
        public void beforeListenerRegister(Connection connection) {
            ClientClusterViewListenerService.this.clusterService.onClusterConnect();
            if (ClientClusterViewListenerService.this.logger.isFinestEnabled()) {
                ClientClusterViewListenerService.this.logger.finest("Register attempt of ClusterViewListenerHandler to " + String.valueOf(connection));
            }
        }

        @Override
        public void onListenerRegister(Connection connection) {
            if (ClientClusterViewListenerService.this.logger.isFinestEnabled()) {
                ClientClusterViewListenerService.this.logger.finest("Registered ClusterViewListenerHandler to " + String.valueOf(connection));
            }
        }

        @Override
        public void handleMembersViewEvent(int memberListVersion, Collection<MemberInfo> memberInfos) {
            ClientClusterViewListenerService.this.clusterService.handleMembersViewEvent(memberListVersion, memberInfos, this.connection.getClusterUuid());
        }

        @Override
        public void handlePartitionsViewEvent(int version, Collection<Map.Entry<UUID, List<Integer>>> partitions) {
            ClientClusterViewListenerService.this.partitionService.handlePartitionsViewEvent(this.connection, partitions, version);
        }

        @Override
        public void handleMemberGroupsViewEvent(int version, Collection<Collection<UUID>> memberGroups) {
            ClientClusterViewListenerService.this.clusterService.getSubsetMembers().updateOnClusterViewEvent(this.connection.getClusterUuid(), memberGroups, version);
        }

        @Override
        public void handleClusterVersionEvent(Version version) {
            ClientClusterViewListenerService.this.clusterService.handleClusterVersionEvent(version);
        }
    }
}

