/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientTriggerPartitionAssignmentCodec;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.Partition;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final AtomicReference<PartitionTable> partitionTable = new AtomicReference<PartitionTable>(new PartitionTable(null, -1, new Int2ObjectHashMap<UUID>()));
    private final AtomicInteger partitionCount = new AtomicInteger(0);

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientPartitionService.class);
    }

    @Override
    public void handlePartitionsViewEvent(Connection connection, Collection<Map.Entry<UUID, List<Integer>>> partitions, int partitionStateVersion) {
        Int2ObjectHashMap<UUID> newPartitions;
        PartitionTable newMetaData;
        PartitionTable current;
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Handling new partition table with  partitionStateVersion: " + partitionStateVersion);
        }
        do {
            if (this.shouldBeApplied(connection, partitions, partitionStateVersion, current = this.partitionTable.get())) continue;
            return;
        } while (!this.partitionTable.compareAndSet(current, newMetaData = new PartitionTable(connection, partitionStateVersion, newPartitions = this.convertToMap(partitions))));
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Applied partition table with partitionStateVersion : " + partitionStateVersion);
        }
    }

    private boolean shouldBeApplied(Connection connection, Collection<Map.Entry<UUID, List<Integer>>> partitions, int partitionStateVersion, PartitionTable current) {
        if (partitions.isEmpty()) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, current, "response is empty");
            }
            return false;
        }
        if (!connection.equals(current.connection)) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Event coming from a new connection. Old connection: " + String.valueOf(current.connection) + ", new connection " + String.valueOf(connection));
            }
            return true;
        }
        if (partitionStateVersion <= current.partitionSateVersion) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, current, "response partition state version is old");
            }
            return false;
        }
        return true;
    }

    private void logFailure(Connection connection, int partitionStateVersion, PartitionTable current, String cause) {
        this.logger.finest(" We will not apply the response, since " + cause + " . Response is from " + String.valueOf(connection) + ". Current connection " + String.valueOf(current.connection) + " response state version:" + partitionStateVersion + ". Current state version: " + current.partitionSateVersion);
    }

    private Int2ObjectHashMap<UUID> convertToMap(Collection<Map.Entry<UUID, List<Integer>>> partitions) {
        Int2ObjectHashMap<UUID> newPartitions = new Int2ObjectHashMap<UUID>();
        for (Map.Entry<UUID, List<Integer>> entry : partitions) {
            UUID uuid = entry.getKey();
            for (Integer partition : entry.getValue()) {
                newPartitions.put(partition, uuid);
            }
        }
        return newPartitions;
    }

    public void reset() {
        this.partitionTable.set(new PartitionTable(null, -1, new Int2ObjectHashMap<UUID>()));
    }

    @Override
    public UUID getPartitionOwner(int partitionId) {
        return this.getPartitions().get(partitionId);
    }

    private Int2ObjectHashMap<UUID> getPartitions() {
        return this.partitionTable.get().partitions;
    }

    @Override
    public int getPartitionId(@Nonnull Data key) {
        int pc = this.getPartitionCount();
        if (pc == 0) {
            throw new HazelcastClientOfflineException();
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex(hash, pc);
    }

    @Override
    public int getPartitionId(@Nonnull Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount.get();
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    public boolean checkAndSetPartitionCount(int newPartitionCount) {
        if (this.partitionCount.compareAndSet(0, newPartitionCount)) {
            return true;
        }
        return this.partitionCount.get() == newPartitionCount;
    }

    private static class PartitionTable {
        final Connection connection;
        final int partitionSateVersion;
        final Int2ObjectHashMap<UUID> partitions;

        PartitionTable(Connection connection, int partitionSateVersion, Int2ObjectHashMap<UUID> partitions) {
            this.connection = connection;
            this.partitionSateVersion = partitionSateVersion;
            this.partitions = partitions;
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            UUID owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner == null) {
                ClientMessage message = ClientTriggerPartitionAssignmentCodec.encodeRequest();
                ClientInvocation invocation = new ClientInvocation(ClientPartitionServiceImpl.this.client, message, null);
                invocation.invoke();
                return null;
            }
            return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + "}";
        }
    }
}

