/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class ExperimentalPipelineSubmitCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16580864;
    public static final int RESPONSE_MESSAGE_TYPE = 16580865;
    private static final int REQUEST_RESOURCE_BUNDLE_CHECKSUM_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_JOB_ID_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 21;

    private ExperimentalPipelineSubmitCodec() {
    }

    public static ClientMessage encodeRequest(@Nullable String jobName, String pipelineDefinition, @Nullable byte[] resourceBundle, int resourceBundleChecksum) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Experimental.PipelineSubmit");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16580864);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, resourceBundleChecksum);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, jobName, StringCodec::encode);
        StringCodec.encode(clientMessage, pipelineDefinition);
        CodecUtil.encodeNullable(clientMessage, resourceBundle, ByteArrayCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.resourceBundleChecksum = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.jobName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.pipelineDefinition = StringCodec.decode(iterator);
        request.resourceBundle = CodecUtil.decodeNullable(iterator, ByteArrayCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(long jobId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16580865);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 13, jobId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static long decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeLong(initialFrame.content, 13);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        @Nullable
        public String jobName;
        public String pipelineDefinition;
        @Nullable
        public byte[] resourceBundle;
        public int resourceBundleChecksum;
    }
}

