/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.ClusterRoutingConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.SubsetMembers;
import com.hazelcast.client.impl.clientside.SubsetMembersView;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.tcp.AuthenticationKeyValuePairConstants;
import com.hazelcast.client.impl.connection.tcp.KeyValuePairGenerator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubsetMembersImpl
implements SubsetMembers {
    private final ConcurrentMap<UUID, SubsetMembersView> subsetMembersViewByClusterUuid = new ConcurrentHashMap<UUID, SubsetMembersView>();
    private final HazelcastClientInstanceImpl client;
    private final ClusterRoutingConfig clusterRoutingConfig;
    private final ILogger logger;
    private volatile UUID clusterId;
    private volatile ScheduledFuture<?> closeConnectionsTask;

    public SubsetMembersImpl(HazelcastClientInstanceImpl client, ClusterRoutingConfig clusterRoutingConfig, LoggingService loggingService) {
        this.client = client;
        this.clusterRoutingConfig = clusterRoutingConfig;
        this.logger = loggingService.getLogger(SubsetMembersImpl.class);
    }

    @Override
    public void updateOnAuth(UUID clusterUuid, UUID authMemberUuid, Map<String, String> keyValuePairs) {
        if (!AuthenticationKeyValuePairConstants.checkRequiredFieldsForMultiMemberRoutingExist(this.clusterRoutingConfig, keyValuePairs)) {
            this.logAsFinest("MULTI_MEMBER routing is not in use", new Object[0]);
            return;
        }
        AuthenticationKeyValuePairConstants.checkMinimumClusterVersionForMultiMemberRouting(keyValuePairs);
        String memberGroupsJson = keyValuePairs.get("memberGroups");
        KeyValuePairGenerator.MemberGroupsAndVersionHolder memberGroupsAndVersionHolder = KeyValuePairGenerator.parseJsonForMemberGroups(memberGroupsJson);
        Collection<Collection<UUID>> memberGroups = memberGroupsAndVersionHolder.allMemberGroups();
        int version = memberGroupsAndVersionHolder.version();
        SubsetMembersView current = this.updateInternal(memberGroups, version, clusterUuid, authMemberUuid);
        this.logAsFinest("On authentication [clusterUuid=%s, version=%d, memberGroupsSize=%d, memberGroups=%s, authMemberUuid=%s, current=%s]", clusterUuid, version, memberGroups.size(), memberGroups, authMemberUuid, current);
    }

    @Override
    public void updateOnClusterViewEvent(UUID clusterUuid, Collection<Collection<UUID>> memberGroups, int version) {
        SubsetMembersView previous = (SubsetMembersView)this.subsetMembersViewByClusterUuid.get(this.clusterId);
        SubsetMembersView current = this.updateInternal(memberGroups, version, clusterUuid, null);
        if (previous != null && (current == null || previous.members().size() > current.members().size())) {
            this.closeConnectionsToNonSubsetMembers();
        }
        this.logAsFinest("On cluster event [clusterUuid=%s, version=%d, memberGroupsSize=%d, memberGroups=%s current=%s]", clusterUuid, version, memberGroups.size(), memberGroups, current);
    }

    private void closeConnectionsToNonSubsetMembers() {
        SubsetMembersView subsetMembersView = this.getSubsetMembersView();
        if (subsetMembersView == null) {
            return;
        }
        Set<UUID> subsetMembers = subsetMembersView.members();
        boolean anyInUse = false;
        for (ClientConnection connection : this.client.getConnectionManager().getActiveConnections()) {
            if (subsetMembers.contains(connection.getRemoteUuid())) continue;
            if (this.client.getInvocationService().isConnectionInUse(connection)) {
                anyInUse = true;
                continue;
            }
            connection.close("Connection is closed because it is no longer relevant for the current MULTI_MEMBER configuration", null);
        }
        if (anyInUse) {
            if (this.closeConnectionsTask != null && !this.closeConnectionsTask.isDone()) {
                this.closeConnectionsTask.cancel(false);
            }
            long tryAgainDelayMs = 1000L;
            this.closeConnectionsTask = this.client.getTaskScheduler().schedule(this::closeConnectionsToNonSubsetMembers, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onConnectionRemoved(ClientConnection clientConnection) {
        UUID clusterUuid = clientConnection.getClusterUuid();
        UUID remoteUuid = clientConnection.getRemoteUuid();
        if (remoteUuid == null) {
            return;
        }
        SubsetMembersView subsetMembersView = this.subsetMembersViewByClusterUuid.computeIfPresent(clusterUuid, (uuid, current) -> {
            Set<UUID> members = current.members();
            members.remove(remoteUuid);
            return members.isEmpty() ? null : current;
        });
        this.logAsFinest("onConnectionRemoved [clusterUuid=%s, removedConnectionsMemberUuid=%s, current=%s]", clusterUuid, remoteUuid, subsetMembersView);
    }

    @Override
    public void onClusterConnect(UUID oldClusterId, UUID newClusterId) {
        if (oldClusterId != null && !oldClusterId.equals(newClusterId)) {
            this.subsetMembersViewByClusterUuid.remove(oldClusterId);
        }
        this.clusterId = newClusterId;
        this.logAsFinest("onClusterConnect to clusterUuid=%s", this.clusterId);
    }

    @Override
    @Nullable
    public SubsetMembersView getSubsetMembersView() {
        UUID clusterId = this.clusterId;
        if (clusterId == null) {
            return null;
        }
        return (SubsetMembersView)this.subsetMembersViewByClusterUuid.get(clusterId);
    }

    @Nullable
    private SubsetMembersView updateInternal(Collection<Collection<UUID>> memberGroups, int version, @Nonnull UUID clusterUuid, @Nullable UUID memberUuid) {
        if (!SubsetMembersImpl.hasDataMember(memberGroups)) {
            this.logAsFinest("All members are lite [clusterUuid=%s, memberGroupsSize=%d, memberGroups=%s]", clusterUuid, memberGroups.size(), memberGroups);
        }
        assert (version > 0);
        return this.subsetMembersViewByClusterUuid.compute(clusterUuid, (uuid, current) -> SubsetMembersImpl.pickSubset(memberGroups, version, clusterUuid, memberUuid, current));
    }

    private static SubsetMembersView pickSubset(Collection<Collection<UUID>> memberGroups, int version, UUID clusterUuid, @Nullable UUID memberUuid, @Nullable SubsetMembersView current) {
        if (current == null || current.members().isEmpty() || !current.clusterUuid().equals(clusterUuid)) {
            current = null;
        }
        if (memberUuid != null && current == null) {
            for (Collection<UUID> memberGroup : memberGroups) {
                if (!memberGroup.contains(memberUuid)) continue;
                return new SubsetMembersView(clusterUuid, new HashSet<UUID>(memberGroup), version);
            }
        }
        Collection<UUID> pickedMemberGroup = null;
        if (current != null) {
            if (current.version() <= version) {
                int pickedGroupsSharedMemberCountWithExistingSubset = 0;
                for (Collection<UUID> examinedMemberGroup : memberGroups) {
                    int sharedMemberCountWithExistingSubset = 0;
                    for (UUID member : current.members()) {
                        if (!examinedMemberGroup.contains(member)) continue;
                        ++sharedMemberCountWithExistingSubset;
                    }
                    if (pickedGroupsSharedMemberCountWithExistingSubset >= sharedMemberCountWithExistingSubset) continue;
                    pickedGroupsSharedMemberCountWithExistingSubset = sharedMemberCountWithExistingSubset;
                    pickedMemberGroup = examinedMemberGroup;
                }
                if (pickedMemberGroup != null) {
                    return new SubsetMembersView(clusterUuid, new HashSet<UUID>(pickedMemberGroup), version);
                }
            } else {
                return current;
            }
        }
        for (Collection<UUID> examinedMemberGroup : memberGroups) {
            if (pickedMemberGroup == null) {
                pickedMemberGroup = examinedMemberGroup;
                continue;
            }
            if (pickedMemberGroup.size() >= examinedMemberGroup.size()) continue;
            pickedMemberGroup = examinedMemberGroup;
        }
        if (pickedMemberGroup != null) {
            return new SubsetMembersView(clusterUuid, new HashSet<UUID>(pickedMemberGroup), version);
        }
        return null;
    }

    private static boolean hasDataMember(Collection<Collection<UUID>> memberGroups) {
        for (Collection<UUID> memberGroup : memberGroups) {
            if (memberGroup.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void logAsFinest(String s, Object ... params) {
        if (!this.logger.isFinestEnabled()) {
            return;
        }
        this.logger.finest(String.format(s, params));
    }

    public String toString() {
        return "ClientMemberGroupsView{subsetMembersViewByClusterUuid=" + String.valueOf(this.subsetMembersViewByClusterUuid) + ", clusterId=" + String.valueOf(this.clusterId) + "}";
    }
}

