/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.countdownlatch;

import com.hazelcast.client.cp.internal.datastructures.CPClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchCountDownCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchGetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchGetRoundCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchTrySetCountCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class CountDownLatchProxy
extends CPClientProxy
implements ICountDownLatch {
    public CountDownLatchProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:countDownLatchService", proxyName, context, groupId, objectName);
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        Preconditions.checkNotNull(unit);
        long timeoutMillis = Math.max(0L, unit.toMillis(timeout));
        ClientMessage request = CountDownLatchAwaitCodec.encodeRequest(this.groupId, this.objectName, UuidUtil.newUnsecureUUID(), timeoutMillis);
        ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.name).joinInternal();
        return CountDownLatchAwaitCodec.decodeResponse(response);
    }

    @Override
    public void countDown() {
        int round = this.getRound();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            try {
                this.countDown(round, invocationUid);
                return;
            }
            catch (OperationTimeoutException e) {
                EmptyStatement.ignore(e);
                continue;
            }
            break;
        }
    }

    private int getRound() {
        ClientMessage request = CountDownLatchGetRoundCodec.encodeRequest(this.groupId, this.objectName);
        ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.name).joinInternal();
        return CountDownLatchGetRoundCodec.decodeResponse(response);
    }

    private void countDown(int round, UUID invocationUid) {
        ClientMessage request = CountDownLatchCountDownCodec.encodeRequest(this.groupId, this.objectName, invocationUid, round);
        this.invokeClientRequest(request, this.name).joinInternal();
    }

    @Override
    public int getCount() {
        ClientMessage request = CountDownLatchGetCountCodec.encodeRequest(this.groupId, this.objectName);
        ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.name).joinInternal();
        return CountDownLatchGetCountCodec.decodeResponse(response);
    }

    @Override
    public boolean trySetCount(int count) {
        Preconditions.checkPositive(count, "Count must be positive!");
        ClientMessage request = CountDownLatchTrySetCountCodec.encodeRequest(this.groupId, this.objectName, count);
        ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.name).joinInternal();
        return CountDownLatchTrySetCountCodec.decodeResponse(response);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        this.invokeClientRequest(request, this.name).joinInternal();
    }
}

