/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.wan;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class WanEnterpriseCacheEvent<T>
implements InternalWanEvent<T> {
    private String cacheName;
    private String managerPrefix;
    private Set<String> clusterNames = new HashSet<String>();
    private int backupCount;
    private long creationTime;

    public WanEnterpriseCacheEvent(@Nonnull String cacheName, @Nonnull String managerPrefix, int backupCount) {
        this.cacheName = cacheName;
        this.managerPrefix = managerPrefix;
        this.backupCount = backupCount;
        this.creationTime = Clock.currentTimeMillis();
    }

    public WanEnterpriseCacheEvent() {
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getNameWithPrefix() {
        return this.managerPrefix + this.cacheName;
    }

    @Override
    public int getBackupCount() {
        return this.backupCount;
    }

    @Override
    @Nonnull
    public Set<String> getClusterNames() {
        return this.clusterNames;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.cacheName);
        out.writeString(this.managerPrefix);
        out.writeInt(this.backupCount);
        out.writeInt(this.clusterNames.size());
        for (String clusterName : this.clusterNames) {
            out.writeString(clusterName);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.cacheName = in.readString();
        this.managerPrefix = in.readString();
        this.backupCount = in.readInt();
        int clusterNameCount = in.readInt();
        for (int i = 0; i < clusterNameCount; ++i) {
            this.clusterNames.add(in.readString());
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    @Nonnull
    public String getObjectName() {
        return this.cacheName;
    }

    @Override
    @Nonnull
    public String getServiceName() {
        return "hz:impl:cacheService";
    }
}

