/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.jet;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.usercode.UserCodeConfig;
import com.hazelcast.usercode.impl.RuntimeInitArgs;
import com.hazelcast.usercode.impl.UserCodeException;
import com.hazelcast.usercode.impl.UserCodeRuntime;
import com.hazelcast.usercode.impl.UserCodeService;
import com.hazelcast.usercode.impl.UserCodeServiceFactory;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

@Beta
public final class UserCodeTransforms {
    public static final String DEFAULT_RESOURCE_FILE_NAME = "__resourceBundle.zip";

    private UserCodeTransforms() {
    }

    @Nonnull
    public static <T, R> FunctionEx<StreamStage<? extends T>, StreamStage<R>> mapUsingUserCode(UserCodeConfig config) {
        UserCodeConfig c = config.clone();
        ServiceFactory<?, UserCodeRuntime> serviceFactory = UserCodeTransforms.getUserCodeRuntimeServiceFactory(c);
        return (FunctionEx & Serializable)s2 -> {
            StreamStage stage = s2.mapUsingServiceAsync(serviceFactory, UserCodeRuntime::applyTransform);
            UserCodeTransforms.setStageName(c, stage);
            return stage;
        };
    }

    @Nonnull
    public static <T, R> FunctionEx<StreamStage<? extends T>, StreamStage<R>> mapUsingUserCode(UserCodeConfig config, boolean preserveOrder, int maxConcurrentOps) {
        UserCodeConfig c = config.clone();
        ServiceFactory<?, UserCodeRuntime> serviceFactory = UserCodeTransforms.getUserCodeRuntimeServiceFactory(c);
        return (FunctionEx & Serializable)s2 -> {
            StreamStage stage = s2.mapUsingServiceAsync(serviceFactory, maxConcurrentOps, preserveOrder, UserCodeRuntime::applyTransform);
            UserCodeTransforms.setStageName(c, stage);
            return stage;
        };
    }

    private static ServiceFactory<?, UserCodeRuntime> getUserCodeRuntimeServiceFactory(UserCodeConfig config) {
        return ServiceFactories.sharedService((FunctionEx & Serializable)x -> UserCodeTransforms.startUserCodeRuntime(x, config), UserCodeTransforms::destroyUserCodeRuntime);
    }

    private static void setStageName(UserCodeConfig config, StreamStage<?> stage) {
        if (config.getName() != null && !config.getName().isEmpty()) {
            stage.setName(config.getName());
        }
    }

    private static UserCodeRuntime startUserCodeRuntime(ProcessorSupplier.Context processorContext, UserCodeConfig config) {
        HazelcastInstance hazelcastInstance = processorContext.hazelcastInstance();
        LoggingService logging = hazelcastInstance.getLoggingService();
        logging.getLogger(UserCodeTransforms.class).fine("Start user code container runtime.[" + config.getName() + "]");
        UserCodeService userCodeService = UserCodeServiceFactory.getOrCreateContainerService(hazelcastInstance);
        long jobId = processorContext.jobId();
        config.setName(config.getName() + "-" + jobId);
        File attachedFile = null;
        if (processorContext.jobConfig().getResourceConfigs().get(DEFAULT_RESOURCE_FILE_NAME) != null) {
            attachedFile = processorContext.attachedFile(DEFAULT_RESOURCE_FILE_NAME);
        }
        Address memberAddress = hazelcastInstance.getCluster().getLocalMember().getAddress();
        String host = memberAddress.getHost();
        int port = memberAddress.getPort();
        RuntimeInitArgs initArgs = new RuntimeInitArgs(host, port, attachedFile, config.getModuleName(), String.valueOf(jobId));
        try {
            return userCodeService.startRuntime(config, initArgs).get();
        }
        catch (UserCodeException | InterruptedException | ExecutionException ex) {
            throw new UserCodeException("Failed to start runtime.", (Throwable)ex);
        }
    }

    private static void destroyUserCodeRuntime(UserCodeRuntime runtime) {
        try {
            runtime.getUserCodeService().destroyRuntime(runtime).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new UserCodeException("Failed to destroy runtime.", ex);
        }
    }
}

