/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl.transports.grpc;

import com.hazelcast.logging.ILogger;
import io.grpc.ManagedChannel;
import java.util.concurrent.TimeUnit;

public final class GrpcUtil {
    private GrpcUtil() {
    }

    public static void shutdownChannel(ManagedChannel channel, ILogger logger, long timeout) throws InterruptedException {
        if (!channel.shutdown().awaitTermination(timeout, TimeUnit.SECONDS)) {
            logger.info("gRPC client has not shut down within " + timeout + " seconds, you can override the timeout by setting the `jet.grpc.shutdown.timeout.seconds` system property");
            if (!channel.shutdownNow().awaitTermination(1L, TimeUnit.SECONDS)) {
                logger.info("gRPC client has not shut down on time, even after forceful shutdown");
            }
        }
    }
}

