/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.util;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.pc.config.JetConfig;
import com.hazelcast.pc.exceptions.PackageProcessorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;

public class PackageProcessor {
    private static final String CONFIG_FILENAME = "jet_config.yaml";
    private static final int FILE_READER_BUFFER_SIZE = 10240;
    private final Path resourcePath;
    private Path baseDir;
    private JetConfig config;

    private PackageProcessor(Path baseDir, Path resourceDir) {
        this.baseDir = baseDir;
        this.resourcePath = resourceDir;
    }

    public static PackageProcessor withPath(@Nonnull Path path) {
        return PackageProcessor.withPath(path, null);
    }

    public static PackageProcessor withPath(@Nonnull Path path, Path extractDir) {
        Objects.requireNonNull(path);
        if (path.toString().endsWith(".zip")) {
            return PackageProcessor.withArchivePath(path, extractDir);
        }
        if (path.toFile().isDirectory()) {
            return PackageProcessor.withBaseDir(path);
        }
        throw new IllegalArgumentException("Path must be a zip file or a directory");
    }

    static PackageProcessor withBaseDir(Path baseDir) {
        PackageProcessor processor = new PackageProcessor(baseDir, null);
        try {
            processor.loadConfig();
        }
        catch (FileNotFoundException e) {
            throw new PackageProcessorException(e);
        }
        return processor;
    }

    static PackageProcessor withArchivePath(Path archivePath, Path extractDir) {
        if (extractDir == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            if (tempDir == null) {
                throw new PackageProcessorException("Temporary directory was not resolved");
            }
            extractDir = Path.of(tempDir, new String[0]);
        }
        PackageProcessor processor = new PackageProcessor(null, archivePath);
        try {
            processor.extract(extractDir);
        }
        catch (IOException e) {
            throw new PackageProcessorException("Failed extracting the archive", e);
        }
        return processor;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public JetConfig getConfig() {
        return this.config;
    }

    private void extract(Path targetPath) throws IOException {
        this.baseDir = this.extractPythonPackage(targetPath);
        this.loadConfig();
    }

    private Path extractPythonPackage(Path targetPath) throws IOException {
        String uuid = UuidUtil.newSecureUuidString();
        Path baseDir = targetPath.resolve("clc-" + uuid);
        if (!baseDir.toFile().mkdirs()) {
            throw new PackageProcessorException("Failed creating directory " + String.valueOf(baseDir));
        }
        byte[] buf = new byte[10240];
        try (InputStream is = this.getResource();){
            if (is == null) {
                throw new PackageProcessorException("Jet package to be run was not found");
            }
            try (ZipInputStream zis = new ZipInputStream(is);){
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    String fileName = entry.getName();
                    Path path = baseDir.resolve(fileName);
                    Path parent = path.getParent();
                    if (parent.toFile().mkdirs()) {
                        throw new PackageProcessorException("Failed creating directory " + String.valueOf(parent));
                    }
                    try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                        int len;
                        while ((len = zis.read(buf)) > 0) {
                            fos.write(buf, 0, len);
                        }
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.closeEntry();
            }
        }
        return baseDir;
    }

    private InputStream getResource() throws FileNotFoundException {
        File file = this.resourcePath.toFile();
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return PackageProcessor.class.getClassLoader().getResourceAsStream(this.resourcePath.toString());
    }

    private void loadConfig() throws FileNotFoundException {
        Path configPath = this.baseDir.resolve(CONFIG_FILENAME);
        this.config = JetConfig.fromPath(configPath);
    }
}

