/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.sources;

import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.pipeline.StreamSourceStage;
import com.hazelcast.pc.Source;
import com.hazelcast.pc.config.StageConfig;
import com.hazelcast.pc.exceptions.ConfigurationException;

public class MapJournalSource
implements Source {
    public GeneralStage source(Pipeline pipeline, StageConfig stageConfig) {
        JournalInitialPosition pos;
        String mapName = stageConfig.getRequiredValue("map", String.class);
        String startFrom = stageConfig.getRequiredValue("start-from", String.class);
        if (startFrom.equalsIgnoreCase("oldest")) {
            pos = JournalInitialPosition.START_FROM_OLDEST;
        } else if (startFrom.equalsIgnoreCase("current")) {
            pos = JournalInitialPosition.START_FROM_OLDEST;
        } else {
            throw new ConfigurationException(String.format("Invalid start-from value: %s", startFrom));
        }
        StreamSource source = Sources.mapJournal((String)mapName, (JournalInitialPosition)pos);
        StreamSourceStage sourceStage = pipeline.readFrom(source);
        return Source.maybeApplyTimestamps(sourceStage, stageConfig);
    }
}

