/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExperimentalPipelineSubmitCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.pc.PipelineCreator;
import com.hazelcast.pc.config.JetConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.CompletableFuture;
import java.util.zip.CRC32;

public class PipelineSubmitMessageTask
extends AbstractAsyncMessageTask<ExperimentalPipelineSubmitCodec.RequestParameters, Long> {
    public PipelineSubmitMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    public Permission getRequiredPermission() {
        return null;
    }

    protected CompletableFuture processInternal() {
        JetConfig jetConfig = JetConfig.fromString(((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).pipelineDefinition);
        Pipeline pipeline = PipelineCreator.fromConfig(jetConfig).createPipeline();
        JobConfig config = new JobConfig();
        config.setName(((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).jobName);
        this.validateChecksum(((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).resourceBundleChecksum, ((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).resourceBundle);
        if (((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).resourceBundle != null) {
            try {
                File resourceBundle = File.createTempFile("__resourceBundle.zip", ".zip");
                try (FileOutputStream fileOutputStream = new FileOutputStream(resourceBundle);){
                    fileOutputStream.write(((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).resourceBundle);
                    config.attachFile(resourceBundle, "__resourceBundle.zip");
                }
            }
            catch (IOException e) {
                throw new JetException("Could not create resource bundle file for the Pipeline", (Throwable)e);
            }
        }
        Job job = this.nodeEngine.getHazelcastInstance().getJet().newJob(pipeline, config);
        return CompletableFuture.completedFuture(job.getId());
    }

    private void validateChecksum(int resourceBundleChecksum, byte[] resourceBundle) {
        if (resourceBundle == null) {
            return;
        }
        CRC32 crc32 = new CRC32();
        crc32.update(resourceBundle);
        int crc32Value = (int)crc32.getValue();
        if (resourceBundleChecksum != crc32Value) {
            throw new JetException("Resource bundle checksum(" + resourceBundleChecksum + ") does not match the calculated checksum (" + crc32Value + ")");
        }
    }

    protected ExperimentalPipelineSubmitCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ExperimentalPipelineSubmitCodec.decodeRequest((ClientMessage)clientMessage);
    }

    protected ClientMessage encodeResponse(Object response) {
        return ExperimentalPipelineSubmitCodec.encodeResponse((long)((Long)response));
    }

    public String getServiceName() {
        return "hz:impl:jetService";
    }

    public String getDistributedObjectName() {
        return null;
    }

    public String getMethodName() {
        return "pipelineSubmit";
    }

    public Object[] getParameters() {
        return new Object[]{((ExperimentalPipelineSubmitCodec.RequestParameters)this.parameters).pipelineDefinition};
    }
}

