/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.prunability;

import com.hazelcast.shaded.com.google.common.collect.Sets;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionStrategyConditionExtractor {
    public Map<String, List<Map<String, RexNode>>> extractCondition(Table table, RexCall call, Set<String> partitioningColumns) {
        if (partitioningColumns.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Map<String, RexNode>> variants = this.extractSubCondition(table, call, partitioningColumns);
        if (variants.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Map<String, RexNode> variant : variants) {
            if (Sets.intersection(variant.keySet(), partitioningColumns).equals(partitioningColumns)) continue;
            return Collections.emptyMap();
        }
        return Map.of(table.getSqlName(), variants);
    }

    public List<Map<String, RexNode>> extractSubCondition(Table table, RexCall call, Set<String> partitioningColumns) {
        ArrayList<Map<String, RexNode>> result = new ArrayList<Map<String, RexNode>>();
        switch (call.getKind()) {
            case AND: {
                HashMap<String, RexNode> variant = new HashMap<String, RexNode>();
                for (RexNode operand : call.getOperands()) {
                    if (!(operand instanceof RexCall)) {
                        return Collections.emptyList();
                    }
                    Map.Entry<String, RexNode> condition = this.extractEqualityCondition(table, (RexCall)operand, partitioningColumns);
                    if (condition == null) continue;
                    variant.put(condition.getKey(), condition.getValue());
                }
                result.add(variant);
                break;
            }
            case EQUALS: {
                Map.Entry<String, RexNode> entry = this.extractEqualityCondition(table, call, partitioningColumns);
                if (entry == null) break;
                result.add(Map.ofEntries(entry));
                break;
            }
        }
        return result;
    }

    private Map.Entry<String, RexNode> extractEqualityCondition(Table table, RexCall call, Set<String> partitioningColumns) {
        if (!call.isA(SqlKind.EQUALS)) {
            return null;
        }
        assert (call.getOperands().size() == 2);
        RexInputRef inputRef = this.extractInputRef(call);
        RexNode constantExpr = this.extractConstantExpression(call);
        if (inputRef == null || constantExpr == null) {
            return null;
        }
        String columnName = ((TableField)table.getField(inputRef.getIndex())).getName();
        if (!partitioningColumns.contains(columnName)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, RexNode>(columnName, constantExpr);
    }

    private RexInputRef extractInputRef(RexCall call) {
        assert (call.isA(SqlKind.EQUALS));
        return call.getOperands().stream().filter(operand -> operand instanceof RexInputRef).findFirst().orElse(null);
    }

    private RexNode extractConstantExpression(RexCall call) {
        assert (call.isA(SqlKind.EQUALS));
        return call.getOperands().stream().filter(operand -> operand instanceof RexDynamicParam || operand instanceof RexLiteral).findFirst().orElse(null);
    }
}

