/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface KvMetadataResolver {
    public Stream<String> supportedFormats();

    public Stream<MappingField> resolveAndValidateFields(boolean var1, List<MappingField> var2, Map<String, String> var3, InternalSerializationService var4);

    public KvMetadata resolveMetadata(boolean var1, List<MappingField> var2, Map<String, String> var3, InternalSerializationService var4);

    public static Map<QueryPath, MappingField> extractFields(List<MappingField> fields, boolean isKey) {
        LinkedHashMap<QueryPath, MappingField> fieldsByPath = new LinkedHashMap<QueryPath, MappingField>();
        for (MappingField field : fields) {
            QueryPath path = QueryPath.create(field.externalName());
            if (isKey != path.isKey() || fieldsByPath.putIfAbsent(path, field) == null) continue;
            throw QueryException.error((String)("Duplicate external name: " + String.valueOf(path)));
        }
        return fieldsByPath;
    }

    public static void maybeAddDefaultField(boolean isKey, @Nonnull List<MappingField> resolvedFields, @Nonnull List<TableField> tableFields, @Nonnull QueryDataType type) {
        String fieldName;
        String string = fieldName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        if (resolvedFields.stream().noneMatch(field -> field.name().equals(fieldName))) {
            tableFields.add(new MapTableField(fieldName, type, true, QueryPath.create(fieldName)));
        }
    }

    public static Stream<Field> getFields(Map<QueryPath, MappingField> fields) {
        return KvMetadataResolver.getTopLevelType(fields).map(type -> type.getObjectFields().stream().map(Field::new)).orElseGet(() -> fields.entrySet().stream().filter(e -> !((QueryPath)e.getKey()).isTopLevel()).map(Field::new));
    }

    public static Optional<String> getMetadata(Map<QueryPath, MappingField> fields) {
        return KvMetadataResolver.getTopLevelType(fields).map(QueryDataType::getObjectTypeMetadata);
    }

    public static Optional<QueryDataType> getTopLevelType(Map<QueryPath, MappingField> fields) {
        Map.Entry<QueryPath, MappingField> entry;
        if (fields.size() == 1 && (entry = fields.entrySet().iterator().next()).getKey().isTopLevel() && entry.getValue().type().isCustomType()) {
            return Optional.of(entry.getValue().type());
        }
        return Optional.empty();
    }

    public static class Field {
        private final String name;
        private final QueryDataType type;

        public Field(Map.Entry<QueryPath, MappingField> entry) {
            this.name = entry.getKey().getPath();
            this.type = entry.getValue().type();
        }

        public Field(TableField field) {
            this.name = field instanceof MapTableField ? ((MapTableField)field).getPath().getPath() : field.getName();
            this.type = field.getType();
        }

        public Field(QueryDataType.QueryDataTypeField field) {
            this.name = field.getName();
            this.type = field.getType();
        }

        public String name() {
            return this.name;
        }

        public QueryDataType type() {
            return this.type;
        }
    }
}

