/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public class MappingsTable
extends InfoSchemaTable {
    private static final String NAME = "mappings";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("table_catalog", QueryDataType.VARCHAR, false), new TableField("table_schema", QueryDataType.VARCHAR, false), new TableField("table_name", QueryDataType.VARCHAR, false), new TableField("mapping_external_name", QueryDataType.VARCHAR, false), new TableField("mapping_type", QueryDataType.VARCHAR, false), new TableField("mapping_options", QueryDataType.VARCHAR, false));
    private final String mappingsSchema;
    private final Collection<Mapping> mappings;
    private final Function<String, String> dataConnectionTypeResolver;
    private final boolean securityEnabled;
    private final SqlConnectorCache sqlConnectorCache;

    public MappingsTable(String catalog, String schemaName, String mappingsSchema, Collection<Mapping> mappings, SqlConnectorCache sqlConnectorCache, Function<String, String> dataConnectionTypeResolver, boolean securityEnabled) {
        super(FIELDS, catalog, schemaName, NAME, new ConstantTableStatistics(mappings.size()));
        this.mappingsSchema = mappingsSchema;
        this.mappings = mappings;
        this.sqlConnectorCache = sqlConnectorCache;
        this.dataConnectionTypeResolver = dataConnectionTypeResolver;
        this.securityEnabled = securityEnabled;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.mappings.size());
        for (Mapping mapping : this.mappings) {
            Map<String, String> options;
            if (!this.securityEnabled) {
                options = mapping.options();
            } else {
                options = new TreeMap<String, String>();
                SqlConnector sqlConnector = this.sqlConnectorCache.forType(mapping.connectorType());
                Set<String> secureConnectorOptions = sqlConnector.nonSensitiveConnectorOptions();
                for (Map.Entry<String, String> e : mapping.options().entrySet()) {
                    if (!secureConnectorOptions.contains(e.getKey())) continue;
                    options.put(e.getKey(), e.getValue());
                }
            }
            Object[] row = new Object[]{this.catalog(), this.mappingsSchema, mapping.name(), QueryUtils.quoteCompoundIdentifier(mapping.externalName()), Optional.ofNullable(mapping.dataConnection()).map(this.dataConnectionTypeResolver).orElse(mapping.connectorType()), Util.uncheckCall(() -> JsonUtil.toJson((Object)options))};
            rows.add(row);
        }
        return rows;
    }
}

