/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.service;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.impl.Hints;
import com.hazelcast.vector.impl.ops.ReplicationOperation;
import com.hazelcast.vector.impl.proxy.VectorCollectionProxy;
import com.hazelcast.vector.impl.query.Searcher;
import com.hazelcast.vector.impl.query.SingleStageSearcher;
import com.hazelcast.vector.impl.query.TwoStageSearcher;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsImpl;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsProvider;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class VectorCollectionServiceImpl
implements VectorCollectionService,
ChunkedMigrationAwareService,
OffloadedReplicationPreparation {
    public static final HazelcastProperty MAX_SUCCESSIVE_OFFLOADED_OP_RUN_MILLIS = new HazelcastProperty("hazelcast.vector.max.successive.run.millis", 0, TimeUnit.MILLISECONDS);
    public static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 6L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 8L + SingleStageSearcher.FIXED_HEAP_BYTES_USED + TwoStageSearcher.FIXED_HEAP_BYTES_USED;
    static final long HEAP_BYTES_USED_PER_COLLECTION_NAME = 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    static final long HEAP_BYTES_USED_PER_PARTITION_STORAGE = 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 4L;
    private final NodeEngine nodeEngine;
    private final ILogger logger;
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, VectorCollectionStorage>> storage;
    private final long maxOffloadedRunNanos;
    private final SingleStageSearcher singleStageSearcher;
    private final TwoStageSearcher twoStageSearcher;
    private final LocalVectorCollectionStatsProvider statisticsProvider;

    public VectorCollectionServiceImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(VectorCollectionServiceImpl.class);
        this.storage = new ConcurrentHashMap();
        this.maxOffloadedRunNanos = nodeEngine.getProperties().getNanos(MAX_SUCCESSIVE_OFFLOADED_OP_RUN_MILLIS);
        this.singleStageSearcher = new SingleStageSearcher(nodeEngine);
        this.twoStageSearcher = new TwoStageSearcher(nodeEngine);
        this.statisticsProvider = new LocalVectorCollectionStatsProvider(nodeEngine, this);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this.statisticsProvider);
        }
    }

    @Override
    public void reset() {
        this.storage.clear();
        this.statisticsProvider.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.storage.clear();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName, UUID source, boolean local) {
        VectorCollectionConfig config = this.getExistingVectorCollectionConfig(objectName);
        this.getStatistics(objectName);
        return new VectorCollectionProxy(this.nodeEngine, this, objectName, config);
    }

    @Override
    public void destroyDistributedObject(String objectName, boolean local) {
        this.storage.remove(objectName);
        this.statisticsProvider.destroyStatistics(objectName);
    }

    @Override
    public VectorCollectionStorage getStorage(String vectorCollectionName, int partitionId) {
        return this.storage.computeIfAbsent(vectorCollectionName, name -> new ConcurrentHashMap()).computeIfAbsent(partitionId, i -> this.createStorage(vectorCollectionName, partitionId));
    }

    @Override
    public VectorCollectionStorage createStorage(String vectorCollectionName, int partitionId) {
        VectorCollectionConfig config = this.getExistingVectorCollectionConfig(vectorCollectionName);
        return new VectorCollectionStorage(this.nodeEngine, vectorCollectionName, partitionId, config);
    }

    @Override
    public void attachStorage(@Nonnull VectorCollectionStorage collectionStorage) {
        VectorCollectionStorage previousStorage = this.storage.computeIfAbsent(collectionStorage.getName(), name -> new ConcurrentHashMap()).put(collectionStorage.getPartitionId(), collectionStorage);
        if (previousStorage != null) {
            this.logger.warning(String.format("Existing storage for collection %s partition %d was replaced", collectionStorage.getName(), collectionStorage.getPartitionId()));
        }
        assert (previousStorage == null) : String.format("Existing storage for collection %s partition %d was replaced", collectionStorage.getName(), collectionStorage.getPartitionId());
    }

    @Override
    public VectorCollectionStorage getStorageOrNull(String vectorCollectionName, int partitionId) {
        return (VectorCollectionStorage)this.storage.computeIfAbsent(vectorCollectionName, name -> new ConcurrentHashMap()).get(partitionId);
    }

    @Nonnull
    private VectorCollectionConfig getExistingVectorCollectionConfig(String objectName) {
        VectorCollectionConfig config = this.nodeEngine.getConfig().getVectorCollectionConfigOrNull(objectName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration for vector collection " + objectName + " does not exist");
        }
        VectorCollectionServiceImpl.validateConfig(config);
        return config;
    }

    private static void validateConfig(VectorCollectionConfig config) {
        if (config.getVectorIndexConfigs().size() > 1 && config.getVectorIndexConfigs().stream().anyMatch(index -> index.getName() == null)) {
            throw new InvalidConfigurationException("Vector collection cannot contain both named and unnamed index");
        }
    }

    @Override
    @Nonnull
    public Searcher getSearcher(String collectionName, SearchOptions options) {
        int clusterSize = this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR);
        if (clusterSize <= 1) {
            return this.singleStageSearcher;
        }
        if (Boolean.TRUE == Hints.FORCE_SINGLE_STAGE_SEARCH.get(options)) {
            return this.singleStageSearcher;
        }
        return this.twoStageSearcher;
    }

    @Override
    public LocalVectorCollectionStatsImpl getStatistics(String vectorCollectionName) {
        return this.statisticsProvider.getStatistics(vectorCollectionName);
    }

    public long getMaxOffloadedRunNanos() {
        return this.maxOffloadedRunNanos;
    }

    @Override
    public long heapBytesUsed(String vectorCollectionName) {
        ConcurrentMap chm = this.storage.get(vectorCollectionName);
        return chm == null ? (this.statisticsProvider.hasStatistics(vectorCollectionName) ? LocalVectorCollectionStatsProvider.ENTRY_HEAP_BYTES_USED : 0L) : HEAP_BYTES_USED_PER_PARTITION_STORAGE + (long)chm.size() * HEAP_BYTES_USED_PER_PARTITION_STORAGE + chm.values().stream().mapToLong(VectorCollectionStorage::heapBytesUsed).sum() + LocalVectorCollectionStatsProvider.ENTRY_HEAP_BYTES_USED;
    }

    @Override
    public long localSize(String vectorCollectionName) {
        ConcurrentMap chm = this.storage.get(vectorCollectionName);
        return chm == null ? 0L : chm.values().stream().mapToLong(VectorCollectionStorage::size).sum();
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + (long)this.storage.size() * HEAP_BYTES_USED_PER_COLLECTION_NAME + this.storage.values().stream().mapToLong(chm -> chm.values().stream().mapToLong(vcStorage -> HEAP_BYTES_USED_PER_PARTITION_STORAGE + vcStorage.heapBytesUsed()).sum()).sum() + this.statisticsProvider.heapBytesUsed();
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        Collection namespaces = this.storage.entrySet().stream().filter(collectionEntry -> this.isReplicaIndexEligibleForReplication(event.getReplicaIndex(), 0) && ((ConcurrentHashMap)collectionEntry.getValue()).containsKey(event.getPartitionId())).map(collectionEntry -> new DistributedObjectNamespace("hz:service:vector", (String)collectionEntry.getKey())).collect(Collectors.toCollection(HashSet::new));
        return namespaces;
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        if (namespace instanceof ObjectNamespace) {
            ObjectNamespace ons = (ObjectNamespace)namespace;
            return ons.getServiceName().equals("hz:service:vector") && this.storage.containsKey(ons.getObjectName());
        }
        return false;
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        HashMap<String, VectorCollectionStorage> migrationData = new HashMap<String, VectorCollectionStorage>();
        for (ServiceNamespace ns : namespaces) {
            ObjectNamespace ons;
            String collectionName;
            VectorCollectionStorage maybeStorage;
            if (!(ns instanceof ObjectNamespace) || (maybeStorage = this.getStorageOrNull(collectionName = (ons = (ObjectNamespace)ns).getObjectName(), event.getPartitionId())) == null || !this.isReplicaIndexEligibleForReplication(event.getReplicaIndex(), 0)) continue;
            migrationData.put(collectionName, maybeStorage);
        }
        return migrationData.isEmpty() ? null : new ReplicationOperation(this.nodeEngine, migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.getAllServiceNamespaces(event));
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearPartitionReplica(int partitionId, int durabilityThreshold) {
        for (Map.Entry<String, ConcurrentHashMap<Integer, VectorCollectionStorage>> entry : this.storage.entrySet()) {
            ConcurrentHashMap<Integer, VectorCollectionStorage> collectionPartitions = entry.getValue();
            VectorCollectionStorage partition = collectionPartitions.get(partitionId);
            if (partition == null) continue;
            collectionPartitions.remove(partitionId);
        }
    }

    @Override
    public ChunkSupplier newChunkSupplier(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        assert (!ThreadUtil.isRunningOnPartitionThread());
        for (ServiceNamespace ns : namespaces) {
            ObjectNamespace ons;
            String collectionName;
            VectorCollectionStorage maybeStorage;
            if (!(ns instanceof ObjectNamespace) || (maybeStorage = this.getStorageOrNull(collectionName = (ons = (ObjectNamespace)ns).getObjectName(), event.getPartitionId())) == null || !this.isReplicaIndexEligibleForReplication(event.getReplicaIndex(), 0)) continue;
            maybeStorage.prepareForMigration();
        }
        return ChunkedMigrationAwareService.super.newChunkSupplier(event, namespaces);
    }

    private boolean isReplicaIndexEligibleForReplication(int replicaIndex, int configuredBackupCount) {
        return replicaIndex <= configuredBackupCount;
    }

    @Override
    public boolean shouldOffload() {
        return true;
    }

    @Override
    @Nonnull
    public Set<String> getAllExistingVectorCollectionNames() {
        HashSet<String> allNames = new HashSet<String>(this.storage.keySet());
        allNames.addAll(this.nodeEngine.getProxyService().getDistributedObjectNames("hz:service:vector"));
        return allNames;
    }
}

