/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.service;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.util.LicenseHelper;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.servicemanager.ServiceDescriptor;
import com.hazelcast.spi.impl.servicemanager.ServiceDescriptorProvider;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.vector.impl.service.UnlicensedVectorCollectionServiceImpl;
import com.hazelcast.vector.impl.service.VectorCollectionServiceImpl;

public class VectorCollectionServiceDescriptorProvider
implements ServiceDescriptorProvider {
    private static final ServiceDescriptor[] DESCRIPTORS = new ServiceDescriptor[1];

    @Override
    public ServiceDescriptor[] createServiceDescriptors() {
        return DESCRIPTORS;
    }

    private static boolean checkLicense(NodeEngine nodeEngine) {
        License license = VectorCollectionServiceDescriptorProvider.getLicenseFromNodeExtension(nodeEngine);
        if (license == null) {
            license = VectorCollectionServiceDescriptorProvider.getLicenseFromConfig(nodeEngine);
        }
        return license != null && license.getFeatures().contains(Feature.ADVANCED_AI);
    }

    private static License getLicenseFromConfig(NodeEngine nodeEngine) {
        String licenseKey = nodeEngine.getConfig().getLicenseKey();
        if (licenseKey == null) {
            licenseKey = ClusterProperty.ENTERPRISE_LICENSE_KEY.getSystemProperty();
        }
        if (StringUtil.isNullOrEmpty(licenseKey)) {
            return null;
        }
        return LicenseHelper.getLicense(licenseKey, BuildInfoProvider.getBuildInfo().getVersion());
    }

    private static License getLicenseFromNodeExtension(NodeEngine nodeEngine) {
        NodeExtension nodeExtension = nodeEngine.getNode().getNodeExtension();
        License license = (License)nodeExtension.getLicense();
        return license;
    }

    static {
        VectorCollectionServiceDescriptorProvider.DESCRIPTORS[0] = new ServiceDescriptor(){

            @Override
            public String getServiceName() {
                return "hz:service:vector";
            }

            @Override
            public Object getService(NodeEngine nodeEngine) {
                return VectorCollectionServiceDescriptorProvider.checkLicense(nodeEngine) ? new VectorCollectionServiceImpl(nodeEngine) : new UnlicensedVectorCollectionServiceImpl();
            }
        };
    }
}

