/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.query;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodeQueue;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.AbstractLongHeap;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResult;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.impl.query.FixedSizeLongHeap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;

public class QueryResult {
    private static final SourceResult EMPTY = new SourceResult(null, null);
    private final int maxSourcesCount;
    private final Int2ObjectHashMap<SourceResult> sourceResults;
    private final NodeQueue heap;
    private final int limit;
    private int size;

    public QueryResult(int maxSourcesCount, int expectedCount, int limit) {
        this(maxSourcesCount, expectedCount, limit, FixedSizeLongHeap::new);
    }

    public QueryResult(int maxSourcesCount, int expectedCount, int limit, IntFunction<AbstractLongHeap> heapConstructor) {
        assert (maxSourcesCount > 0);
        assert (limit > 0);
        this.maxSourcesCount = maxSourcesCount;
        this.limit = limit;
        this.sourceResults = new Int2ObjectHashMap(expectedCount);
        int heapSize = expectedCount;
        this.heap = new NodeQueue(heapConstructor.apply(heapSize), NodeQueue.Order.MAX_HEAP);
    }

    public synchronized void addResult(int sourceId, SearchResults<Data, Data> results) {
        assert (sourceId >= 0 && sourceId < this.maxSourcesCount) : "Source id out of range";
        assert (!this.sourceResults.containsKey(sourceId)) : "Duplicate result for source " + sourceId;
        if (results.size() > 0) {
            Iterator<SearchResult<Data, Data>> resultsIterator = results.results();
            SearchResult<Data, Data> bestSourceResult = resultsIterator.next();
            this.heap.push(sourceId, bestSourceResult.getScore());
            this.sourceResults.put(sourceId, new SourceResult(bestSourceResult, resultsIterator));
            this.size += results.size();
        } else {
            this.sourceResults.put(sourceId, EMPTY);
        }
    }

    public synchronized SearchResults<Data, Data> complete() {
        return new LazilyAggregatedSearchResults();
    }

    public PartitionIdSet getSourceIds() {
        return new PartitionIdSet(this.maxSourcesCount, this.sourceResults.keySet());
    }

    public static SearchResults<Data, Data> reduce(Map<Integer, Object> results, SearchOptions searchOptions, int partitionCount) {
        QueryResult allQueryResults = new QueryResult(partitionCount, results.size(), searchOptions.getLimit());
        results.forEach((key, value) -> allQueryResults.addResult((int)key, (SearchResults)value));
        return allQueryResults.complete();
    }

    private static final class SourceResult {
        private SearchResult<Data, Data> best;
        private final Iterator<? extends SearchResult<Data, Data>> remaining;

        private SourceResult(SearchResult<Data, Data> best, Iterator<? extends SearchResult<Data, Data>> remaining) {
            this.best = best;
            this.remaining = remaining;
        }
    }

    public class LazilyAggregatedSearchResults
    implements SearchResults<Data, Data>,
    IdentifiedDataSerializable {
        @Override
        public int size() {
            return Math.min(QueryResult.this.size, QueryResult.this.limit);
        }

        @Override
        public Iterator<SearchResult<Data, Data>> results() {
            return new SearchResultIterator(this.size());
        }

        @Override
        public int getFactoryId() {
            return -100;
        }

        @Override
        public int getClassId() {
            return 13;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.size());
            Iterator<SearchResult<Data, Data>> results = this.results();
            int counter = 0;
            while (results.hasNext()) {
                out.writeObject(results.next());
                ++counter;
            }
            assert (counter == this.size()) : "Inconsistent results or modified during serialization";
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            throw new UnsupportedOperationException("This class in not supposed to be deserialized");
        }
    }

    private class SearchResultIterator
    implements Iterator<SearchResult<Data, Data>> {
        private int remainingToFetch;

        SearchResultIterator(int size) {
            this.remainingToFetch = size;
        }

        @Override
        public boolean hasNext() {
            return this.remainingToFetch > 0;
        }

        @Override
        public SearchResult<Data, Data> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int bestSourceId = QueryResult.this.heap.pop();
            SourceResult bestSourceResult = QueryResult.this.sourceResults.get(bestSourceId);
            SearchResult<Data, Data> r = bestSourceResult.best;
            --this.remainingToFetch;
            if (this.hasNext() && bestSourceResult.remaining.hasNext()) {
                SearchResult<Data, Data> nextResult = bestSourceResult.remaining.next();
                bestSourceResult.best = nextResult;
                QueryResult.this.heap.push(bestSourceId, nextResult.getScore());
            }
            return r;
        }
    }
}

