/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionPutAllCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.security.permission.VectorCollectionPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.ops.PutAllOperation;
import com.hazelcast.vector.impl.ops.VectorEntries;
import com.hazelcast.vector.impl.protocol.task.AbstractVectorCollectionPartitionMessageTask;
import java.security.Permission;
import java.util.Map;

public class VectorCollectionPutAllMessageTask
extends AbstractVectorCollectionPartitionMessageTask<VectorCollectionPutAllCodec.RequestParameters> {
    public VectorCollectionPutAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        VectorEntries mapEntries = new VectorEntries(((VectorCollectionPutAllCodec.RequestParameters)this.parameters).entries);
        return new PutAllOperation(((VectorCollectionPutAllCodec.RequestParameters)this.parameters).name, mapEntries);
    }

    @Override
    protected VectorCollectionPutAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return VectorCollectionPutAllCodec.decodeRequest(clientMessage);
    }

    @Override
    protected Object processResponseBeforeSending(Object response) {
        this.recordStats((stats, nanos) -> stats.incrementPutAllLatencyNanos(((VectorCollectionPutAllCodec.RequestParameters)this.parameters).entries.size(), (long)nanos));
        return response;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return VectorCollectionPutAllCodec.encodeResponse();
    }

    @Override
    public String getDistributedObjectName() {
        return ((VectorCollectionPutAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        Map<Data, DataVectorDocument> map = MapUtil.createHashMap(((VectorCollectionPutAllCodec.RequestParameters)this.parameters).entries.size());
        for (Map.Entry<Data, DataVectorDocument> entry : ((VectorCollectionPutAllCodec.RequestParameters)this.parameters).entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new Object[]{map};
    }

    @Override
    public Permission getRequiredPermission() {
        return new VectorCollectionPermission(this.getDistributedObjectName(), "put");
    }
}

