/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.impl.DataVectorDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class VectorEntries
implements IdentifiedDataSerializable {
    private List<Data> keys;
    private List<DataVectorDocument> documents;

    public VectorEntries() {
    }

    public VectorEntries(int initialSize) {
        this.keys = new ArrayList<Data>(initialSize);
        this.documents = new ArrayList<DataVectorDocument>(initialSize);
    }

    public VectorEntries(Collection<Map.Entry<Data, DataVectorDocument>> entries) {
        int initialSize = entries.size();
        this.keys = new ArrayList<Data>(initialSize);
        this.documents = new ArrayList<DataVectorDocument>(initialSize);
        for (Map.Entry<Data, DataVectorDocument> entry : entries) {
            this.keys.add(entry.getKey());
            this.documents.add(entry.getValue());
        }
    }

    public void add(Data key, DataVectorDocument document) {
        this.ensureEntriesCreated();
        this.keys.add(key);
        this.documents.add(document);
    }

    public Data getKey(int index) {
        return this.keys.get(index);
    }

    public DataVectorDocument getDocument(int index) {
        return this.documents.get(index);
    }

    public int size() {
        return this.keys == null ? 0 : this.keys.size();
    }

    public boolean isEmpty() {
        return CollectionUtil.isEmpty(this.keys);
    }

    public void clear() {
        if (this.keys != null) {
            this.keys.clear();
            this.documents.clear();
        }
    }

    private void ensureEntriesCreated() {
        if (this.keys == null) {
            this.keys = new ArrayList<Data>();
            this.documents = new ArrayList<DataVectorDocument>();
        }
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            IOUtil.writeData(out, this.keys.get(i));
            out.writeObject(this.documents.get(i));
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.keys = new ArrayList<Data>(size);
        this.documents = new ArrayList<DataVectorDocument>(size);
        for (int i = 0; i < size; ++i) {
            this.keys.add(IOUtil.readData(in));
            this.documents.add((DataVectorDocument)in.readObject());
        }
    }
}

