/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.ops.VectorEntries;
import com.hazelcast.vector.impl.service.VectorCollectionServiceImpl;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;

public class PutAllOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
MutatingOperation,
SelfResponseOperation {
    private VectorEntries vectorEntries;
    private transient VectorCollectionServiceImpl service;
    private transient VectorCollectionStorage storage;
    private transient int currentIndex;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, VectorEntries vectorEntries) {
        super(name);
        this.vectorEntries = vectorEntries;
    }

    @Override
    public void beforeRun() {
        this.service = (VectorCollectionServiceImpl)this.getService();
        this.storage = this.service.getStorage(this.getName(), this.getPartitionId());
    }

    @Override
    public CallStatus call() throws Exception {
        if (this.service.getMaxOffloadedRunNanos() > 0L) {
            this.putBatch();
            if (!this.isDone()) {
                return new PutAllOffload();
            }
        } else {
            this.putAll();
        }
        return CallStatus.RESPONSE;
    }

    private void putAll() {
        while (this.currentIndex < this.vectorEntries.size()) {
            DataVectorDocument value = this.vectorEntries.getDocument(this.currentIndex);
            this.storage.set(this.vectorEntries.getKey(this.currentIndex), value.getValue(), value.getVectors());
            ++this.currentIndex;
        }
    }

    private void putBatch() {
        long start = System.nanoTime();
        while (this.currentIndex < this.vectorEntries.size()) {
            DataVectorDocument value = this.vectorEntries.getDocument(this.currentIndex);
            this.storage.set(this.vectorEntries.getKey(this.currentIndex), value.getValue(), value.getVectors());
            ++this.currentIndex;
            if (System.nanoTime() - start < this.service.getMaxOffloadedRunNanos()) continue;
            break;
        }
    }

    private boolean isDone() {
        return this.currentIndex >= this.vectorEntries.size();
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.vectorEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.vectorEntries = (VectorEntries)in.readObject();
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    private OperationRunnerImpl getPartitionOperationRunner() {
        return (OperationRunnerImpl)((OperationServiceImpl)this.getNodeEngine().getOperationService()).getOperationExecutor().getPartitionOperationRunners()[this.getPartitionId()];
    }

    private class PutAllOffload
    extends Offload
    implements PartitionSpecificRunnable {
        private final OperationRunnerImpl partitionOperationRunner;

        PutAllOffload() {
            super(PutAllOperation.this);
            this.partitionOperationRunner = PutAllOperation.this.getPartitionOperationRunner();
        }

        @Override
        public void start() {
            this.schedule();
        }

        private void schedule() {
            this.operationService.execute(this);
        }

        @Override
        public void run() {
            try {
                this.partitionOperationRunner.metWithPreconditions(PutAllOperation.this);
                PutAllOperation.this.putBatch();
                if (PutAllOperation.this.isDone()) {
                    PutAllOperation.this.sendResponse(true);
                } else {
                    this.schedule();
                }
            }
            catch (Throwable t) {
                this.partitionOperationRunner.handleOperationError(PutAllOperation.this, t);
            }
        }

        @Override
        public int getPartitionId() {
            return PutAllOperation.this.getPartitionId();
        }
    }
}

