/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;

public class OptimizeOperation
extends AbstractNamedOperation
implements PartitionAwareOperation {
    private String indexName;
    private VectorCollectionStorage storage;

    public OptimizeOperation(String vectorCollectionName, String indexName) {
        super(vectorCollectionName);
        this.indexName = indexName;
    }

    public OptimizeOperation() {
    }

    @Override
    public void beforeRun() {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        this.storage = service.getStorageOrNull(this.name, this.getPartitionId());
    }

    @Override
    public CallStatus call() throws Exception {
        if (this.storage == null) {
            return CallStatus.RESPONSE;
        }
        return new IndexOptimizeOffloaded();
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 22;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.indexName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.indexName = in.readString();
    }

    final class IndexOptimizeOffloaded
    extends Offload {
        private IndexOptimizeOffloaded() {
            super(OptimizeOperation.this);
        }

        @Override
        public void start() {
            OptimizeOperation.this.storage.lockIndexMutation(OptimizeOperation.this.indexName);
            this.nodeEngine.getExecutionService().execute("hz:offloadable", () -> {
                try {
                    try {
                        OptimizeOperation.this.storage.optimize(OptimizeOperation.this.indexName);
                    }
                    finally {
                        OptimizeOperation.this.storage.unlockIndexMutation(OptimizeOperation.this.indexName);
                    }
                    OptimizeOperation.this.sendResponse(true);
                }
                catch (Throwable t) {
                    OptimizeOperation.this.sendResponse(t);
                }
            });
        }
    }
}

