/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.vector;

import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorUtilSupport;
import java.util.List;

final class DefaultVectorUtilSupport
implements VectorUtilSupport {
    DefaultVectorUtilSupport() {
    }

    @Override
    public float dotProduct(float[] a2, float[] b) {
        int i;
        float res = 0.0f;
        for (i = 0; i < a2.length % 8; ++i) {
            res += b[i] * a2[i];
        }
        if (a2.length < 8) {
            return res;
        }
        while (i + 31 < a2.length) {
            res += b[i + 0] * a2[i + 0] + b[i + 1] * a2[i + 1] + b[i + 2] * a2[i + 2] + b[i + 3] * a2[i + 3] + b[i + 4] * a2[i + 4] + b[i + 5] * a2[i + 5] + b[i + 6] * a2[i + 6] + b[i + 7] * a2[i + 7];
            res += b[i + 8] * a2[i + 8] + b[i + 9] * a2[i + 9] + b[i + 10] * a2[i + 10] + b[i + 11] * a2[i + 11] + b[i + 12] * a2[i + 12] + b[i + 13] * a2[i + 13] + b[i + 14] * a2[i + 14] + b[i + 15] * a2[i + 15];
            res += b[i + 16] * a2[i + 16] + b[i + 17] * a2[i + 17] + b[i + 18] * a2[i + 18] + b[i + 19] * a2[i + 19] + b[i + 20] * a2[i + 20] + b[i + 21] * a2[i + 21] + b[i + 22] * a2[i + 22] + b[i + 23] * a2[i + 23];
            res += b[i + 24] * a2[i + 24] + b[i + 25] * a2[i + 25] + b[i + 26] * a2[i + 26] + b[i + 27] * a2[i + 27] + b[i + 28] * a2[i + 28] + b[i + 29] * a2[i + 29] + b[i + 30] * a2[i + 30] + b[i + 31] * a2[i + 31];
            i += 32;
        }
        while (i + 7 < a2.length) {
            res += b[i + 0] * a2[i + 0] + b[i + 1] * a2[i + 1] + b[i + 2] * a2[i + 2] + b[i + 3] * a2[i + 3] + b[i + 4] * a2[i + 4] + b[i + 5] * a2[i + 5] + b[i + 6] * a2[i + 6] + b[i + 7] * a2[i + 7];
            i += 8;
        }
        return res;
    }

    @Override
    public float dotProduct(float[] a2, int aoffset, float[] b, int boffset, int length) {
        float sum = 0.0f;
        for (int i = 0; i < length; ++i) {
            sum += a2[aoffset + i] * b[boffset + i];
        }
        return sum;
    }

    @Override
    public float cosine(float[] a2, float[] b) {
        float sum = 0.0f;
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        int dim = a2.length;
        for (int i = 0; i < dim; ++i) {
            float elem1 = a2[i];
            float elem2 = b[i];
            sum += elem1 * elem2;
            norm1 += elem1 * elem1;
            norm2 += elem2 * elem2;
        }
        return (float)((double)sum / Math.sqrt((double)norm1 * (double)norm2));
    }

    @Override
    public float squareDistance(float[] a2, float[] b) {
        float squareSum = 0.0f;
        int dim = a2.length;
        int i = 0;
        while (i + 8 <= dim) {
            squareSum += DefaultVectorUtilSupport.squareDistanceUnrolled(a2, b, i);
            i += 8;
        }
        while (i < dim) {
            float diff = a2[i] - b[i];
            squareSum += diff * diff;
            ++i;
        }
        return squareSum;
    }

    private static float squareDistanceUnrolled(float[] v1, float[] v2, int index) {
        float diff0 = v1[index + 0] - v2[index + 0];
        float diff1 = v1[index + 1] - v2[index + 1];
        float diff2 = v1[index + 2] - v2[index + 2];
        float diff3 = v1[index + 3] - v2[index + 3];
        float diff4 = v1[index + 4] - v2[index + 4];
        float diff5 = v1[index + 5] - v2[index + 5];
        float diff6 = v1[index + 6] - v2[index + 6];
        float diff7 = v1[index + 7] - v2[index + 7];
        return diff0 * diff0 + diff1 * diff1 + diff2 * diff2 + diff3 * diff3 + diff4 * diff4 + diff5 * diff5 + diff6 * diff6 + diff7 * diff7;
    }

    @Override
    public float squareDistance(float[] a2, int aoffset, float[] b, int boffset, int length) {
        float squareSum = 0.0f;
        for (int i = 0; i < length; ++i) {
            float diff = a2[aoffset + i] - b[boffset + i];
            squareSum += diff * diff;
        }
        return squareSum;
    }

    @Override
    public int dotProduct(byte[] a2, byte[] b) {
        int total = 0;
        for (int i = 0; i < a2.length; ++i) {
            total += a2[i] * b[i];
        }
        return total;
    }

    @Override
    public float cosine(byte[] a2, byte[] b) {
        int sum = 0;
        int norm1 = 0;
        int norm2 = 0;
        for (int i = 0; i < a2.length; ++i) {
            byte elem1 = a2[i];
            byte elem2 = b[i];
            sum += elem1 * elem2;
            norm1 += elem1 * elem1;
            norm2 += elem2 * elem2;
        }
        return (float)((double)sum / Math.sqrt((double)norm1 * (double)norm2));
    }

    @Override
    public int squareDistance(byte[] a2, byte[] b) {
        int squareSum = 0;
        for (int i = 0; i < a2.length; ++i) {
            int diff = a2[i] - b[i];
            squareSum += diff * diff;
        }
        return squareSum;
    }

    @Override
    public float[] sum(List<float[]> vectors) {
        float[] sum = new float[vectors.get(0).length];
        for (float[] vector : vectors) {
            for (int i = 0; i < vector.length; ++i) {
                int n = i;
                sum[n] = sum[n] + vector[i];
            }
        }
        return sum;
    }

    @Override
    public float sum(float[] vector) {
        float sum = 0.0f;
        for (float v : vector) {
            sum += v;
        }
        return sum;
    }

    @Override
    public void divInPlace(float[] vector, float divisor) {
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] / divisor;
        }
    }

    @Override
    public void addInPlace(float[] v1, float[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] + v2[i];
        }
    }

    @Override
    public void subInPlace(float[] v1, float[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] - v2[i];
        }
    }

    @Override
    public float[] sub(float[] lhs, float[] rhs) {
        float[] result = new float[lhs.length];
        for (int i = 0; i < lhs.length; ++i) {
            result[i] = lhs[i] - rhs[i];
        }
        return result;
    }

    @Override
    public float assembleAndSum(float[] data, int dataBase, byte[] baseOffsets) {
        float sum = 0.0f;
        for (int i = 0; i < baseOffsets.length; ++i) {
            sum += data[dataBase * i + Byte.toUnsignedInt(baseOffsets[i])];
        }
        return sum;
    }

    @Override
    public int hammingDistance(long[] v1, long[] v2) {
        int hd = 0;
        for (int i = 0; i < v1.length; ++i) {
            hd += Long.bitCount(v1[i] ^ v2[i]);
        }
        return hd;
    }
}

