/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.pq;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodeSimilarity;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.CompressedVectors;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.PQDecoder;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.ProductQuantization;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class PQVectors
implements CompressedVectors {
    final ProductQuantization pq;
    private final byte[][] compressedVectors;
    private final ThreadLocal<float[]> partialSums;
    private final ThreadLocal<float[]> partialMagnitudes;

    public PQVectors(ProductQuantization pq, byte[][] compressedVectors) {
        this.pq = pq;
        this.compressedVectors = compressedVectors;
        this.partialSums = ThreadLocal.withInitial(() -> new float[pq.getSubspaceCount() * 256]);
        this.partialMagnitudes = ThreadLocal.withInitial(() -> new float[pq.getSubspaceCount() * 256]);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.pq.write(out);
        out.writeInt(this.compressedVectors.length);
        out.writeInt(this.pq.getSubspaceCount());
        for (byte[] v : this.compressedVectors) {
            out.write(v);
        }
    }

    public static CompressedVectors load(RandomAccessReader in, long offset) throws IOException {
        in.seek(offset);
        ProductQuantization pq = ProductQuantization.load(in);
        int size = in.readInt();
        if (size < 0) {
            throw new IOException("Invalid compressed vector count " + size);
        }
        byte[][] compressedVectors = new byte[size][];
        int compressedDimension = in.readInt();
        if (compressedDimension < 0) {
            throw new IOException("Invalid compressed vector dimension " + compressedDimension);
        }
        for (int i = 0; i < size; ++i) {
            byte[] vector = new byte[compressedDimension];
            in.readFully(vector);
            compressedVectors[i] = vector;
        }
        return new PQVectors(pq, compressedVectors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PQVectors that = (PQVectors)o;
        if (!Objects.equals(this.pq, that.pq)) {
            return false;
        }
        if (this.compressedVectors.length != that.compressedVectors.length) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.compressedVectors, (Object[])that.compressedVectors);
    }

    public int hashCode() {
        return Objects.hash(this.pq, Arrays.deepHashCode((Object[])this.compressedVectors));
    }

    @Override
    public NodeSimilarity.ApproximateScoreFunction approximateScoreFunctionFor(float[] q, VectorSimilarityFunction similarityFunction) {
        switch (similarityFunction) {
            case DOT_PRODUCT: {
                return new PQDecoder.DotProductDecoder(this, q);
            }
            case EUCLIDEAN: {
                return new PQDecoder.EuclideanDecoder(this, q);
            }
            case COSINE: {
                return new PQDecoder.CosineDecoder(this, q);
            }
        }
        throw new IllegalArgumentException("Unsupported similarity function " + String.valueOf((Object)similarityFunction));
    }

    byte[] get(int ordinal) {
        return this.compressedVectors[ordinal];
    }

    float[] reusablePartialSums() {
        return this.partialSums.get();
    }

    float[] reusablePartialMagnitudes() {
        return this.partialMagnitudes.get();
    }

    @Override
    public int getOriginalSize() {
        return this.pq.originalDimension * 4;
    }

    @Override
    public int getCompressedSize() {
        return this.pq.codebooks.length;
    }

    @Override
    public long ramBytesUsed() {
        long codebooksSize = this.pq.memorySize();
        long compressedVectorSize = RamUsageEstimator.sizeOf(this.compressedVectors[0]);
        return codebooksSize + compressedVectorSize * (long)this.compressedVectors.length;
    }
}

