/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.annotations.VisibleForTesting;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.ArrayUtil;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import java.util.Arrays;

public class NodeArray {
    public static final NodeArray EMPTY = new NodeArray(0);
    protected int size;
    float[] score;
    int[] node;

    public NodeArray(int maxSize) {
        this.node = new int[maxSize];
        this.score = new float[maxSize];
    }

    public void addInOrder(int newNode, float newScore) {
        if (this.size == this.node.length) {
            this.node = ArrayUtil.grow(this.node);
            this.score = ArrayUtil.growExact(this.score, this.node.length);
        }
        if (this.size > 0) {
            float previousScore = this.score[this.size - 1];
            assert (previousScore >= newScore) : "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.toString(ArrayUtil.copyOfSubArray(this.score, 0, this.size));
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
    }

    public boolean insertSorted(int newNode, float newScore) {
        int insertionPoint;
        if (this.size == this.node.length) {
            this.growArrays();
        }
        if (this.duplicateExistsNear(insertionPoint = this.descSortFindRightMostInsertionPoint(newScore), newNode, newScore)) {
            return false;
        }
        System.arraycopy(this.node, insertionPoint, this.node, insertionPoint + 1, this.size - insertionPoint);
        System.arraycopy(this.score, insertionPoint, this.score, insertionPoint + 1, this.size - insertionPoint);
        this.node[insertionPoint] = newNode;
        this.score[insertionPoint] = newScore;
        ++this.size;
        return true;
    }

    private boolean duplicateExistsNear(int insertionPoint, int newNode, float newScore) {
        int i;
        for (i = insertionPoint - 1; i >= 0 && this.score[i] == newScore; --i) {
            if (this.node[i] != newNode) continue;
            return true;
        }
        for (i = insertionPoint; i < this.size && this.score[i] == newScore; ++i) {
            if (this.node[i] != newNode) continue;
            return true;
        }
        return false;
    }

    public void retain(Bits selected) {
        int writeIdx = 0;
        for (int readIdx = 0; readIdx < this.size; ++readIdx) {
            if (!selected.get(readIdx)) continue;
            if (writeIdx != readIdx) {
                this.node[writeIdx] = this.node[readIdx];
                this.score[writeIdx] = this.score[readIdx];
            }
            ++writeIdx;
        }
        this.size = writeIdx;
    }

    public NodeArray copy() {
        NodeArray copy = new NodeArray(this.node.length);
        copy.size = this.size;
        System.arraycopy(this.node, 0, copy.node, 0, this.size);
        System.arraycopy(this.score, 0, copy.score, 0, this.size);
        return copy;
    }

    protected final void growArrays() {
        this.node = ArrayUtil.grow(this.node);
        this.score = ArrayUtil.growExact(this.score, this.node.length);
    }

    public int size() {
        return this.size;
    }

    public int[] node() {
        return this.node;
    }

    public float[] score() {
        return this.score;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        --this.size;
    }

    public void removeIndex(int idx) {
        System.arraycopy(this.node, idx + 1, this.node, idx, this.size - idx - 1);
        System.arraycopy(this.score, idx + 1, this.score, idx, this.size - idx - 1);
        --this.size;
    }

    public String toString() {
        return "NodeArray[" + this.size + "]";
    }

    protected final int descSortFindRightMostInsertionPoint(float newScore) {
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.score[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    @VisibleForTesting
    boolean contains(int node) {
        for (int i = 0; i < this.size; ++i) {
            if (this.node[i] != node) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int[] copyDenseNodes() {
        return Arrays.copyOf(this.node, this.size);
    }
}

