/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class SimpleMappedReader
implements RandomAccessReader {
    private static final Logger LOG = Logger.getLogger(SimpleMappedReader.class.getName());
    private final MappedByteBuffer mbb;
    private static final Unsafe unsafe = SimpleMappedReader.getUnsafe();

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            LOG.warning("MappedRandomAccessReader can't acquire needed Unsafe access");
            return null;
        }
    }

    public SimpleMappedReader(Path path) throws IOException {
        this(path.toString());
    }

    public SimpleMappedReader(String name) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(name, "r");
        if (raf.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("MappedRandomAccessReader doesn't support large files");
        }
        this.mbb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
        this.mbb.load();
        raf.close();
    }

    private SimpleMappedReader(MappedByteBuffer sourceMbb) {
        this.mbb = sourceMbb;
    }

    @Override
    public void seek(long offset) {
        this.mbb.position((int)(offset >= (long)this.mbb.limit() ? (long)this.mbb.limit() : offset));
    }

    @Override
    public void readFully(float[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.mbb.getFloat();
        }
    }

    @Override
    public void readFully(byte[] b) {
        this.mbb.get(b);
    }

    @Override
    public void readFully(long[] vector) throws IOException {
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = this.mbb.getLong();
        }
    }

    @Override
    public int readInt() {
        return this.mbb.getInt();
    }

    @Override
    public void read(int[] ints, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            ints[offset + i] = this.mbb.getInt();
        }
    }

    @Override
    public void close() {
        if (unsafe != null) {
            try {
                unsafe.invokeCleaner(this.mbb);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public SimpleMappedReader duplicate() {
        return new SimpleMappedReader((MappedByteBuffer)this.mbb.duplicate());
    }
}

