/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.loginimpl;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.security.ClusterLoginModule;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.CredentialsCallback;
import com.hazelcast.security.TokenCredentials;
import com.hazelcast.security.impl.SecurityUtil;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GssApiLoginModule
extends ClusterLoginModule {
    public static final String OPTION_RELAX_FLAGS_CHECK = "relaxFlagsCheck";
    public static final String OPTION_SECURITY_REALM = "securityRealm";
    public static final String OPTION_USE_NAME_WITHOUT_REALM = "useNameWithoutRealm";
    public static final String OPTION_KEYTAB_FILE = "keytabFile";
    public static final String OPTION_PRINCIPAL = "principal";
    private static final AtomicBoolean KRB5_REALM_GENERATED_WARNING_PRINTED = new AtomicBoolean(false);
    private String name;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        String securityRealm = this.getStringOption(OPTION_SECURITY_REALM, null);
        String keytabFile = this.getStringOption(OPTION_KEYTAB_FILE, null);
        String principal = this.getStringOption(OPTION_PRINCIPAL, null);
        if (securityRealm != null && (principal != null || keytabFile != null)) {
            throw new InvalidConfigurationException("The principal and keytabFile must not be configured when securityRealm is used.");
        }
    }

    @Override
    public boolean onLogin() throws LoginException {
        Subject subject;
        String krbAcceptorRealmName;
        CredentialsCallback cc = new CredentialsCallback();
        try {
            this.callbackHandler.handle(new Callback[]{cc});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new FailedLoginException("Unable to retrieve Certificates. " + e.getMessage());
        }
        Credentials creds = cc.getCredentials();
        if (creds == null || !(creds instanceof TokenCredentials)) {
            throw new FailedLoginException("No valid TokenCredentials found");
        }
        TokenCredentials tokenCreds = (TokenCredentials)creds;
        byte[] token = tokenCreds.getToken();
        if (token == null) {
            throw new FailedLoginException("No token found in TokenCredentials.");
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received Token: " + Base64.getEncoder().encodeToString(token));
        }
        if ((krbAcceptorRealmName = this.getStringOption(OPTION_SECURITY_REALM, null)) != null) {
            subject = SecurityUtil.getRunAsSubject(this.callbackHandler, krbAcceptorRealmName);
        } else {
            String keytabPath = this.getStringOption(OPTION_KEYTAB_FILE, null);
            String principal = this.getStringOption(OPTION_PRINCIPAL, "*");
            RealmConfig realmConfig = SecurityUtil.createKerberosJaasRealmConfig(principal, keytabPath, false);
            if (realmConfig != null && KRB5_REALM_GENERATED_WARNING_PRINTED.compareAndSet(false, true)) {
                this.logger.warning("Using generated Kerberos acceptor realm configuration is not intended for production use. It's recommended to properly configure the Krb5LoginModule manually to fit your needs. Following configuration was generated from provided keytab and principal properties:\n" + SecurityUtil.generateRealmConfigXml(realmConfig, "krb5Acceptor"));
            }
            subject = SecurityUtil.getRunAsSubject(this.callbackHandler, realmConfig);
        }
        if (subject != null) {
            try {
                Subject.doAs(subject, () -> this.acceptToken(token));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof LoginException) {
                    throw (LoginException)e.getCause();
                }
                LoginException loginException = new LoginException("Accepting the token failed");
                loginException.initCause(e.getCause());
                throw loginException;
            }
        } else {
            this.acceptToken(token);
        }
        return true;
    }

    private Void acceptToken(byte[] token) throws LoginException {
        GSSManager gssManager = GSSManager.getInstance();
        try {
            GSSContext gssContext = gssManager.createContext((GSSCredential)null);
            token = gssContext.acceptSecContext(token, 0, token.length);
            boolean relaxChecks = this.getBoolOption(OPTION_RELAX_FLAGS_CHECK, false);
            if (!gssContext.isEstablished()) {
                throw new FailedLoginException("Multi-step negotiation is not supported by this login module");
            }
            if (!relaxChecks) {
                if (token != null && token.length > 0) {
                    throw new FailedLoginException("Mutual authentication is not supported by this login module");
                }
                if (gssContext.getConfState() || gssContext.getIntegState()) {
                    throw new FailedLoginException("Confidentiality and data integrity is not provided by this login module.");
                }
            }
            this.name = this.getAuthenticatedName(gssContext);
            if (!this.getBoolOption("skipRole", false)) {
                this.addRole(this.name);
            }
        }
        catch (GSSException e) {
            this.logger.fine("Accepting the GSS-API token failed.", e);
            throw new LoginException("Accepting the GSS-API token failed. " + e.getMessage());
        }
        return null;
    }

    protected String getAuthenticatedName(GSSContext gssContext) throws GSSException {
        int pos;
        String srcName = gssContext.getSrcName().toString();
        if (this.getBoolOption(OPTION_USE_NAME_WITHOUT_REALM, false) && (pos = srcName.lastIndexOf(64)) > -1) {
            srcName = srcName.substring(0, pos);
        }
        return srcName;
    }

    @Override
    protected String getName() {
        return this.name;
    }
}

