/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanEnterpriseMapRemoveEvent
extends WanEnterpriseMapEvent<Object>
implements SerializationServiceAware {
    private SerializationService serializationService;
    private Data dataKey;
    private transient Object key;

    public WanEnterpriseMapRemoveEvent(@Nonnull String mapName, @Nonnull Data dataKey, int backupCount, @Nonnull SerializationService serializationService) {
        super(mapName, backupCount);
        this.serializationService = serializationService;
        this.dataKey = dataKey;
    }

    public WanEnterpriseMapRemoveEvent() {
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.dataKey;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        IOUtil.writeData(out, this.dataKey);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.dataKey = IOUtil.readData(in);
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementRemove(this.getMapName());
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.REMOVE;
    }

    @Override
    @Nullable
    public Object getEventObject() {
        if (this.key == null) {
            this.key = this.serializationService.toObject(this.dataKey);
        }
        return this.key;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }
}

