/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber.operation;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.querycache.subscriber.operation.MadePublishableOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.io.IOException;
import javax.annotation.Nonnull;

public class MadePublishableOperationFactory
implements OperationFactory {
    private String mapName;
    private String cacheId;

    public MadePublishableOperationFactory() {
    }

    public MadePublishableOperationFactory(@Nonnull String mapName, @Nonnull String cacheId) {
        this.cacheId = Preconditions.checkHasText(cacheId, "cacheId");
        this.mapName = Preconditions.checkHasText(mapName, "mapName");
    }

    @Override
    public Operation createOperation() {
        return new MadePublishableOperation(this.mapName, this.cacheId);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeString(this.cacheId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.cacheId = in.readString();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 115;
    }
}

