/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;

public final class EnterpriseMapPartitionClearOperation
extends Operation
implements PartitionAwareOperation,
AllowedDuringPassiveState,
IdentifiedDataSerializable {
    private final transient boolean onShutdown;
    private final CountDownLatch done = new CountDownLatch(1);

    public EnterpriseMapPartitionClearOperation() {
        this(false);
    }

    public EnterpriseMapPartitionClearOperation(boolean onShutdown) {
        this.onShutdown = onShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int partitionId = this.getPartitionId();
            MapService mapService = (MapService)this.getService();
            MapServiceContext mapServiceContext = mapService.getMapServiceContext();
            mapServiceContext.removeRecordStoresFromPartitionMatchingWith(EnterpriseMapPartitionClearOperation.allRecordStores(), partitionId, this.onShutdown, false);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof PartitionMigratingException) {
            ILogger logger = this.getLogger();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, e.toString());
            }
        } else {
            super.logError(e);
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.done.countDown();
        super.onExecutionFailure(e);
    }

    private static Predicate<RecordStore> allRecordStores() {
        return recordStore -> true;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.done.await(timeout, unit);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFactoryId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getClassId() {
        throw new UnsupportedOperationException();
    }
}

