/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MerkleTreeDiffIterator;
import com.hazelcast.map.impl.NotifiableIterator;
import com.hazelcast.map.impl.operation.MapChunkContext;
import com.hazelcast.map.impl.operation.MutableMapEntry;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.TieredStorageImpl;
import java.util.Iterator;
import java.util.Map;

public final class EnterpriseMapChunkContext
extends MapChunkContext {
    private int[] merkleTreeDiff;

    public EnterpriseMapChunkContext(MapServiceContext mapServiceContext, int partitionId, ServiceNamespace namespaces) {
        super(mapServiceContext, partitionId, namespaces);
    }

    public void setMerkleTreeDiff(int[] merkleTreeDiff) {
        this.merkleTreeDiff = merkleTreeDiff;
    }

    public int[] getMerkleTreeDiff() {
        return this.merkleTreeDiff;
    }

    @Override
    protected Iterator<Map.Entry<Data, Record>> createIterator() {
        Iterator iterator = this.newIterator();
        return new MerkleTreeDiffIterator(iterator, this.merkleTreeDiff);
    }

    private Iterator<Map.Entry<Data, Record>> newIterator() {
        if (this.isTieredStoreEnabled()) {
            return this.asAdaptedNoCachingIterator();
        }
        return super.createIterator();
    }

    private boolean isTieredStoreEnabled() {
        return this.getRecordStore().getMapContainer().getMapConfig().getTieredStoreConfig().isEnabled();
    }

    private Iterator<Map.Entry<Data, Record>> asAdaptedNoCachingIterator() {
        TieredStorageImpl tieredStorage = (TieredStorageImpl)this.getRecordStore().getStorage();
        return new AdaptedNoCachingIterator(tieredStorage.mapEntryNoCachingIterator());
    }

    private static class AdaptedNoCachingIterator
    implements Iterator<Map.Entry<Data, Record>>,
    NotifiableIterator {
        final Iterator<Map.Entry<Data, Record<Data>>> iterator;
        final MutableMapEntry<Data, Record> cachedEntry = new MutableMapEntry();

        AdaptedNoCachingIterator(Iterator<Map.Entry<Data, Record<Data>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<Data, Record> next() {
            Map.Entry<Data, Record<Data>> entry = this.iterator.next();
            this.cachedEntry.init(entry.getKey(), entry.getValue());
            return this.cachedEntry;
        }

        @Override
        public void onBeforeIteration() {
            Iterator<Map.Entry<Data, Record<Data>>> iterator = this.iterator;
            if (iterator instanceof NotifiableIterator) {
                NotifiableIterator notifiableIterator = (NotifiableIterator)((Object)iterator);
                notifiableIterator.onBeforeIteration();
            }
        }
    }
}

