/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.deployment.JetDelegatingClassLoader;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapResourceClassLoader
extends JetDelegatingClassLoader {
    static final String PROTOCOL = "map-resource";
    protected final Supplier<? extends Map<String, byte[]>> resourcesSupplier;
    protected final boolean childFirst;
    protected volatile boolean isShutdown;
    private final ILogger logger = Logger.getLogger(this.getClass());
    @Nullable
    private final String userCodeNamespace;
    private final ConcurrentMap<String, WeakReference<Class<?>>> classCache = new ConcurrentHashMap(100);

    MapResourceClassLoader(ClassLoader parent, @Nonnull Supplier<? extends Map<String, byte[]>> resourcesSupplier, boolean childFirst) {
        super(parent);
        this.userCodeNamespace = null;
        this.resourcesSupplier = Util.memoizeConcurrent(resourcesSupplier);
        this.childFirst = childFirst;
    }

    public MapResourceClassLoader(@Nonnull String userCodeNamespace, ClassLoader parent, @Nonnull Supplier<? extends Map<String, byte[]>> resourcesSupplier, boolean childFirst) {
        super("ucd-namespace", parent);
        this.userCodeNamespace = userCodeNamespace;
        this.resourcesSupplier = Util.memoizeConcurrent(resourcesSupplier);
        this.childFirst = childFirst;
    }

    @Nullable
    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz;
        if (!this.childFirst) {
            return super.loadClass(name, resolve);
        }
        WeakReference reference = (WeakReference)this.classCache.get(name);
        if (reference != null && (clazz = (Class)reference.get()) != null) {
            return clazz;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> klass;
            block12: {
                klass = this.findLoadedClass(name);
                try {
                    if (klass == null) {
                        klass = this.findClass(name);
                    }
                }
                catch (ClassNotFoundException ignored) {
                    if (!this.logger.isFinestEnabled()) break block12;
                    this.logger.finest(ignored);
                }
            }
            if (klass == null && this.getParent() != null) {
                try {
                    klass = this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    throw this.newClassNotFoundException(name);
                }
            }
            if (resolve) {
                this.resolveClass(klass);
            }
            this.classCache.put(name, new WeakReference(klass));
            return klass;
        }
    }

    public Class<?> loadClassFromThisLoader(Class<?> clazz) {
        try {
            byte[] content = ReflectionUtils.getClassContent(clazz.getName(), clazz.getClassLoader());
            if (content == null) {
                throw new IllegalArgumentException("Unable to read bytes for extra resource class: " + String.valueOf(clazz));
            }
            this.definePackage(clazz.getName());
            Class<?> result = this.defineClass(clazz.getName(), content, 0, content.length);
            this.resolveClass(result);
            return result;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to create extra resource class: " + String.valueOf(clazz));
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (StringUtil.isNullOrEmpty(name)) {
            return null;
        }
        byte[] classBytes = this.resourceBytes(ReflectionUtils.toClassResourceId(name));
        if (classBytes == null) {
            throw this.newClassNotFoundException(name);
        }
        this.definePackage(name);
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
    }

    @Override
    @Nullable
    public URL getResource(@Nonnull String name) {
        Objects.requireNonNull(name);
        if (!this.childFirst) {
            return super.getResource(name);
        }
        URL res = this.findResource(name);
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }

    @Override
    protected URL findResource(String name) {
        if (this.checkShutdown(name) || StringUtil.isNullOrEmpty(name)) {
            return null;
        }
        Map<String, byte[]> resourceMap = this.getResourceMap();
        if (!resourceMap.containsKey(JobRepository.classKeyName(name)) && !resourceMap.containsKey(JobRepository.fileKeyName(name))) {
            return null;
        }
        try {
            return new URL(PROTOCOL, null, -1, name, new MapResourceURLStreamHandler());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, byte[]> getResourceMap() {
        return this.resourcesSupplier.get();
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        URL foundResource = this.findResource(name);
        return foundResource == null ? Collections.emptyEnumeration() : Collections.enumeration(Collections.singleton(foundResource));
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    boolean checkShutdown(String resource) {
        return this.isShutdown;
    }

    @Nullable
    InputStream resourceStream(String name) {
        if (this.checkShutdown(name)) {
            return null;
        }
        byte[] classData = this.getBytes(name);
        if (classData == null) {
            return null;
        }
        return new InflaterInputStream(new ByteArrayInputStream(classData));
    }

    @Nullable
    byte[] resourceBytes(String name) {
        if (this.checkShutdown(name)) {
            return null;
        }
        byte[] classData = this.getBytes(name);
        if (classData == null) {
            return null;
        }
        return IOUtil.decompress(classData);
    }

    @Nullable
    private byte[] getBytes(String name) {
        Map<String, byte[]> resourceMap = this.getResourceMap();
        byte[] classData = resourceMap.get(JobRepository.classKeyName(name));
        if (classData == null && (classData = resourceMap.get(JobRepository.fileKeyName(name))) == null) {
            return null;
        }
        return classData;
    }

    ClassNotFoundException newClassNotFoundException(String name) {
        if (this.logger.isFinestEnabled()) {
            return new ClassNotFoundException("No resource could be identified for '" + name + "'. List of resources:\n" + String.valueOf(this.getResourceMap().keySet()));
        }
        return new ClassNotFoundException(name);
    }

    void definePackage(String className) {
        if (StringUtil.isNullOrEmpty(className)) {
            return;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName = className.substring(0, lastDotIndex);
        if (this.getDefinedPackage(packageName) != null) {
            return;
        }
        try {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    protected final class MapResourceURLStreamHandler
    extends URLStreamHandler {
        protected MapResourceURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new MapResourceURLConnection(u);
        }
    }

    private final class MapResourceURLConnection
    extends URLConnection {
        MapResourceURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return MapResourceClassLoader.this.resourceStream(this.url.getFile());
        }
    }
}

