/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.tpcengine.util.OS;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobResult;
import com.hazelcast.jet.impl.MasterContext;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.deployment.IMapOutputStream;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.IOUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.EntryRemovingProcessor;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobRepository {
    public static final String INTERNAL_JET_OBJECTS_PREFIX = "__jet.";
    public static final String EXPORTED_SNAPSHOTS_PREFIX = "__jet.exportedSnapshot.";
    public static final String EXPORTED_SNAPSHOTS_DETAIL_CACHE = "__jet.exportedSnapshotsCache";
    public static final String RESOURCES_MAP_NAME_PREFIX = "__jet.resources.";
    public static final String FILE_STORAGE_KEY_NAME_PREFIX = "f.";
    public static final String CLASS_STORAGE_KEY_NAME_PREFIX = "c.";
    public static final String RANDOM_ID_GENERATOR_NAME = "__jet.ids";
    public static final String JOB_RECORDS_MAP_NAME = "__jet.records";
    public static final String JOB_EXECUTION_RECORDS_MAP_NAME = "__jet.executionRecords";
    public static final String JOB_RESULTS_MAP_NAME = "__jet.results";
    public static final String JOB_METRICS_MAP_NAME = "__jet.results.metrics";
    public static final String SNAPSHOT_DATA_MAP_PREFIX = "__jet.snapshot.";
    private static final int MAX_NO_RESULTS_OVERHEAD = 20;
    private static final long DEFAULT_RESOURCES_EXPIRATION_MILLIS = TimeUnit.HOURS.toMillis(2L);
    private static final int JOB_ID_STRING_LENGTH = com.hazelcast.jet.Util.idToString(0L).length();
    private final HazelcastInstance instance;
    private final ILogger logger;
    private final ConcurrentMemoizingSupplier<IMap<Long, JobRecord>> jobRecords;
    private final ConcurrentMemoizingSupplier<IMap<Long, JobResult>> jobResults;
    private final Supplier<IMap<Long, JobExecutionRecord>> jobExecutionRecords;
    private final Supplier<IMap<Long, List<RawJobMetrics>>> jobMetrics;
    private final Supplier<IMap<String, SnapshotValidationRecord>> exportedSnapshotDetailsCache;
    private final Supplier<FlakeIdGenerator> idGenerator;
    private long resourcesExpirationMillis = DEFAULT_RESOURCES_EXPIRATION_MILLIS;

    public JobRepository(HazelcastInstance instance) {
        this.instance = instance;
        this.logger = instance.getLoggingService().getLogger(this.getClass());
        this.jobRecords = new ConcurrentMemoizingSupplier<IMap>(() -> instance.getMap(JOB_RECORDS_MAP_NAME));
        this.jobResults = new ConcurrentMemoizingSupplier<IMap>(() -> instance.getMap(JOB_RESULTS_MAP_NAME));
        this.jobExecutionRecords = Util.memoizeConcurrent(() -> JobRepository.safeImap(instance.getMap(JOB_EXECUTION_RECORDS_MAP_NAME)));
        this.jobMetrics = Util.memoizeConcurrent(() -> instance.getMap(JOB_METRICS_MAP_NAME));
        this.exportedSnapshotDetailsCache = Util.memoizeConcurrent(() -> instance.getMap(EXPORTED_SNAPSHOTS_DETAIL_CACHE));
        this.idGenerator = Util.memoizeConcurrent(() -> instance.getFlakeIdGenerator(RANDOM_ID_GENERATOR_NAME));
    }

    public static <K, V> IMap<K, V> safeImap(IMap<K, V> map) {
        if (map instanceof MapProxyImpl) {
            ((MapProxyImpl)map).setFailOnIndeterminateOperationState(true);
        }
        return map;
    }

    void setResourcesExpirationMillis(long resourcesExpirationMillis) {
        this.resourcesExpirationMillis = resourcesExpirationMillis;
    }

    void uploadJobResources(long jobId, JobConfig jobConfig) {
        HashMap<String, byte[]> tmpMap = new HashMap<String, byte[]>();
        boolean resourceImapCreated = false;
        Supplier<IMap> jobFileStorage = Util.memoize(() -> this.getJobResources(jobId));
        try {
            block33: for (ResourceConfig rc : jobConfig.getResourceConfigs().values()) {
                switch (rc.getResourceType()) {
                    case CLASSPATH_RESOURCE: 
                    case CLASS: {
                        InputStream in = rc.getUrl().openStream();
                        try {
                            JobRepository.readStreamAndPutCompressedToMap(rc.getId(), tmpMap, in);
                            continue block33;
                        }
                        finally {
                            if (in == null) continue block33;
                            in.close();
                            continue block33;
                        }
                    }
                    case FILE: {
                        IMapOutputStream os;
                        InputStream in = rc.getUrl().openStream();
                        try {
                            os = new IMapOutputStream(jobFileStorage.get(), JobRepository.fileKeyName(rc.getId()));
                            try {
                                resourceImapCreated = true;
                                IOUtil.packStreamIntoZip(in, os, Objects.requireNonNull(IOUtil.fileNameFromUrl(rc.getUrl())));
                                continue block33;
                            }
                            finally {
                                os.close();
                                continue block33;
                            }
                        }
                        finally {
                            if (in == null) continue block33;
                            in.close();
                            continue block33;
                        }
                    }
                    case DIRECTORY: {
                        Path baseDir = this.validateAndGetDirectoryPath(rc);
                        IMapOutputStream os = new IMapOutputStream(jobFileStorage.get(), JobRepository.fileKeyName(rc.getId()));
                        try {
                            resourceImapCreated = true;
                            IOUtil.packDirectoryIntoZip(baseDir, os);
                            continue block33;
                        }
                        finally {
                            os.close();
                            continue block33;
                        }
                    }
                    case JAR: {
                        this.loadJar(tmpMap, rc);
                        break;
                    }
                    case JARS_IN_ZIP: {
                        this.loadJarsInZip(tmpMap, rc.getUrl());
                        break;
                    }
                    default: {
                        throw new JetException("Unsupported resource type: " + String.valueOf((Object)rc.getResourceType()));
                    }
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            if (resourceImapCreated) {
                jobFileStorage.get().destroy();
            }
            throw new JetException("Job resource upload failed", e);
        }
        if (!tmpMap.isEmpty()) {
            IMap jobResourcesMap = jobFileStorage.get();
            try {
                jobResourcesMap.putAll(tmpMap);
            }
            catch (Exception e) {
                try {
                    jobResourcesMap.destroy();
                }
                catch (Exception ee) {
                    JetException wrapper = new JetException("Job resource upload failed", ee);
                    wrapper.addSuppressed(e);
                    throw wrapper;
                }
                throw new JetException("Job resource upload failed", e);
            }
        }
    }

    private Path validateAndGetDirectoryPath(ResourceConfig rc) throws URISyntaxException, IOException {
        Path baseDir = Paths.get(rc.getUrl().toURI());
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            throw new FileNotFoundException(String.valueOf(baseDir) + " is not a valid directory");
        }
        return baseDir;
    }

    public long newJobId() {
        return this.idGenerator.get().newId();
    }

    private void loadJar(Map<String, byte[]> tmpMap, ResourceConfig rc) throws IOException {
        try (InputStream in = rc.getUrl().openStream();){
            this.loadJarFromInputStream(tmpMap, in);
        }
    }

    private void loadJarsInZip(Map<String, byte[]> map, URL url) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(url.openStream());){
            JobRepository.executeOnJarsInZIP(inputStream, zis -> {
                try {
                    this.loadJarFromInputStream(map, (InputStream)zis);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static void executeOnJarsInZIP(InputStream zip, Consumer<ZipInputStream> processor) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zis = new ZipInputStream(zip);
        while ((zipEntry = zis.getNextEntry()) != null) {
            if (zipEntry.isDirectory() || !StringUtil.lowerCaseInternal(zipEntry.getName()).endsWith(".jar")) continue;
            processor.accept(zis);
        }
    }

    private void loadJarFromInputStream(Map<String, byte[]> map, InputStream is) throws IOException {
        JarEntry jarEntry;
        JarInputStream jis = new JarInputStream(is);
        while ((jarEntry = jis.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory()) continue;
            JobRepository.readStreamAndPutCompressedToMap(jarEntry.getName(), map, jis);
        }
    }

    private static void readStreamAndPutCompressedToMap(String resourceName, Map<String, byte[]> map, InputStream in) throws IOException {
        map.putIfAbsent(JobRepository.classKeyName(resourceName), com.hazelcast.internal.nio.IOUtil.compress(in.readAllBytes()));
    }

    void putNewJobRecord(JobRecord jobRecord) {
        long jobId = jobRecord.getJobId();
        JobRecord prev = this.jobRecords.get().putIfAbsent(jobId, jobRecord);
        if (prev != null && !prev.getDag().equals(jobRecord.getDag())) {
            throw new IllegalStateException("Cannot put job record for job " + com.hazelcast.jet.Util.idToString(jobId) + " because it already exists with a different DAG");
        }
    }

    void updateJobRecord(JobRecord jobRecord) {
        this.jobRecords.get().set(jobRecord.getJobId(), jobRecord);
    }

    void updateJobQuorumSizeIfSmaller(long jobId, int newQuorumSize) {
        this.jobExecutionRecords.get().executeOnKey(jobId, ImdgUtil.entryProcessor((key, value) -> {
            if (value == null) {
                return null;
            }
            value.setLargerQuorumSize(newQuorumSize);
            return value;
        }));
    }

    long newExecutionId() {
        return this.idGenerator.get().newId();
    }

    void completeJob(@Nonnull MasterContext masterContext, @Nullable List<RawJobMetrics> terminalMetrics, @Nullable Throwable error, long completionTime, boolean userCancelled) {
        long jobId = masterContext.jobId();
        JobConfig config = masterContext.jobRecord().getConfig();
        long creationTime = masterContext.jobRecord().getCreationTime();
        JobResult jobResult = new JobResult(jobId, config, creationTime, completionTime, JobRepository.toErrorMsg(error), userCancelled);
        if (terminalMetrics != null) {
            try {
                List<RawJobMetrics> prevMetrics = this.jobMetrics.get().put(jobId, terminalMetrics);
                if (prevMetrics != null) {
                    this.logger.warning("Overwriting job metrics for job " + String.valueOf(jobResult));
                }
            }
            catch (Exception e) {
                this.logger.warning("Storing the job metrics failed, ignoring: " + String.valueOf(e), e);
            }
        }
        while (true) {
            try {
                this.jobResults.get().set(jobId, jobResult);
            }
            catch (Exception e) {
                LifecycleService lifecycleService = this.instance.getLifecycleService();
                if (e instanceof HazelcastInstanceNotActiveException && !lifecycleService.isRunning()) {
                    throw e;
                }
                long retryTimeoutSeconds = 1L;
                this.logger.warning("Failed to store JobResult, will retry in " + retryTimeoutSeconds + " seconds: " + String.valueOf(e), e);
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(retryTimeoutSeconds));
                continue;
            }
            break;
        }
        this.deleteJob(jobId, !config.getResourceConfigs().isEmpty());
    }

    void deleteJob(long jobId, boolean hasResources) {
        BiConsumer<Object, Throwable> callback = (v, t) -> {
            if (t != null) {
                this.logger.warning("Failed to remove " + v.getClass().getSimpleName() + " for job " + com.hazelcast.jet.Util.idToString(jobId) + ", ignoring", (Throwable)t);
            }
        };
        this.jobExecutionRecords.get().removeAsync(jobId).whenComplete(callback);
        this.jobRecords.get().removeAsync(jobId).whenComplete(callback);
        if (hasResources) {
            this.getJobResources(jobId).destroy();
        }
    }

    void cleanup(NodeEngine nodeEngine) {
        if (!this.jobRecordsMapExists()) {
            this.logger.fine("Skipping job cleanup because job records IMap does not exist");
            return;
        }
        long start = System.nanoTime();
        this.cleanupMaps(nodeEngine);
        this.cleanupJobResults(nodeEngine);
        long elapsed = System.nanoTime() - start;
        this.logger.fine("Job cleanup took " + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms");
    }

    private void cleanupMaps(NodeEngine nodeEngine) {
        Collection<DistributedObject> maps = nodeEngine.getProxyService().getDistributedObjects("hz:impl:mapService");
        HashSet<Long> activeJobs = new HashSet<Long>(this.jobRecordsMap().keySet());
        for (DistributedObject map : maps) {
            if (map.getName().startsWith(SNAPSHOT_DATA_MAP_PREFIX)) {
                long id = JobRepository.jobIdFromPrefixedName(map.getName(), SNAPSHOT_DATA_MAP_PREFIX);
                if (activeJobs.contains(id)) continue;
                this.logger.fine("Deleting snapshot data map '%s' because job already finished", map.getName());
                map.destroy();
                continue;
            }
            if (!map.getName().startsWith(RESOURCES_MAP_NAME_PREFIX)) continue;
            this.deleteMap(activeJobs, map);
        }
    }

    private void deleteMap(Set<Long> activeJobs, DistributedObject map) {
        long id = JobRepository.jobIdFromPrefixedName(map.getName(), RESOURCES_MAP_NAME_PREFIX);
        if (activeJobs.contains(id)) {
            return;
        }
        if (this.jobResults.get().containsKey(id)) {
            this.logger.fine("Deleting job resource map '%s' because job is already finished", map.getName());
            map.destroy();
        } else {
            IMap resourceMap = (IMap)map;
            long creationTime = resourceMap.getLocalMapStats().getCreationTime();
            if (this.isResourceMapExpired(creationTime)) {
                this.logger.fine("Deleting job resource map " + map.getName() + " because the map was created long ago and job record or result still doesn't exist");
                resourceMap.destroy();
            }
        }
    }

    private void cleanupJobResults(NodeEngine nodeEngine) {
        int maxNoResults = Math.max(1, nodeEngine.getProperties().getInteger(ClusterProperty.JOB_RESULTS_MAX_SIZE));
        Map<Long, JobResult> jobResultsMap = this.jobResultsMap();
        if ((long)jobResultsMap.size() > Util.addClamped(maxNoResults, maxNoResults / 20)) {
            Set<Long> jobIds = jobResultsMap.values().stream().sorted(Comparator.comparing(JobResult::getCompletionTime).reversed()).skip(maxNoResults).map(JobResult::getJobId).collect(Collectors.toSet());
            this.jobMetrics.get().submitToKeys(jobIds, EntryRemovingProcessor.ENTRY_REMOVING_PROCESSOR);
            this.jobResults.get().submitToKeys(jobIds, EntryRemovingProcessor.ENTRY_REMOVING_PROCESSOR);
            jobIds.forEach(jobId -> {
                String resourcesMapName = JobRepository.jobResourcesMapName(jobId);
                if (nodeEngine.getProxyService().existsDistributedObject("hz:impl:mapService", resourcesMapName)) {
                    this.instance.getMap(resourcesMapName).destroy();
                }
            });
        }
    }

    private static String toErrorMsg(@Nullable Throwable error) {
        if (error == null) {
            return null;
        }
        if (error.getClass().equals(JetException.class) && error.getMessage() != null) {
            String stackTrace = ExceptionUtil.toString(error);
            return stackTrace.substring(stackTrace.indexOf(32) + 1);
        }
        return ExceptionUtil.toString(error);
    }

    private static long jobIdFromPrefixedName(String name, String prefix) {
        int idx = prefix.length();
        String jobId = name.substring(idx, idx + JOB_ID_STRING_LENGTH);
        return com.hazelcast.jet.Util.idFromString(jobId);
    }

    private boolean isResourceMapExpired(long creationTime) {
        return System.currentTimeMillis() - creationTime >= this.resourcesExpirationMillis;
    }

    Set<Long> getAllJobIds() {
        HashSet<Long> ids = new HashSet<Long>();
        ids.addAll(this.jobRecordsMap().keySet());
        ids.addAll(this.jobResultsMap().keySet());
        return ids;
    }

    public Collection<String> getActiveJobNames() {
        Map<Long, String> res = this.getJobRecords().stream().filter(record -> record.getConfig().getName() != null).collect(Collectors.toMap(JobRecord::getJobId, record -> record.getConfig().getName()));
        for (JobResult result : this.getJobResults()) {
            res.remove(result.getJobId());
        }
        return res.values();
    }

    public Collection<JobRecord> getJobRecords() {
        return this.jobRecordsMap().values();
    }

    public boolean jobRecordsMapExists() {
        return ((AbstractJetInstance)this.instance.getJet()).existsDistributedObject("hz:impl:mapService", JOB_RECORDS_MAP_NAME);
    }

    private Map<Long, JobRecord> jobRecordsMap() {
        if (this.jobRecords.remembered() != null || this.jobRecordsMapExists()) {
            return this.jobRecords.get();
        }
        return Collections.emptyMap();
    }

    private Map<Long, JobResult> jobResultsMap() {
        if (this.jobResults.remembered() != null || ((AbstractJetInstance)this.instance.getJet()).existsDistributedObject("hz:impl:mapService", JOB_RESULTS_MAP_NAME)) {
            return this.jobResults.get();
        }
        return Collections.emptyMap();
    }

    public JobRecord getJobRecord(long jobId) {
        return this.jobRecords.get().get(jobId);
    }

    public JobExecutionRecord getJobExecutionRecord(long jobId) {
        return this.jobExecutionRecords.get().get(jobId);
    }

    public IMap<String, byte[]> getJobResources(long jobId) {
        return this.instance.getMap(JobRepository.jobResourcesMapName(jobId));
    }

    @Nullable
    public JobResult getJobResult(long jobId) {
        return this.jobResults.get().get(jobId);
    }

    @Nullable
    List<RawJobMetrics> getJobMetrics(long jobId) {
        return this.jobMetrics.get().get(jobId);
    }

    Collection<JobResult> getJobResults() {
        return this.jobResults.get().values();
    }

    Collection<JobResult> getJobResults(@Nonnull String name) {
        return this.jobResults.get().values(new FilterJobResultByNamePredicate(name));
    }

    boolean writeJobExecutionRecord(long jobId, JobExecutionRecord record, boolean canCreate) {
        record.updateTimestamp();
        String message = (String)this.jobExecutionRecords.get().executeOnKey(jobId, new UpdateJobExecutionRecordEntryProcessor(jobId, record, canCreate));
        if (message != null) {
            this.logger.fine(message);
            if (message.endsWith("oldValue == null")) {
                return true;
            }
        }
        return message == null;
    }

    public static String snapshotDataMapName(long jobId, int dataMapIndex) {
        if (dataMapIndex < 0) {
            throw new IllegalStateException("Negative dataMapIndex - no successful snapshot");
        }
        return SNAPSHOT_DATA_MAP_PREFIX + com.hazelcast.jet.Util.idToString(jobId) + "." + dataMapIndex;
    }

    public static String jobResourcesMapName(long jobId) {
        return RESOURCES_MAP_NAME_PREFIX + com.hazelcast.jet.Util.idToString(jobId);
    }

    public static String fileKeyName(String id) {
        return OS.ensureUnixSeparators(FILE_STORAGE_KEY_NAME_PREFIX + id);
    }

    public static String classKeyName(String id) {
        return OS.ensureUnixSeparators(CLASS_STORAGE_KEY_NAME_PREFIX + id);
    }

    public static String exportedSnapshotMapName(String name) {
        return EXPORTED_SNAPSHOTS_PREFIX + name;
    }

    void clearSnapshotData(long jobId, int dataMapIndex) {
        String mapName = JobRepository.snapshotDataMapName(jobId, dataMapIndex);
        try {
            this.instance.getMap(mapName).clear();
            this.logger.fine("Cleared snapshot data map %s", mapName);
        }
        catch (Exception logged) {
            this.logger.warning("Cannot delete old snapshot data  " + com.hazelcast.jet.Util.idToString(jobId), logged);
        }
    }

    void cacheValidationRecord(@Nonnull String snapshotName, @Nonnull SnapshotValidationRecord validationRecord) {
        try {
            this.exportedSnapshotDetailsCache.get().set(snapshotName, validationRecord);
        }
        catch (Exception e) {
            this.logger.warning("Snapshot name: '" + snapshotName + "', failed to store validation record to cache: " + String.valueOf(e), e);
        }
    }

    public static class FilterJobResultByNamePredicate
    implements Predicate<Long, JobResult>,
    IdentifiedDataSerializable {
        private String name;

        public FilterJobResultByNamePredicate() {
        }

        FilterJobResultByNamePredicate(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(Map.Entry<Long, JobResult> entry) {
            return this.name.equals(entry.getValue().getJobConfig().getName());
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 18;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.name);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.name = in.readString();
        }
    }

    public static final class UpdateJobExecutionRecordEntryProcessor
    implements EntryProcessor<Long, JobExecutionRecord, Object>,
    IdentifiedDataSerializable {
        private long jobId;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="this class is not going to be java-serialized")
        private JobExecutionRecord jobExecutionRecord;
        private boolean canCreate;

        public UpdateJobExecutionRecordEntryProcessor() {
        }

        UpdateJobExecutionRecordEntryProcessor(long jobId, JobExecutionRecord jobExecutionRecord, boolean canCreate) {
            this.jobId = jobId;
            this.jobExecutionRecord = jobExecutionRecord;
            this.canCreate = canCreate;
        }

        @Override
        public Object process(Map.Entry<Long, JobExecutionRecord> entry) {
            if (entry.getValue() == null && !this.canCreate) {
                return "Update to JobRecord for job " + com.hazelcast.jet.Util.idToString(this.jobId) + " ignored, oldValue == null";
            }
            if (entry.getValue() != null && entry.getValue().getTimestamp() >= this.jobExecutionRecord.getTimestamp()) {
                return "Update to JobRecord for job " + com.hazelcast.jet.Util.idToString(this.jobId) + " ignored, newer timestamp found. Stored timestamp=" + entry.getValue().getTimestamp() + ", timestamp of the update=" + this.jobExecutionRecord.getTimestamp();
            }
            entry.setValue(this.jobExecutionRecord);
            return null;
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 16;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.jobId);
            out.writeObject(this.jobExecutionRecord);
            out.writeBoolean(this.canCreate);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.jobId = in.readLong();
            this.jobExecutionRecord = (JobExecutionRecord)in.readObject();
            this.canCreate = in.readBoolean();
        }
    }
}

