/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.JetMemberSelector;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.EnterpriseMasterSnapshotContext;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.MasterContext;
import com.hazelcast.jet.impl.MasterSnapshotContext;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnterpriseMasterContext
extends MasterContext {
    private static final JetMemberSelector NOT_INITIALIZED = new JetMemberSelector(){

        @Override
        public boolean testEx(Member member) {
            return false;
        }

        public String toString() {
            return "The member selector is not initialized";
        }
    };
    private JetMemberSelector memberSelector = NOT_INITIALIZED;

    EnterpriseMasterContext(NodeEngineImpl nodeEngine, JobCoordinationService coordinationService, @Nonnull JobRecord jobRecord, @Nonnull JobExecutionRecord jobExecutionRecord) {
        super(nodeEngine, coordinationService, jobRecord, jobExecutionRecord);
    }

    @Override
    MasterSnapshotContext createMasterSnapshotContext(NodeEngineImpl nodeEngine) {
        return new EnterpriseMasterSnapshotContext(this, nodeEngine.getLogger(MasterSnapshotContext.class));
    }

    @Override
    public EnterpriseMasterSnapshotContext snapshotContext() {
        return (EnterpriseMasterSnapshotContext)super.snapshotContext();
    }

    @Override
    JetMemberSelector memberSelector(@Nullable Supplier<DAG> dag) {
        if (this.memberSelector == NOT_INITIALIZED) {
            assert (dag != null);
            this.memberSelector = dag.get().memberSelector();
        }
        return this.memberSelector;
    }

    @Override
    public void setMemberSelector(JetMemberSelector memberSelector) {
        this.memberSelector = memberSelector;
    }

    @Override
    boolean maybeScaleUp(int dataMembersWithPartitionsCount) {
        this.coordinationService().assertOnCoordinatorThread();
        if (this.memberSelector == null) {
            return super.maybeScaleUp(dataMembersWithPartitionsCount);
        }
        if (!this.jobConfig().isAutoScaling()) {
            return true;
        }
        if (this.executionPlanMap() == null) {
            this.logger.fine("Not scaling up %s: job is not running", this.jobIdString());
            return true;
        }
        JobExecutionService jes = this.getJetServiceBackend().getJobExecutionService();
        ExecutionContext executionContext = jes.getExecutionContext(this.executionId());
        Set<Address> currentPlan = executionContext != null ? executionContext.participants() : this.executionPlanMap().keySet().stream().map(MemberInfo::getAddress).collect(Collectors.toSet());
        HashSet<Member> selectedMembers = new HashSet<Member>(this.nodeEngine().getClusterService().getMembers(this.memberSelector::testEx));
        if (currentPlan.isEmpty() || currentPlan.size() == selectedMembers.size()) {
            this.logger.fine("Not scaling up %s: not running or already running on all matching members", this.jobIdString());
            return true;
        }
        if (this.jobStatus() == JobStatus.RUNNING && this.jobContext().requestTermination(TerminationMode.RESTART_GRACEFUL, false, false).f1() == null) {
            this.logger.info("Requested restart of " + this.jobIdString() + " to make use of added member(s). Job was running on " + this.executionPlanMap().size() + " members, cluster now has " + selectedMembers.size() + " members matching the supplied member selector");
            return true;
        }
        return false;
    }
}

