/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.JetMemberSelector;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobAlreadyExistsException;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetCacheManagerImpl;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.observer.ObservableImpl;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.sql.SqlService;
import com.hazelcast.topic.ITopic;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public abstract class AbstractJetInstance<M>
implements JetInstance {
    private static final String FLAKE_ID_GENERATOR_JET_IDS_CREATE_DENIED_MESSAGE = "Permission \\(\"com.hazelcast.security.permission.FlakeIdGeneratorPermission\" \"__jet.ids\" \"create\"\\) denied!";
    private static final String MAP_JET_RESOURCES_CREATE_DENIED_MESSAGE = "Permission \\(\"com.hazelcast.security.permission.MapPermission\" \"__jet\\.resources\\..*\" \"create\"\\) denied!";
    private final HazelcastInstance hazelcastInstance;
    private final JetCacheManagerImpl cacheManager;
    private final Supplier<JobRepository> jobRepository;
    private final Map<String, Observable> observables;

    protected AbstractJetInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.cacheManager = new JetCacheManagerImpl(this);
        this.jobRepository = Util.memoizeConcurrent(() -> new JobRepository(hazelcastInstance));
        this.observables = new ConcurrentHashMap<String, Observable>();
    }

    public long newJobId() {
        try {
            return this.jobRepository.get().newJobId();
        }
        catch (AccessControlException e) {
            if (e.getMessage().matches(FLAKE_ID_GENERATOR_JET_IDS_CREATE_DENIED_MESSAGE)) {
                AccessControlException ace = new AccessControlException("Permission " + String.valueOf(new JobPermission(new String[]{"submit"})) + " denied!");
                ace.addSuppressed(e);
                throw ace;
            }
            throw e;
        }
    }

    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config, @Nullable Subject subject) {
        return this.newJobInt(this.newJobId(), dag, config, subject, false);
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        return this.newJobInt(this.newJobId(), dag, config, false);
    }

    @Nonnull
    public Job newJob(long jobId, @Nonnull DAG dag, @Nonnull JobConfig config) {
        return this.newJobInt(jobId, dag, config, false);
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJobInt(this.newJobId(), pipeline, config, false);
    }

    @Nonnull
    public Job newJob(long jobId, @Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJobInt(jobId, pipeline, config, false);
    }

    @Nonnull
    public Job newJob(long jobId, @Nonnull DAG dag, @Nonnull JobConfig config, @Nullable Subject subject) {
        return this.newJobInt(jobId, dag, config, subject, false);
    }

    private Job newJobInt(long jobId, @Nonnull Object jobDefinition, @Nonnull JobConfig config, boolean isLightJob) {
        return this.newJobInt(jobId, jobDefinition, config, null, isLightJob);
    }

    private Job newJobInt(long jobId, @Nonnull Object jobDefinition, @Nonnull JobConfig config, @Nullable Subject subject, boolean isLightJob) {
        if (isLightJob) {
            AbstractJetInstance.validateConfigForLightJobs(config);
        }
        if (jobDefinition instanceof PipelineImpl) {
            PipelineImpl pipelineImpl = (PipelineImpl)jobDefinition;
            config = config.attachAll(pipelineImpl.attachedFiles());
        }
        if (!config.getResourceConfigs().isEmpty()) {
            this.uploadResources(jobId, config);
        }
        return this.newJobProxy(jobId, isLightJob, jobDefinition, config, subject);
    }

    protected static void validateConfigForLightJobs(JobConfig config) {
        Preconditions.checkTrue(config.getName() == null, "JobConfig.name not supported for light jobs");
        Preconditions.checkTrue(config.getResourceConfigs().isEmpty(), "Resources (jars, classes, attached files) not supported for light jobs");
        Preconditions.checkTrue(config.getProcessingGuarantee() == ProcessingGuarantee.NONE, "A processing guarantee not supported for light jobs");
        Preconditions.checkTrue(config.getClassLoaderFactory() == null, "JobConfig.classLoaderFactory not supported for light jobs");
        Preconditions.checkTrue(config.getInitialSnapshotName() == null, "JobConfig.initialSnapshotName not supported for light jobs");
    }

    private Job newJobIfAbsent(@Nonnull Object jobDefinition, @Nonnull JobConfig config, @Nullable Subject subject) {
        if (config.getName() == null) {
            return this.newJobInt(this.newJobId(), jobDefinition, config, subject, false);
        }
        JobStatus status;
        Job job;
        while ((job = this.getJob(config.getName())) == null || (status = job.getStatus()) == JobStatus.FAILED || status == JobStatus.COMPLETED) {
            try {
                return this.newJobInt(this.newJobId(), jobDefinition, config, subject, false);
            }
            catch (JobAlreadyExistsException e) {
                this.getLogger().fine("Could not submit job with duplicate name: %s, ignoring", config.getName());
                continue;
            }
            break;
        }
        return job;
    }

    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config, @Nullable Subject subject) {
        return this.newJobIfAbsent((Object)dag, config, subject);
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
        return this.newJobIfAbsent((Object)dag, config, null);
    }

    @Override
    @Nonnull
    public Job newJobIfAbsent(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJobIfAbsent(pipeline, config, null);
    }

    @Override
    @Nonnull
    public Job newLightJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
        return this.newJobInt(this.newJobId(), pipeline, config, true);
    }

    @Override
    @Nonnull
    public Job newLightJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        return this.newJobInt(this.newJobId(), dag, config, true);
    }

    @Nonnull
    public Job newLightJob(@Nonnull DAG dag, @Nonnull JobConfig config, @Nullable Subject subject) {
        return this.newJobInt(this.newJobId(), dag, config, subject, true);
    }

    @Nonnull
    public Job newLightJob(long jobId, @Nonnull DAG dag, @Nonnull JobConfig config) {
        return this.newJobInt(jobId, dag, config, true);
    }

    @Nonnull
    public Job newLightJob(long jobId, @Nonnull DAG dag, @Nonnull JobConfig config, @Nullable Subject subject) {
        return this.newJobInt(jobId, dag, config, subject, true);
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        return this.mergeJobIdsResults(this.getJobsInt(null, null));
    }

    @Override
    @Nonnull
    public List<Job> getJobs(@Nonnull String name) {
        return this.mergeJobIdsResults(this.getJobsInt(name, null));
    }

    @Override
    @Nullable
    public Job getJob(long jobId) {
        List<Job> jobs = this.mergeJobIdsResults(this.getJobsInt(null, jobId));
        assert (jobs.size() <= 1);
        return jobs.isEmpty() ? null : jobs.get(0);
    }

    @Nonnull
    private List<Job> mergeJobIdsResults(Map<M, GetJobIdsOperation.GetJobIdsResult> results) {
        return results.entrySet().stream().flatMap(en -> IntStream.range(0, ((GetJobIdsOperation.GetJobIdsResult)en.getValue()).getJobIds().length).mapToObj(i -> {
            long jobId = ((GetJobIdsOperation.GetJobIdsResult)en.getValue()).getJobIds()[i];
            boolean isLightJob = ((GetJobIdsOperation.GetJobIdsResult)en.getValue()).getIsLightJobs()[i];
            return this.newJobProxy(jobId, isLightJob ? (M)en.getKey() : null);
        })).filter(Util.distinctBy(Job::getId)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public JobStateSnapshot getJobStateSnapshot(@Nonnull String name) {
        String mapName = JobRepository.exportedSnapshotMapName(name);
        if (!this.existsDistributedObject("hz:impl:mapService", mapName)) {
            return null;
        }
        IMap map = this.getHazelcastInstance().getMap(mapName);
        Object validationRecord = map.get((Object)SnapshotValidationRecord.KEY);
        if (validationRecord instanceof SnapshotValidationRecord) {
            SnapshotValidationRecord snapshotValidationRecord = (SnapshotValidationRecord)validationRecord;
            this.getHazelcastInstance().getMap("__jet.exportedSnapshotsCache").set(name, validationRecord);
            return new JobStateSnapshot(this.getHazelcastInstance(), name, snapshotValidationRecord);
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<JobStateSnapshot> getJobStateSnapshots() {
        return this.getHazelcastInstance().getMap("__jet.exportedSnapshotsCache").entrySet().stream().map(entry -> new JobStateSnapshot(this.getHazelcastInstance(), (String)entry.getKey(), (SnapshotValidationRecord)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.hazelcastInstance.getCluster();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.hazelcastInstance.getName();
    }

    @Override
    @Nonnull
    public SqlService getSql() {
        return this.hazelcastInstance.getSql();
    }

    @Override
    @Nonnull
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.hazelcastInstance.getMap(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.hazelcastInstance.getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.hazelcastInstance.getList(name);
    }

    @Nonnull
    public <T> ITopic<T> getReliableTopic(@Nonnull String name) {
        return this.hazelcastInstance.getReliableTopic(name);
    }

    @Override
    @Nonnull
    public JetCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    @Nonnull
    public <T> Observable<T> getObservable(@Nonnull String name) {
        return this.observables.computeIfAbsent(name, observableName -> new ObservableImpl((String)observableName, this.hazelcastInstance, this::onDestroy, this.getLogger()));
    }

    @Override
    @Nonnull
    public Collection<Observable<?>> getObservables() {
        return this.hazelcastInstance.getDistributedObjects().stream().filter(o -> o.getServiceName().equals("hz:impl:ringbufferService")).filter(o -> o.getName().startsWith("__jet.observables.")).map(o -> o.getName().substring("__jet.observables.".length())).map(this::getObservable).collect(Collectors.toList());
    }

    @Override
    public void shutdown() {
        this.hazelcastInstance.shutdown();
    }

    private void onDestroy(Observable<?> observable) {
        this.observables.remove(observable.name());
    }

    public abstract boolean existsDistributedObject(@Nonnull String var1, @Nonnull String var2);

    private void uploadResources(long jobId, JobConfig config) {
        try {
            this.jobRepository.get().uploadJobResources(jobId, config);
        }
        catch (AccessControlException e) {
            if (e.getMessage().matches(MAP_JET_RESOURCES_CREATE_DENIED_MESSAGE)) {
                AccessControlException ace = new AccessControlException("Permission " + String.valueOf(new JobPermission(new String[]{"add-resources"})) + " denied!");
                ace.addSuppressed(e);
                throw ace;
            }
            throw e;
        }
    }

    public abstract ILogger getLogger();

    public abstract Job newJobProxy(long var1, M var3);

    public abstract Job newJobProxy(long var1, boolean var3, @Nonnull Object var4, @Nonnull JobConfig var5, @Nullable Subject var6);

    public abstract Map<M, GetJobIdsOperation.GetJobIdsResult> getJobsInt(String var1, Long var2);

    public abstract M getMasterId();

    @Override
    public JobBuilderImpl newJobBuilder(@Nonnull DAG dag) {
        return new JobBuilderImpl(dag);
    }

    @Override
    public JobBuilderImpl newJobBuilder(@Nonnull Pipeline pipeline) {
        return new JobBuilderImpl(pipeline);
    }

    public class JobBuilderImpl
    implements JetService.JobBuilder {
        @Nonnull
        private final Object jobDefinition;
        @Nullable
        private JobConfig config;
        private boolean isLightJob;

        JobBuilderImpl(DAG dag) {
            this.jobDefinition = dag;
        }

        JobBuilderImpl(Pipeline pipeline) {
            this.jobDefinition = pipeline;
        }

        @Override
        public JobBuilderImpl withConfig(@Nonnull JobConfig jobConfig) {
            this.config = jobConfig;
            return this;
        }

        @Override
        public JobBuilderImpl withMemberSelector(@Nonnull JetMemberSelector memberSelector) {
            Object object = this.jobDefinition;
            if (object instanceof DAG) {
                DAG dag = (DAG)object;
                dag.setMemberSelector(memberSelector);
            } else {
                ((PipelineImpl)this.jobDefinition).setMemberSelector(memberSelector);
            }
            return this;
        }

        @Override
        public JobBuilderImpl asLightJob() {
            this.isLightJob = true;
            return this;
        }

        @Nonnull
        private JobConfig getConfig() {
            return this.config != null ? this.config : new JobConfig();
        }

        @Override
        public Job start() {
            return AbstractJetInstance.this.newJobInt(AbstractJetInstance.this.newJobId(), this.jobDefinition, this.getConfig(), this.isLightJob);
        }

        @Override
        public Job startIfAbsent() {
            if (this.isLightJob) {
                throw new UnsupportedOperationException();
            }
            return AbstractJetInstance.this.newJobIfAbsent(this.jobDefinition, this.getConfig(), null);
        }
    }
}

