/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.license.domain.License;
import com.hazelcast.logging.ILogger;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;

public class TrialLicenseExpirationCheckerTask
implements Runnable {
    private final Node node;
    private final ILogger logger;
    private final License license;

    public TrialLicenseExpirationCheckerTask(@Nonnull Node node, @Nonnull License license) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        this.license = license;
    }

    @Override
    public void run() {
        ZonedDateTime now = ZonedDateTime.now();
        if (this.license.getExpiryDate().isBefore(now)) {
            this.logger.severe("Trial license has expired. Hazelcast instance is gracefully shutting down.");
            this.node.shutdown(false);
        }
    }
}

