/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.tpcengine.util.JVM;
import com.hazelcast.internal.util.JavaMajorVersion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;

public enum JavaVersion implements JavaMajorVersion
{
    JAVA_18(18),
    JAVA_19(19),
    JAVA_20(20),
    JAVA_21(21);

    public static final JavaMajorVersion UNKNOWN_VERSION;
    public static final JavaMajorVersion CURRENT_VERSION;
    private final int majorVersion;

    private JavaVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public static boolean isAtLeast(JavaVersion version) {
        return JavaVersion.isAtLeast(CURRENT_VERSION, version);
    }

    public static boolean isAtMost(JavaVersion version) {
        return CURRENT_VERSION != UNKNOWN_VERSION && version != UNKNOWN_VERSION && CURRENT_VERSION.getMajorVersion() <= version.getMajorVersion();
    }

    static boolean isAtLeast(JavaMajorVersion currentVersion, JavaMajorVersion minVersion) {
        return currentVersion != UNKNOWN_VERSION && minVersion != UNKNOWN_VERSION && currentVersion.getMajorVersion() >= minVersion.getMajorVersion();
    }

    static JavaMajorVersion detectCurrentVersion() {
        ILogger logger = Logger.getLogger(JavaVersion.class);
        int major = JVM.getMajorVersion();
        if (logger.isFineEnabled()) {
            logger.fine("Detected runtime version: Java " + major);
        }
        return Arrays.stream(JavaVersion.values()).filter(v -> v.getMajorVersion() == major).findFirst().orElseGet(() -> new FutureJavaVersion(major));
    }

    public static void main(String[] args) {
        System.out.println(CURRENT_VERSION.getMajorVersion());
    }

    static {
        UNKNOWN_VERSION = new UnknownVersion();
        CURRENT_VERSION = JavaVersion.detectCurrentVersion();
    }

    static class FutureJavaVersion
    implements JavaMajorVersion {
        private final int majorVersion;

        FutureJavaVersion(int majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public Integer getMajorVersion() {
            return this.majorVersion;
        }
    }

    static class UnknownVersion
    implements JavaMajorVersion {
        UnknownVersion() {
        }

        @Override
        public Integer getMajorVersion() {
            return null;
        }
    }
}

