/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InstanceTrackingUtil {
    public static final String HAZELCAST_CONFIG_INSTANCE_TRACKING_FILE = "hazelcast.config.instance.tracking.file";

    private InstanceTrackingUtil() {
    }

    public static void writeInstanceTrackingFile(@Nullable String fileName, @Nullable String formatPattern, @Nonnull Map<String, Object> placeholderValues, @Nonnull ILogger logger) {
        try {
            String trackingFileContents = InstanceTrackingUtil.getInstanceTrackingContent(formatPattern, placeholderValues);
            Path file = InstanceTrackingUtil.getInstanceTrackingFilePath(fileName, placeholderValues);
            System.setProperty(HAZELCAST_CONFIG_INSTANCE_TRACKING_FILE, file.toString());
            logger.fine("Writing instance tracking information to " + String.valueOf(file));
            Files.writeString(file, (CharSequence)trackingFileContents, new OpenOption[0]);
        }
        catch (Exception e) {
            logger.warning("Failed to write instance tracking information", e);
        }
    }

    private static Path getInstanceTrackingFilePath(String fileName, Map<String, Object> trackingFileProperties) {
        if (fileName == null) {
            return InstanceTrackingConfig.DEFAULT_FILE;
        }
        return Paths.get(StringUtil.resolvePlaceholders(fileName, "HZ_INSTANCE_TRACKING", trackingFileProperties), new String[0]);
    }

    private static String getInstanceTrackingContent(String formatPattern, Map<String, Object> propertyValues) {
        if (formatPattern == null) {
            JsonObject jsonObject = new JsonObject();
            propertyValues.forEach((prop, value) -> {
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    jsonObject.add((String)prop, booleanValue);
                } else if (value instanceof Integer) {
                    Integer integerValue = (Integer)value;
                    jsonObject.add((String)prop, integerValue);
                } else if (value instanceof Long) {
                    Long longValue = (Long)value;
                    jsonObject.add((String)prop, longValue);
                } else {
                    jsonObject.add((String)prop, value.toString());
                }
            });
            return jsonObject.toString();
        }
        return StringUtil.resolvePlaceholders(formatPattern, "HZ_INSTANCE_TRACKING", propertyValues);
    }
}

