/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.impl.PagePinnedOffsets;
import com.hazelcast.internal.tstore.hybridlog.impl.PageState;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;

class PageMetadata {
    static final int PAGE_UNSET = -1;
    static final long EPOCH_NOT_KNOWN_YET = -1L;
    private static final AtomicIntegerFieldUpdater<PageMetadata> PAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PageMetadata.class, "page");
    private static final AtomicLongFieldUpdater<PageMetadata> PHYSICAL_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(PageMetadata.class, "physicalAddress");
    private static final AtomicLongFieldUpdater<PageMetadata> ACCESSIBLE_UNTIL_EPOCH_UPDATER = AtomicLongFieldUpdater.newUpdater(PageMetadata.class, "accessibleUntilEpoch");
    private static final AtomicLongFieldUpdater<PageMetadata> MUTABLE_UNTIL_EPOCH_UPDATER = AtomicLongFieldUpdater.newUpdater(PageMetadata.class, "mutableUntilEpoch");
    private final AtomicReference<PageState> stateRef = new AtomicReference<PageState>(PageState.NOT_BACKED);
    private volatile int page = -1;
    private volatile long physicalAddress = 0L;
    private volatile long accessibleUntilEpoch = -1L;
    private volatile long mutableUntilEpoch = -1L;
    private final PagePinnedOffsets pinnedOffsets = new PagePinnedOffsets();
    private final ILogger logger = Logger.getLogger(PageMetadata.class);
    private final boolean finestEnabled = this.logger.isFinestEnabled();

    PageMetadata() {
    }

    PageMetadata(int page) {
        this();
        this.page = page;
    }

    boolean prepareFor(int page) {
        return PAGE_UPDATER.compareAndSet(this, -1, page);
    }

    boolean release() {
        boolean unused;
        assert (!this.pinnedOffsets.isAnyOffsetPinned()) : TStoreUtil.loggingAssertMessage(this.logger, "Releasing pinned %s", this);
        int pageLocalCopy = this.page;
        boolean bl = unused = pageLocalCopy != -1 && PAGE_UPDATER.compareAndSet(this, this.page, -1);
        if (!unused) {
            return false;
        }
        if (this.finestEnabled) {
            this.logger.finest("Releasing " + String.valueOf(this));
        }
        this.page = -1;
        this.physicalAddress = 0L;
        this.accessibleUntilEpoch = -1L;
        this.mutableUntilEpoch = -1L;
        this.pinnedOffsets.clear();
        return true;
    }

    void reset() {
        assert (this.state() == PageState.NOT_BACKED) : TStoreUtil.loggingAssertMessage(this.logger, "PageMetadata is in unexpected state: %s", this);
        if (this.finestEnabled) {
            this.logger.finest("Resetting " + String.valueOf(this));
        }
        this.page = -1;
        this.stateRef.set(PageState.NOT_BACKED);
        this.physicalAddress = 0L;
        this.accessibleUntilEpoch = -1L;
        this.mutableUntilEpoch = -1L;
    }

    int page() {
        return this.page;
    }

    long physicalAddress() {
        return this.physicalAddress;
    }

    PageState state() {
        return this.stateRef.get();
    }

    long accessibleUntilEpoch() {
        return this.accessibleUntilEpoch;
    }

    boolean setAccessibleUntilEpoch(long accessibleUntilEpoch) {
        assert (this.mutableUntilEpoch != -1L && this.mutableUntilEpoch < accessibleUntilEpoch) : TStoreUtil.loggingAssertMessage(this.logger, "Unexpected state when setting accessibleUntilEpoch %d in %s", accessibleUntilEpoch, this);
        return this.casAccessibleUntilEpoch(-1L, accessibleUntilEpoch);
    }

    long mutableUntilEpoch() {
        return this.mutableUntilEpoch;
    }

    boolean casAccessibleUntilEpoch(long oldAccessibleUntilEpoch, long accessibleUntilEpoch) {
        return ACCESSIBLE_UNTIL_EPOCH_UPDATER.compareAndSet(this, oldAccessibleUntilEpoch, accessibleUntilEpoch);
    }

    void clearAccessibleUntilEpoch() {
        this.accessibleUntilEpoch = -1L;
    }

    boolean setMutableUntilEpoch(long mutableUntilEpoch) {
        assert (this.accessibleUntilEpoch == -1L) : TStoreUtil.loggingAssertMessage(this.logger, "Unexpected state when setting mutableUntilEpoch %d in %s", mutableUntilEpoch, this);
        return MUTABLE_UNTIL_EPOCH_UPDATER.compareAndSet(this, -1L, mutableUntilEpoch);
    }

    boolean casState(PageState expectedState, PageState newState) {
        return this.stateRef.compareAndSet(expectedState, newState);
    }

    void forceSetState(PageState newState) {
        this.stateRef.set(newState);
    }

    boolean casPhysicalAddress(long expectedAddress, long newAddress) {
        return PHYSICAL_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    PagePinnedOffsets pinnedOffsets() {
        return this.pinnedOffsets;
    }

    public String toString() {
        return "PageMetadata{instance=inst:0x0" + Integer.toHexString(System.identityHashCode(this)) + ", page=" + String.valueOf(this.toPageStr()) + ", physicalAddress=" + TStoreUtil.prettyFormatPhysical(this.physicalAddress) + ", state=" + String.valueOf((Object)this.stateRef.get()) + ", accessibleUntilEpoch=" + PageMetadata.epochStr(this.accessibleUntilEpoch) + ", mutableUntilEpoch=" + PageMetadata.epochStr(this.mutableUntilEpoch) + ", pagePinType=" + String.valueOf((Object)this.pinnedOffsets.pagePinType()) + "}";
    }

    private Object toPageStr() {
        int pageCopy = this.page;
        return pageCopy == -1 ? "FREE" : Integer.valueOf(pageCopy);
    }

    static String epochStr(long epoch) {
        return epoch == -1L ? "N/A" : Long.toString(epoch);
    }
}

